/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.util;

import com.oracle.graal.python.util.IntPredicate;
import com.oracle.truffle.api.CompilerDirectives;

public final class ComparisonOp
extends Enum<ComparisonOp> {
    public static final /* enum */ ComparisonOp EQ = new ComparisonOp("__eq__", 2, a -> a == 0);
    public static final /* enum */ ComparisonOp NE = new ComparisonOp("__ne__", 3, a -> a != 0);
    public static final /* enum */ ComparisonOp LT = new ComparisonOp("__lt__", 0, a -> a < 0);
    public static final /* enum */ ComparisonOp GT = new ComparisonOp("__gt__", 4, a -> a > 0);
    public static final /* enum */ ComparisonOp LE = new ComparisonOp("__le__", 1, a -> a <= 0);
    public static final /* enum */ ComparisonOp GE = new ComparisonOp("__ge__", 5, a -> a >= 0);
    public final String builtinName;
    public final int opCode;
    public final IntPredicate intPredicate;
    private static final /* synthetic */ ComparisonOp[] $VALUES;

    public static ComparisonOp[] values() {
        return (ComparisonOp[])$VALUES.clone();
    }

    public static ComparisonOp valueOf(String name) {
        return Enum.valueOf(ComparisonOp.class, name);
    }

    private ComparisonOp(String builtinName, int opCode, IntPredicate intPredicate) {
        this.builtinName = builtinName;
        this.opCode = opCode;
        this.intPredicate = intPredicate;
    }

    public boolean cmpResultToBool(int cmpResult) {
        return this.intPredicate.test(cmpResult);
    }

    public boolean isEqualityOp() {
        return this == EQ || this == NE;
    }

    public static boolean isEqualityOpCode(int op) {
        assert (ComparisonOp.EQ.opCode == 2 && ComparisonOp.NE.opCode == 3);
        return op == 2 || op == 3;
    }

    public static ComparisonOp fromOpCode(int op) {
        ComparisonOp result = switch (op) {
            case 0 -> LT;
            case 1 -> LE;
            case 2 -> EQ;
            case 3 -> NE;
            case 4 -> GT;
            case 5 -> GE;
            default -> {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw CompilerDirectives.shouldNotReachHere((String)("unexpected operation: " + op));
            }
        };
        assert (result.opCode == op);
        return result;
    }

    private static /* synthetic */ ComparisonOp[] $values() {
        return new ComparisonOp[]{EQ, NE, LT, GT, LE, GE};
    }

    static {
        $VALUES = ComparisonOp.$values();
    }
}

