/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.util;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.ellipsis.PEllipsis;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.function.BuiltinFunctionRootNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.pegparser.scope.ScopeEnvironment;
import com.oracle.graal.python.pegparser.sst.ConstantValue;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.object.PythonObjectSlowPathFactory;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.memory.ByteArraySupport;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.api.strings.TruffleStringBuilderUTF32;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.VMRuntime;
import org.graalvm.polyglot.io.ByteSequence;
import sun.misc.Unsafe;

public final class PythonUtils {
    public static final ByteArraySupport ARRAY_ACCESSOR_LE = ByteArraySupport.littleEndian();
    public static final ByteArraySupport ARRAY_ACCESSOR_BE = ByteArraySupport.bigEndian();
    public static final ByteArraySupport ARRAY_ACCESSOR = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? ARRAY_ACCESSOR_LE : ARRAY_ACCESSOR_BE;
    public static final ByteArraySupport ARRAY_ACCESSOR_SWAPPED = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? ARRAY_ACCESSOR_BE : ARRAY_ACCESSOR_LE;
    public static final ConditionProfile[] DISABLED = new ConditionProfile[]{ConditionProfile.getUncached()};
    public static final TruffleString.Encoding TS_ENCODING = TruffleString.Encoding.UTF_32;
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final TruffleString[] EMPTY_TRUFFLESTRING_ARRAY = new TruffleString[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final ByteSequence EMPTY_BYTE_SEQUENCE = ByteSequence.create((byte[])EMPTY_BYTE_ARRAY);
    private static final MBeanServer SERVER;
    private static final String OPERATION_NAME = "gcRun";
    private static final Object[] PARAMS;
    private static final String[] SIGNATURE;
    private static final ObjectName OBJECT_NAME;
    private static final int[] CRC_32_TAB;
    static final int[] CRC_HQX_TAB;

    public static ByteArraySupport byteArraySupport(ByteOrder order) {
        return order == ByteOrder.LITTLE_ENDIAN ? ARRAY_ACCESSOR_LE : ARRAY_ACCESSOR_BE;
    }

    private PythonUtils() {
    }

    public static TruffleStringBuilderUTF32 createStringBuilder() {
        return TruffleStringBuilder.createUTF32();
    }

    public static int tsbCapacity(int cpCount) {
        assert (TS_ENCODING == TruffleString.Encoding.UTF_32);
        return 4 * cpCount;
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString tsLiteral(String s) {
        assert (s != null);
        return TruffleString.fromConstant((String)s, (TruffleString.Encoding)TS_ENCODING);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString toTruffleStringUncached(String s) {
        return s == null ? null : TruffleString.fromJavaStringUncached((String)s, (TruffleString.Encoding)TS_ENCODING);
    }

    public static PString toPString(TruffleString name) {
        return new PString((Object)PythonBuiltinClassType.PString, PythonBuiltinClassType.PString.getInstanceShape(PythonLanguage.get(null)), name);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString[] tsArray(String ... s) {
        TruffleString[] result = new TruffleString[s.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = PythonUtils.tsLiteral(s[i]);
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString[] toTruffleStringArrayUncached(String[] s) {
        if (s == null) {
            return null;
        }
        if (s.length == 0) {
            return EMPTY_TRUFFLESTRING_ARRAY;
        }
        TruffleString[] result = new TruffleString[s.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = PythonUtils.toTruffleStringUncached(s[i]);
        }
        return result;
    }

    public static Object[] convertToObjectArray(TruffleString[] src) {
        if (src == null) {
            return null;
        }
        if (src.length == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] result = new Object[src.length];
        for (int i = 0; i < src.length; ++i) {
            result[i] = src[i];
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString mangleName(TruffleString className, TruffleString name) {
        return PythonUtils.toTruffleStringUncached(ScopeEnvironment.mangle(className.toJavaStringUncached(), name.toJavaStringUncached()));
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString getMessage(Exception ex) {
        return PythonUtils.toTruffleStringUncached(ex.getMessage());
    }

    public static void fill(byte[] array, int from, int to, byte value) {
        try {
            Arrays.fill(array, from, to, value);
        }
        catch (Throwable t) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw t;
        }
    }

    public static void fill(Object[] array, int from, int to, Object value) {
        try {
            Arrays.fill(array, from, to, value);
        }
        catch (Throwable t) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw t;
        }
    }

    public static void arraycopy(Object src, int srcPos, Object dest, int destPos, int length) {
        try {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }
        catch (Throwable t) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw t;
        }
    }

    public static <T> T[] arrayCopyOfRange(T[] original, int from, int to) {
        try {
            return Arrays.copyOfRange(original, from, to);
        }
        catch (Throwable t) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw t;
        }
    }

    public static byte[] arrayCopyOfRange(byte[] original, int from, int to) {
        try {
            return Arrays.copyOfRange(original, from, to);
        }
        catch (Throwable t) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw t;
        }
    }

    public static <T> T[] arrayCopyOf(T[] original, int newLength) {
        try {
            return Arrays.copyOf(original, newLength);
        }
        catch (Throwable t) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw t;
        }
    }

    public static char[] arrayCopyOf(char[] original, int newLength) {
        try {
            return Arrays.copyOf(original, newLength);
        }
        catch (Throwable t) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw t;
        }
    }

    public static boolean[] arrayCopyOf(boolean[] original, int newLength) {
        try {
            return Arrays.copyOf(original, newLength);
        }
        catch (Throwable t) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw t;
        }
    }

    public static byte[] arrayCopyOf(byte[] original, int newLength) {
        try {
            return Arrays.copyOf(original, newLength);
        }
        catch (Throwable t) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw t;
        }
    }

    public static int[] arrayCopyOf(int[] original, int newLength) {
        try {
            return Arrays.copyOf(original, newLength);
        }
        catch (Throwable t) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw t;
        }
    }

    public static double[] arrayCopyOf(double[] original, int newLength) {
        try {
            return Arrays.copyOf(original, newLength);
        }
        catch (Throwable t) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw t;
        }
    }

    public static long[] arrayCopyOf(long[] original, int newLength) {
        try {
            return Arrays.copyOf(original, newLength);
        }
        catch (Throwable t) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw t;
        }
    }

    public static int addExact(int x, int y) throws OverflowException {
        int r = x + y;
        if (((x ^ r) & (y ^ r)) < 0) {
            throw OverflowException.INSTANCE;
        }
        return r;
    }

    public static long addExact(long x, long y) throws OverflowException {
        long r = x + y;
        if (((x ^ r) & (y ^ r)) < 0L) {
            throw OverflowException.INSTANCE;
        }
        return r;
    }

    public static int subtractExact(int x, int y) throws OverflowException {
        int r = x - y;
        if (((x ^ y) & (x ^ r)) < 0) {
            throw OverflowException.INSTANCE;
        }
        return r;
    }

    public static long subtractExact(long x, long y) throws OverflowException {
        long r = x - y;
        if (((x ^ y) & (x ^ r)) < 0L) {
            throw OverflowException.INSTANCE;
        }
        return r;
    }

    public static int negateExact(int a) throws OverflowException {
        if (a == Integer.MIN_VALUE) {
            throw OverflowException.INSTANCE;
        }
        return -a;
    }

    public static long negateExact(long a) throws OverflowException {
        if (a == Long.MIN_VALUE) {
            throw OverflowException.INSTANCE;
        }
        return -a;
    }

    public static int toIntExact(long x) throws OverflowException {
        int r = (int)x;
        if ((long)r != x) {
            throw OverflowException.INSTANCE;
        }
        return r;
    }

    public static int toIntError(long x) {
        int r = (int)x;
        if ((long)r != x) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw PRaiseNode.raiseUncached(null, PythonBuiltinClassType.SystemError, ErrorMessages.INTERNAL_INT_OVERFLOW);
        }
        return r;
    }

    public static int multiplyExact(int x, int y) throws OverflowException {
        long r = (long)x * (long)y;
        if ((long)((int)r) != r) {
            throw OverflowException.INSTANCE;
        }
        return (int)r;
    }

    public static long multiplyExact(long x, long y) throws OverflowException {
        long ay;
        long r = x * y;
        long ax = Math.abs(x);
        if ((ax | (ay = Math.abs(y))) >>> 31 != 0L && (y != 0L && r / y != x || x == Long.MIN_VALUE && y == -1L)) {
            throw OverflowException.INSTANCE;
        }
        return r;
    }

    public static boolean isDivisible(int number, int twoExponent) {
        assert (number >= 0);
        return (-1 << twoExponent & number) == number;
    }

    @CompilerDirectives.TruffleBoundary
    public static void forceFullGC() {
        if (OBJECT_NAME != null && SERVER != null) {
            try {
                SERVER.invoke(OBJECT_NAME, OPERATION_NAME, PARAMS, SIGNATURE);
            }
            catch (InstanceNotFoundException | MBeanException | ReflectionException jMException) {
                // empty catch block
            }
        }
        System.gc();
        Runtime.getRuntime().freeMemory();
    }

    @CompilerDirectives.TruffleBoundary
    public static void dumpHeap(String path) {
        if (ImageInfo.inImageCode()) {
            try {
                VMRuntime.dumpHeap((String)path, (boolean)true);
            }
            catch (IOException | UnsupportedOperationException e) {
                System.err.println("Heap dump creation failed." + e.getMessage());
                e.printStackTrace();
            }
        } else if (SERVER != null) {
            try {
                Class<?> mxBeanClass = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
                Object mxBean = ManagementFactory.newPlatformMXBeanProxy(SERVER, "com.sun.management:type=HotSpotDiagnostic", mxBeanClass);
                mxBeanClass.getMethod("dumpHeap", String.class, Boolean.TYPE).invoke(mxBean, path, true);
            }
            catch (Throwable e) {
                System.err.println("Cannot dump heap: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static RootCallTarget getOrCreateCallTarget(RootNode rootNode) {
        return rootNode.getCallTarget();
    }

    @CompilerDirectives.TruffleBoundary
    public static String formatJString(String fmt, Object ... args) {
        return String.format(fmt, args);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString getPythonArch() {
        String arch = System.getProperty("os.arch", "");
        if (arch.equals("amd64")) {
            arch = "x86_64";
        }
        return PythonUtils.toTruffleStringUncached(arch);
    }

    @CompilerDirectives.TruffleBoundary
    public static ByteBuffer allocateByteBuffer(int capacity) {
        return ByteBuffer.allocate(capacity);
    }

    @CompilerDirectives.TruffleBoundary
    public static ByteBuffer wrapByteBuffer(byte[] array) {
        return ByteBuffer.wrap(array);
    }

    @CompilerDirectives.TruffleBoundary
    public static ByteBuffer wrapByteBuffer(byte[] array, int offset, int length) {
        return ByteBuffer.wrap(array, offset, length);
    }

    @CompilerDirectives.TruffleBoundary
    public static byte[] getBufferArray(ByteBuffer buffer) {
        return buffer.array();
    }

    @CompilerDirectives.TruffleBoundary
    public static int getBufferPosition(ByteBuffer buffer) {
        return buffer.position();
    }

    @CompilerDirectives.TruffleBoundary
    public static int getBufferLimit(ByteBuffer buffer) {
        return buffer.limit();
    }

    @CompilerDirectives.TruffleBoundary
    public static int getBufferRemaining(ByteBuffer buffer) {
        return buffer.remaining();
    }

    @CompilerDirectives.TruffleBoundary
    public static void flipBuffer(ByteBuffer buffer) {
        buffer.flip();
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean bufferHasRemaining(ByteBuffer buffer) {
        return buffer.hasRemaining();
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean equals(Object a, Object b) {
        return a.equals(b);
    }

    @CompilerDirectives.TruffleBoundary
    public static <E> ArrayDeque<E> newDeque() {
        return new ArrayDeque();
    }

    @CompilerDirectives.TruffleBoundary
    public static <E> void push(ArrayDeque<E> q, E e) {
        q.push(e);
    }

    @CompilerDirectives.TruffleBoundary
    public static <E> E pop(ArrayDeque<E> q) {
        return q.pop();
    }

    @CompilerDirectives.TruffleBoundary
    public static <E> List<E> newList() {
        return new ArrayList();
    }

    @CompilerDirectives.TruffleBoundary
    public static <E> void add(List<E> list, E e) {
        list.add(e);
    }

    @CompilerDirectives.TruffleBoundary
    public static <E> E get(List<E> list, int index) {
        return list.get(index);
    }

    @CompilerDirectives.TruffleBoundary
    public static <E> Object[] toArray(List<E> list) {
        return list.toArray();
    }

    public static boolean isBmpCodePoint(int codePoint) {
        return codePoint >>> 16 == 0;
    }

    public static ValueProfile createValueIdentityProfile() {
        CompilerAsserts.neverPartOfCompilation();
        return PythonLanguage.get(null).isSingleContext() ? ValueProfile.createIdentityProfile() : ValueProfile.createClassProfile();
    }

    @CompilerDirectives.TruffleBoundary
    public static PBuiltinFunction createMethod(PythonLanguage language, Object klass, NodeFactory<? extends PythonBuiltinBaseNode> nodeFactory, Object type, int numDefaults) {
        Class nodeClass = nodeFactory.getNodeClass();
        Builtin builtin = nodeClass.getAnnotation(Builtin.class);
        RootCallTarget callTarget = language.createCachedCallTarget(l -> new BuiltinFunctionRootNode((PythonLanguage)((Object)l), builtin, nodeFactory, true), nodeClass);
        return PythonUtils.createMethod(PythonObjectFactory.getUncached(), klass, builtin, callTarget, type, numDefaults);
    }

    @CompilerDirectives.TruffleBoundary
    public static PBuiltinFunction createMethod(PythonObjectFactory factory, Object klass, Builtin builtin, RootCallTarget callTarget, Object type, int numDefaults) {
        BuiltinFunctionRootNode r;
        RootNode rootNode;
        assert ((rootNode = callTarget.getRootNode()) instanceof BuiltinFunctionRootNode && (r = (BuiltinFunctionRootNode)rootNode).getBuiltin() == builtin);
        int flags = PBuiltinFunction.getFlags(builtin, callTarget);
        TruffleString name = PythonUtils.toTruffleStringUncached(builtin.name());
        PBuiltinFunction function = factory.createBuiltinFunction(name, type, numDefaults, flags, callTarget);
        if (klass != null) {
            WriteAttributeToObjectNode.getUncached(true).execute(klass, name, function);
        }
        return function;
    }

    @CompilerDirectives.TruffleBoundary
    public static void createConstructor(PythonObjectSlowPathFactory factory, Object klass, Builtin builtin, RootCallTarget callTarget) {
        assert ("__new__".equals(builtin.name()));
        assert (IsSubtypeNode.getUncached().execute(klass, (Object)PythonBuiltinClassType.PTuple));
        int flags = PBuiltinFunction.getFlags(builtin, callTarget);
        PBuiltinFunction function = factory.createBuiltinFunction(PythonUtils.toTruffleStringUncached(builtin.name()), (Object)PythonBuiltinClassType.PTuple, 1, flags, callTarget);
        PBuiltinMethod method = factory.createBuiltinMethod((Object)PythonBuiltinClassType.PTuple, function);
        WriteAttributeToObjectNode.getUncached(true).execute(klass, SpecialMethodNames.T___NEW__, method);
    }

    private static Object[] createCalltargetKeys(Object[] callTargetCacheKeys, Class<?> nodeClass) {
        Object[] keys = new Object[callTargetCacheKeys.length + 1];
        keys[0] = nodeClass;
        PythonUtils.arraycopy(callTargetCacheKeys, 0, keys, 1, callTargetCacheKeys.length);
        return keys;
    }

    public static Unsafe initUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException se) {
            try {
                Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafe.setAccessible(true);
                return (Unsafe)theUnsafe.get(Unsafe.class);
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("Cannot initialize Unsafe for the native backends", e);
            }
        }
    }

    public static void copyFrameSlot(Frame frameToSync, MaterializedFrame target, int slot) {
        if (frameToSync.isObject(slot)) {
            target.setObject(slot, frameToSync.getObject(slot));
        } else if (frameToSync.isInt(slot)) {
            target.setInt(slot, frameToSync.getInt(slot));
        } else if (frameToSync.isLong(slot)) {
            target.setLong(slot, frameToSync.getLong(slot));
        } else if (frameToSync.isBoolean(slot)) {
            target.setBoolean(slot, frameToSync.getBoolean(slot));
        } else if (frameToSync.isDouble(slot)) {
            target.setDouble(slot, frameToSync.getDouble(slot));
        } else if (frameToSync.isFloat(slot)) {
            target.setFloat(slot, frameToSync.getFloat(slot));
        } else if (frameToSync.isByte(slot)) {
            target.setByte(slot, frameToSync.getByte(slot));
        }
    }

    public static TruffleString[] objectArrayToTruffleStringArray(Node inliningTarget, Object[] array, CastToTruffleStringNode cast) {
        if (array.length == 0) {
            return EMPTY_TRUFFLESTRING_ARRAY;
        }
        TruffleString[] result = new TruffleString[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = cast.execute(inliningTarget, array[i]);
        }
        return result;
    }

    public static Source createFakeSource() {
        return PythonUtils.createFakeSource(StringLiterals.T_EMPTY_STRING);
    }

    @CompilerDirectives.TruffleBoundary
    public static Source createFakeSource(TruffleString name) {
        return Source.newBuilder((String)"python", (ByteSequence)EMPTY_BYTE_SEQUENCE, (String)name.toJavaStringUncached()).build();
    }

    public static Object[] prependArgument(Object primary, Object[] arguments) {
        Object[] result = new Object[arguments.length + 1];
        result[0] = primary;
        PythonUtils.arraycopy(arguments, 0, result, 1, arguments.length);
        return result;
    }

    public static boolean isAscii(TruffleString string, TruffleString.GetCodeRangeNode getCodeRangeNode) {
        return getCodeRangeNode.execute((AbstractTruffleString)string, TS_ENCODING) == TruffleString.CodeRange.ASCII;
    }

    public static byte[] getAsciiBytes(TruffleString string, TruffleString.CopyToByteArrayNode copyToByteArrayNode, TruffleString.SwitchEncodingNode switchEncodingNode) {
        assert (string.getCodeRangeUncached(TS_ENCODING) == TruffleString.CodeRange.ASCII);
        TruffleString ascii = switchEncodingNode.execute((AbstractTruffleString)string, TruffleString.Encoding.US_ASCII);
        byte[] data = new byte[ascii.byteLength(TruffleString.Encoding.US_ASCII)];
        copyToByteArrayNode.execute((AbstractTruffleString)ascii, 0, data, 0, data.length, TruffleString.Encoding.US_ASCII);
        return data;
    }

    public static ConditionProfile[] createConditionProfiles(int n) {
        ConditionProfile[] profiles = new ConditionProfile[n];
        for (int i = 0; i < profiles.length; ++i) {
            profiles[i] = ConditionProfile.create();
        }
        return profiles;
    }

    public static Object builtinClassToType(Object cls) {
        if (cls instanceof PythonBuiltinClass) {
            PythonBuiltinClass builtinClass = (PythonBuiltinClass)cls;
            return builtinClass.getType();
        }
        return cls;
    }

    public static Object pythonObjectFromConstantValue(ConstantValue v, PythonObjectFactory factory) {
        switch (v.kind) {
            case BOOLEAN: {
                return v.getBoolean();
            }
            case LONG: {
                long l = v.getLong();
                if (l == (long)((int)l)) {
                    return (int)l;
                }
                return l;
            }
            case DOUBLE: {
                return v.getDouble();
            }
            case COMPLEX: {
                double[] c = v.getComplex();
                return factory.createComplex(c[0], c[1]);
            }
            case NONE: {
                return PNone.NONE;
            }
            case ELLIPSIS: {
                return PEllipsis.INSTANCE;
            }
            case BIGINTEGER: {
                return factory.createInt(v.getBigInteger());
            }
            case BYTES: {
                return factory.createBytes(v.getBytes());
            }
            case RAW: {
                return v.getRaw(TruffleString.class);
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    public static long crc32(int initialValue, byte[] bytes, int offset, int length) {
        int crc = ~initialValue;
        for (int i = 0; i < length; ++i) {
            crc = CRC_32_TAB[(crc ^ bytes[offset + i]) & 0xFF] ^ crc >>> 8;
        }
        return (long)(~crc) & 0xFFFFFFFFL;
    }

    public static long crcHqx(int initialValue, byte[] bytes, int offset, int length) {
        int crc = initialValue & 0xFFFF;
        for (int i = offset; i < length; ++i) {
            crc = crc << 8 & 0xFF00 ^ CRC_HQX_TAB[crc >>> 8 ^ bytes[i] & 0xFF];
        }
        return crc;
    }

    public static void assertUncached() {
        if (!TruffleOptions.AOT) {
            CompilerAsserts.neverPartOfCompilation();
        }
        CompilerDirectives.transferToInterpreter();
    }

    public static boolean isBitSet(int state, int position) {
        return (state >>> position & 1) != 0;
    }

    public static String formatPointer(Object pointer) {
        CompilerAsserts.neverPartOfCompilation();
        InteropLibrary lib = InteropLibrary.getUncached((Object)pointer);
        if (lib.isPointer(pointer)) {
            try {
                return String.format("%s#0x%016x", pointer.getClass().getSimpleName(), lib.asPointer(pointer));
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }
        return String.valueOf(pointer);
    }

    public static long coerceToLong(Object allocated, InteropLibrary lib) {
        if (allocated instanceof Long) {
            return (Long)allocated;
        }
        if (!lib.isPointer(allocated)) {
            lib.toNative(allocated);
        }
        try {
            return lib.asPointer(allocated);
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    public static InteropLibrary getUncachedInterop(InteropLibrary existing, Object obj) {
        return existing != null && existing.accepts(obj) ? existing : InteropLibrary.getUncached((Object)obj);
    }

    static {
        PARAMS = new Object[]{null};
        SIGNATURE = new String[]{String[].class.getName()};
        if (ImageInfo.inImageCode()) {
            OBJECT_NAME = null;
            SERVER = null;
        } else {
            ObjectName n;
            SERVER = ManagementFactory.getPlatformMBeanServer();
            try {
                n = new ObjectName("com.sun.management:type=DiagnosticCommand");
            }
            catch (MalformedObjectNameException e) {
                n = null;
            }
            OBJECT_NAME = n;
        }
        CRC_32_TAB = new int[]{0, 1996959894, -301047508, -1727442502, 124634137, 1886057615, -379345611, -1637575261, 249268274, 2044508324, -522852066, -1747789432, 162941995, 2125561021, -407360249, -1866523247, 498536548, 1789927666, -205950648, -2067906082, 450548861, 1843258603, -187386543, -2083289657, 325883990, 1684777152, -43845254, -1973040660, 335633487, 1661365465, -99664541, -1928851979, 997073096, 1281953886, -715111964, -1570279054, 1006888145, 1258607687, -770865667, -1526024853, 901097722, 1119000684, -608450090, -1396901568, 853044451, 1172266101, -589951537, -1412350631, 651767980, 1373503546, -925412992, -1076862698, 565507253, 1454621731, -809855591, -1195530993, 671266974, 1594198024, -972236366, -1324619484, 795835527, 1483230225, -1050600021, -1234817731, 1994146192, 31158534, -1731059524, -271249366, 1907459465, 112637215, -1614814043, -390540237, 2013776290, 251722036, -1777751922, -519137256, 2137656763, 141376813, -1855689577, -429695999, 1802195444, 476864866, -2056965928, -228458418, 1812370925, 453092731, -2113342271, -183516073, 1706088902, 314042704, -1950435094, -54949764, 1658658271, 366619977, -1932296973, -69972891, 1303535960, 984961486, -1547960204, -725929758, 1256170817, 1037604311, -1529756563, -740887301, 1131014506, 879679996, -1385723834, -631195440, 1141124467, 855842277, -1442165665, -586318647, 1342533948, 654459306, -1106571248, -921952122, 1466479909, 544179635, -1184443383, -832445281, 1591671054, 702138776, -1328506846, -942167884, 1504918807, 783551873, -1212326853, -1061524307, -306674912, -1698712650, 62317068, 1957810842, -355121351, -1647151185, 81470997, 1943803523, -480048366, -1805370492, 225274430, 2053790376, -468791541, -1828061283, 167816743, 2097651377, -267414716, -2029476910, 503444072, 1762050814, -144550051, -2140837941, 426522225, 1852507879, -19653770, -1982649376, 282753626, 1742555852, -105259153, -1900089351, 397917763, 1622183637, -690576408, -1580100738, 953729732, 1340076626, -776247311, -1497606297, 1068828381, 1219638859, -670225446, -1358292148, 906185462, 1090812512, -547295293, -1469587627, 829329135, 1181335161, -882789492, -1134132454, 628085408, 1382605366, -871598187, -1156888829, 570562233, 1426400815, -977650754, -1296233688, 733239954, 1555261956, -1026031705, -1244606671, 752459403, 1541320221, -1687895376, -328994266, 1969922972, 40735498, -1677130071, -351390145, 1913087877, 83908371, -1782625662, -491226604, 2075208622, 213261112, -1831694693, -438977011, 2094854071, 198958881, -2032938284, -237706686, 1759359992, 534414190, -2118248755, -155638181, 1873836001, 414664567, -2012718362, -15766928, 1711684554, 285281116, -1889165569, -127750551, 1634467795, 376229701, -1609899400, -686959890, 1308918612, 956543938, -1486412191, -799009033, 1231636301, 1047427035, -1362007478, -640263460, 1088359270, 936918000, -1447252397, -558129467, 1202900863, 817233897, -1111625188, -893730166, 1404277552, 615818150, -1160759803, -841546093, 1423857449, 601450431, -1285129682, -1000256840, 1567103746, 711928724, -1274298825, -1022587231, 1510334235, 755167117};
        CRC_HQX_TAB = new int[]{0, 4129, 8258, 12387, 16516, 20645, 24774, 28903, 33032, 37161, 41290, 45419, 49548, 53677, 57806, 61935, 4657, 528, 12915, 8786, 21173, 17044, 29431, 25302, 37689, 33560, 45947, 41818, 54205, 50076, 62463, 58334, 9314, 13379, 1056, 5121, 25830, 29895, 17572, 21637, 42346, 46411, 34088, 38153, 58862, 62927, 50604, 54669, 13907, 9842, 5649, 1584, 30423, 26358, 22165, 18100, 46939, 42874, 38681, 34616, 63455, 59390, 55197, 51132, 18628, 22757, 26758, 30887, 2112, 6241, 10242, 14371, 51660, 55789, 59790, 63919, 35144, 39273, 43274, 47403, 23285, 19156, 31415, 27286, 6769, 2640, 14899, 10770, 56317, 52188, 64447, 60318, 39801, 35672, 47931, 43802, 27814, 31879, 19684, 23749, 11298, 15363, 3168, 7233, 60846, 64911, 52716, 56781, 44330, 48395, 36200, 40265, 32407, 28342, 24277, 20212, 15891, 11826, 7761, 3696, 65439, 61374, 57309, 53244, 48923, 44858, 40793, 36728, 37256, 33193, 45514, 41451, 53516, 49453, 61774, 57711, 4224, 161, 12482, 8419, 20484, 16421, 28742, 24679, 33721, 37784, 41979, 46042, 49981, 54044, 58239, 62302, 689, 4752, 8947, 13010, 16949, 21012, 25207, 29270, 46570, 42443, 38312, 34185, 62830, 58703, 54572, 50445, 13538, 9411, 5280, 1153, 29798, 25671, 21540, 17413, 42971, 47098, 34713, 38840, 59231, 63358, 50973, 55100, 9939, 14066, 1681, 5808, 26199, 30326, 17941, 22068, 55628, 51565, 63758, 59695, 39368, 35305, 47498, 43435, 22596, 18533, 30726, 26663, 6336, 2273, 14466, 10403, 52093, 56156, 60223, 64286, 35833, 39896, 43963, 48026, 19061, 23124, 27191, 31254, 2801, 6864, 10931, 14994, 64814, 60687, 56684, 52557, 48554, 44427, 40424, 36297, 31782, 27655, 23652, 19525, 15522, 11395, 7392, 3265, 61215, 65342, 53085, 57212, 44955, 49082, 36825, 40952, 28183, 32310, 20053, 24180, 11923, 16050, 3793, 7920};
    }

    public static final class PrototypeNodeFactory<T extends Node>
    implements NodeFactory<T> {
        private final T node;

        public PrototypeNodeFactory(T node) {
            this.node = node;
        }

        public T createNode(Object ... arguments) {
            return (T)NodeUtil.cloneNode(this.node);
        }

        public Class<T> getNodeClass() {
            return PrototypeNodeFactory.determineNodeClass(this.node);
        }

        private static <T> Class<T> determineNodeClass(T node) {
            CompilerAsserts.neverPartOfCompilation();
            Class nodeClass = node.getClass();
            GeneratedBy genBy = nodeClass.getAnnotation(GeneratedBy.class);
            if (genBy != null) {
                nodeClass = genBy.value();
                assert (nodeClass.isAssignableFrom(node.getClass()));
            }
            return nodeClass;
        }

        public List<List<Class<?>>> getNodeSignatures() {
            throw new IllegalAccessError();
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            throw new IllegalAccessError();
        }
    }

    public static final class NodeCounterWithLimit
    implements NodeVisitor {
        private int count;
        private final int limit;

        public NodeCounterWithLimit(int counterStart, int limit) {
            this.count = counterStart;
            this.limit = limit;
        }

        public NodeCounterWithLimit(int limit) {
            this.limit = limit;
        }

        public boolean visit(Node node) {
            return ++this.count < this.limit;
        }

        public int getCount() {
            return this.count;
        }

        public boolean isOverLimit() {
            return this.count >= this.limit;
        }
    }
}

