/*
 * Decompiled with CFR 0.152.
 */
package org.nanohttpd.protocols.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.logging.Level;
import org.nanohttpd.protocols.http.NanoHTTPD;

public class ServerRunnable
implements Runnable {
    private NanoHTTPD httpd;
    private final int timeout;
    private IOException bindException;
    private boolean hasBinded = false;

    public ServerRunnable(NanoHTTPD httpd, int timeout) {
        this.httpd = httpd;
        this.timeout = timeout;
    }

    @Override
    public void run() {
        try {
            this.httpd.getMyServerSocket().bind(this.httpd.hostname != null ? new InetSocketAddress(this.httpd.hostname, this.httpd.myPort) : new InetSocketAddress(this.httpd.myPort));
            this.hasBinded = true;
        }
        catch (IOException e) {
            this.bindException = e;
            return;
        }
        do {
            try {
                Socket finalAccept = this.httpd.getMyServerSocket().accept();
                if (this.timeout > 0) {
                    finalAccept.setSoTimeout(this.timeout);
                }
                InputStream inputStream = finalAccept.getInputStream();
                this.httpd.asyncRunner.exec(this.httpd.createClientHandler(finalAccept, inputStream));
            }
            catch (IOException e) {
                NanoHTTPD.LOG.log(Level.FINE, "Communication with the client broken", e);
            }
        } while (!this.httpd.getMyServerSocket().isClosed());
    }

    public IOException getBindException() {
        return this.bindException;
    }

    public boolean hasBinded() {
        return this.hasBinded;
    }
}

