/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.profiler;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.ThreadLocalAction;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tools.profiler.CPUSampler;
import com.oracle.truffle.tools.profiler.StackTraceEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.stream.Collectors;

final class SafepointStackSampler {
    private static final Set<Class<?>> VISITOR_TAGS = new HashSet<Class>(Arrays.asList(StandardTags.RootTag.class));
    private final int stackLimit;
    private final SourceSectionFilter sourceSectionFilter;
    private final ConcurrentLinkedQueue<StackVisitor> stackVisitorCache = new ConcurrentLinkedQueue();
    private final AtomicReference<SampleAction> cachedAction = new AtomicReference();
    private final ThreadLocal<SyntheticFrame> syntheticFrameThreadLocal = ThreadLocal.withInitial(() -> null);
    private volatile boolean overflowed;
    private final AtomicLong sampleIndex = new AtomicLong(0L);

    SafepointStackSampler(int stackLimit, SourceSectionFilter sourceSectionFilter) {
        this.stackLimit = stackLimit;
        this.sourceSectionFilter = sourceSectionFilter;
    }

    private StackVisitor fetchStackVisitor() {
        StackVisitor visitor = this.stackVisitorCache.poll();
        if (visitor == null) {
            visitor = new StackVisitor(this.stackLimit);
        }
        return visitor;
    }

    List<StackSample> sample(TruffleInstrument.Env env, TruffleContext context, CPUSampler.MutableSamplerData mutableSamplerData, boolean useSyntheticFrames, long timeout, TimeUnit timeoutUnit) {
        Future future;
        if (context.isClosed()) {
            return Collections.emptyList();
        }
        SampleAction action = this.cachedAction.getAndSet(null);
        if (action == null) {
            long index = this.sampleIndex.getAndIncrement();
            if (index < 0L) {
                index = 0L;
                this.sampleIndex.set(0L);
            }
            action = new SampleAction(index);
        }
        action.useSyntheticFrames = useSyntheticFrames;
        long submitTime = System.nanoTime();
        try {
            future = env.submitThreadLocal(context, null, (ThreadLocalAction)action);
        }
        catch (IllegalStateException e2) {
            return Collections.emptyList();
        }
        try {
            future.get(timeout, timeoutUnit);
        }
        catch (InterruptedException | ExecutionException e3) {
            env.getLogger(this.getClass()).log(Level.SEVERE, "Sampling failed", (Throwable)e3);
            return null;
        }
        catch (TimeoutException e4) {
            future.cancel(false);
            mutableSamplerData.missedSamples.incrementAndGet();
        }
        ArrayList<StackSample> perThreadSamples = new ArrayList<StackSample>();
        for (CollectionResult result : action.getStacks()) {
            StackSample sample = result.createSample(submitTime);
            if (sample.overflowed) {
                this.overflowed = true;
            }
            perThreadSamples.add(sample);
        }
        action.reset();
        this.cachedAction.set(action);
        assert (perThreadSamples.stream().map(e -> e.thread).collect(Collectors.toSet()).size() == perThreadSamples.size());
        return perThreadSamples;
    }

    boolean hasOverflowed() {
        return this.overflowed;
    }

    public void pushSyntheticFrame(LanguageInfo language, String message) {
        long submitTime = System.nanoTime();
        StackVisitor visitor = this.fetchStackVisitor();
        visitor.iterateFrames();
        StackSample stackSample = visitor.createSample(submitTime);
        SyntheticFrame frame = new SyntheticFrame(this.syntheticFrameThreadLocal.get(), stackSample, language, message);
        this.syntheticFrameThreadLocal.set(frame);
    }

    public void popSyntheticFrame() {
        SyntheticFrame toPop = this.syntheticFrameThreadLocal.get();
        if (toPop != null) {
            this.syntheticFrameThreadLocal.set(toPop.parent);
        }
    }

    private class StackVisitor
    implements FrameInstanceVisitor<FrameInstance>,
    CollectionResult {
        private final CallTarget[] targets;
        private final int[] tiers;
        private final boolean[] roots;
        private Thread thread;
        private int nextFrameIndex;
        private long startTime;
        private long endTime;
        private boolean overflowed;

        StackVisitor(int stackLimit) {
            assert (stackLimit > 0);
            this.tiers = new int[stackLimit];
            this.roots = new boolean[stackLimit];
            this.targets = new CallTarget[stackLimit];
        }

        final void iterateFrames() {
            assert (this.thread == null) : "not cleaned";
            assert (this.nextFrameIndex == 0) : "not cleaned";
            this.thread = Thread.currentThread();
            this.startTime = System.nanoTime();
            Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)this);
            this.endTime = System.nanoTime();
        }

        @Override
        public StackSample createSample(long submitTime) {
            long bias = this.startTime - submitTime;
            long overhead = this.endTime - this.startTime;
            StackSample sample = new StackSample(this.thread, this.createEntries(SafepointStackSampler.this.sourceSectionFilter), bias, overhead, this.overflowed);
            assert (sample.thread != null);
            this.resetAndReturn();
            return sample;
        }

        public FrameInstance visitFrame(FrameInstance frameInstance) {
            this.tiers[this.nextFrameIndex] = frameInstance.getCompilationTier();
            this.roots[this.nextFrameIndex] = frameInstance.isCompilationRoot();
            this.targets[this.nextFrameIndex] = frameInstance.getCallTarget();
            ++this.nextFrameIndex;
            if (this.nextFrameIndex >= this.targets.length) {
                this.overflowed = true;
                return frameInstance;
            }
            return null;
        }

        void resetAndReturn() {
            Arrays.fill(this.tiers, 0, this.nextFrameIndex, 0);
            Arrays.fill(this.roots, 0, this.nextFrameIndex, false);
            Arrays.fill(this.targets, 0, this.nextFrameIndex, null);
            this.nextFrameIndex = 0;
            this.thread = null;
            this.overflowed = false;
            this.startTime = 0L;
            this.endTime = 0L;
            SafepointStackSampler.this.stackVisitorCache.add(this);
        }

        List<StackTraceEntry> createEntries(SourceSectionFilter filter) {
            ArrayList<StackTraceEntry> entries = new ArrayList<StackTraceEntry>(this.nextFrameIndex);
            for (int i = 0; i < this.nextFrameIndex; ++i) {
                SourceSection sourceSection;
                CallTarget target = this.targets[i];
                RootNode root = ((RootCallTarget)target).getRootNode();
                if (!filter.includes(root, sourceSection = root.getSourceSection(), null)) continue;
                entries.add(new StackTraceEntry(VISITOR_TAGS, sourceSection, root, (Node)root, this.tiers[i], this.roots[i]));
            }
            return entries;
        }
    }

    private class SampleAction
    extends ThreadLocalAction {
        final ConcurrentHashMap<Thread, CollectionResult> completed;
        boolean useSyntheticFrames;
        private long index;

        protected SampleAction(long index) {
            super(false, false);
            this.completed = new ConcurrentHashMap();
            this.useSyntheticFrames = true;
            this.index = index;
        }

        protected void perform(ThreadLocalAction.Access access) {
            SyntheticFrame syntheticFrame;
            if (this.useSyntheticFrames && (syntheticFrame = SafepointStackSampler.this.syntheticFrameThreadLocal.get()) != null) {
                this.completed.put(access.getThread(), syntheticFrame);
                return;
            }
            StackVisitor visitor = SafepointStackSampler.this.fetchStackVisitor();
            visitor.iterateFrames();
            this.completed.put(access.getThread(), visitor);
        }

        List<CollectionResult> getStacks() {
            return new ArrayList<CollectionResult>(this.completed.values());
        }

        public String toString() {
            return "StackSampleAction[index=" + this.index + "]";
        }

        void reset() {
            this.completed.clear();
        }
    }

    private static interface CollectionResult {
        public StackSample createSample(long var1);
    }

    static final class StackSample {
        final Thread thread;
        final List<StackTraceEntry> stack;
        final long biasNs;
        final long durationNs;
        final boolean overflowed;

        StackSample(Thread thread, List<StackTraceEntry> stack, long biasNs, long durationNs, boolean overflowed) {
            this.thread = thread;
            this.stack = stack;
            this.biasNs = biasNs;
            this.durationNs = durationNs;
            this.overflowed = overflowed;
        }
    }

    private static class SyntheticFrame
    implements CollectionResult {
        final SyntheticFrame parent;
        final StackSample stackSample;
        final LanguageInfo language;
        final String message;
        boolean syntheticFrameCreated;

        SyntheticFrame(SyntheticFrame parent, StackSample stackSample, LanguageInfo language, String message) {
            this.parent = parent;
            this.stackSample = stackSample;
            this.language = language;
            this.message = message;
        }

        @Override
        public StackSample createSample(long submitTime) {
            if (!this.syntheticFrameCreated) {
                this.stackSample.stack.add(0, new StackTraceEntry("<<" + this.language.getId() + ":" + this.message + ">>"));
                this.syntheticFrameCreated = true;
            }
            return this.stackSample;
        }
    }
}

