// CheckStyle: start generated
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.ExplodeLoop.LoopExplosionKind;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.concurrent.locks.Lock;

@GeneratedBy(ProxyInvokeNode.class)
final class ProxyInvokeNodeGen extends ProxyInvokeNode {

    @CompilationFinal private int state_;
    @Child private CachedMethodData cachedMethod_cache;

    private ProxyInvokeNodeGen() {
    }

    @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    @Override
    public Object execute(PolyglotLanguageContext arg0Value, TruffleObject arg1Value, Method arg2Value, Object[] arg3Value) {
        int state = state_;
        if (state != 0 /* is-active doCachedMethod(PolyglotLanguageContext, TruffleObject, Method, Object[], Method, String, Class<>, Type, Node, Node, Node, Node, Node, ConditionProfile, ToHostNode) */) {
            CachedMethodData s1_ = this.cachedMethod_cache;
            while (s1_ != null) {
                if ((s1_.cachedMethod_.equals(arg2Value))) {
                    return doCachedMethod(arg0Value, arg1Value, arg2Value, arg3Value, s1_.cachedMethod_, s1_.name_, s1_.returnClass_, s1_.returnType_, s1_.invokeNode_, s1_.keyInfoNode_, s1_.readNode_, s1_.isExecutableNode_, s1_.executeNode_, s1_.branchProfile_, s1_.toJava_);
                }
                s1_ = s1_.next_;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
    }

    private Object executeAndSpecialize(PolyglotLanguageContext arg0Value, TruffleObject arg1Value, Method arg2Value, Object[] arg3Value) {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state = state_;
        try {
            int count1_ = 0;
            CachedMethodData s1_ = this.cachedMethod_cache;
            if (state != 0 /* is-active doCachedMethod(PolyglotLanguageContext, TruffleObject, Method, Object[], Method, String, Class<>, Type, Node, Node, Node, Node, Node, ConditionProfile, ToHostNode) */) {
                while (s1_ != null) {
                    if ((s1_.cachedMethod_.equals(arg2Value))) {
                        break;
                    }
                    s1_ = s1_.next_;
                    count1_++;
                }
            }
            if (s1_ == null) {
                // assert (s1_.cachedMethod_.equals(arg2Value));
                if (count1_ < (ProxyInvokeNode.LIMIT)) {
                    s1_ = new CachedMethodData(cachedMethod_cache);
                    s1_.cachedMethod_ = (arg2Value);
                    s1_.name_ = (arg2Value.getName());
                    s1_.returnClass_ = (HostInteropReflect.getMethodReturnType(arg2Value));
                    s1_.returnType_ = (HostInteropReflect.getMethodGenericReturnType(arg2Value));
                    s1_.invokeNode_ = (Message.INVOKE.createNode());
                    s1_.keyInfoNode_ = (Message.KEY_INFO.createNode());
                    s1_.readNode_ = (Message.READ.createNode());
                    s1_.isExecutableNode_ = (Message.IS_EXECUTABLE.createNode());
                    s1_.executeNode_ = (Message.EXECUTE.createNode());
                    s1_.branchProfile_ = (ConditionProfile.createBinaryProfile());
                    s1_.toJava_ = (ToHostNode.create());
                    this.cachedMethod_cache = super.insert(s1_);
                    this.state_ = state = state | 0b1 /* add-active doCachedMethod(PolyglotLanguageContext, TruffleObject, Method, Object[], Method, String, Class<>, Type, Node, Node, Node, Node, Node, ConditionProfile, ToHostNode) */;
                }
            }
            if (s1_ != null) {
                lock.unlock();
                hasLock = false;
                return doCachedMethod(arg0Value, arg1Value, arg2Value, arg3Value, s1_.cachedMethod_, s1_.name_, s1_.returnClass_, s1_.returnType_, s1_.invokeNode_, s1_.keyInfoNode_, s1_.readNode_, s1_.isExecutableNode_, s1_.executeNode_, s1_.branchProfile_, s1_.toJava_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value);
        } finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = state_;
        if (state == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
            CachedMethodData s1_ = this.cachedMethod_cache;
            if ((s1_ == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public static ProxyInvokeNode create() {
        return new ProxyInvokeNodeGen();
    }

    @GeneratedBy(ProxyInvokeNode.class)
    private static final class CachedMethodData extends Node {

        @Child CachedMethodData next_;
        @CompilationFinal Method cachedMethod_;
        @CompilationFinal String name_;
        @CompilationFinal Class<?> returnClass_;
        @CompilationFinal Type returnType_;
        @Child Node invokeNode_;
        @Child Node keyInfoNode_;
        @Child Node readNode_;
        @Child Node isExecutableNode_;
        @Child Node executeNode_;
        @CompilationFinal ConditionProfile branchProfile_;
        @Child ToHostNode toJava_;

        CachedMethodData(CachedMethodData next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
}
