package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.ForeignAccess.Factory;
import com.oracle.truffle.api.interop.ForeignAccess.StandardFactory;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.RootNode;

/**
 * This foreign access factory is generated by {@link com.oracle.truffle.polyglot.DefaultScope.VariableNamesObject.VariableNamesMessageResolution}.
 * You are supposed to use it for the receiver object {@link com.oracle.truffle.polyglot.DefaultScope.VariableNamesObject}.
 */
final class VariableNamesMessageResolutionForeign implements StandardFactory, Factory {
    public static final ForeignAccess ACCESS = ForeignAccess.create(new VariableNamesMessageResolutionForeign(), null);
    @Deprecated public static ForeignAccess createAccess() { return ForeignAccess.create(new VariableNamesMessageResolutionForeign(), null); }

    private VariableNamesMessageResolutionForeign() { }

    @Override
    public boolean canHandle(TruffleObject obj) {
        return com.oracle.truffle.polyglot.DefaultScope.VariableNamesObject.isInstance(obj);
    }

    @Override
    public CallTarget accessIsNull() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsExecutable() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsInstantiable() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsBoxed() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessHasKeys() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessHasSize() {
      return Truffle.getRuntime().createCallTarget(VarNamesHasSizeSubNode.createRoot());
    }
    @Override
    public CallTarget accessGetSize() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(VarNamesGetSizeSubNode.createRoot());
    }
    @Override
    public CallTarget accessUnbox() {
      return null;
    }
    @Override
    public CallTarget accessRead() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(VarNamesReadSubNode.createRoot());
    }
    @Override
    public CallTarget accessWrite() {
      return null;
    }
    @Override
    public CallTarget accessRemove() {
      return null;
    }
    @Override
    public CallTarget accessExecute(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessInvoke(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessNew(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessKeyInfo() {
      return null;
    }
    @Override
    public CallTarget accessKeys() {
      return null;
    }
    @Override
    public CallTarget accessIsPointer() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessAsPointer() {
      return null;
    }
    @Override
    public CallTarget accessToNative() {
      return null;
    }
    @Override
    public CallTarget accessMessage(Message unknown) {
      return null;
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.DefaultScope.VariableNamesObject.VariableNamesMessageResolution.VarNamesReadNode}.
     */
    abstract static class VarNamesReadSubNode extends com.oracle.truffle.polyglot.DefaultScope.VariableNamesObject.VariableNamesMessageResolution.VarNamesReadNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0, Object o1);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.DefaultScope.VariableNamesObject varNames, int index) {
            return access(varNames, index);
        }
        private static final class READRootNode extends RootNode {
            protected READRootNode() {
                super(null);
            }

            @Child private VarNamesReadSubNode node = com.oracle.truffle.polyglot.VariableNamesMessageResolutionForeignFactory.VarNamesReadSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::READ::" + com.oracle.truffle.polyglot.DefaultScope.VariableNamesObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                Object identifier = frame.getArguments()[1];
                try {
                    return node.executeWithTarget(frame, receiver, identifier);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof VarNamesReadSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new READRootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.DefaultScope.VariableNamesObject.VariableNamesMessageResolution.VarNamesGetSizeNode}.
     */
    abstract static class VarNamesGetSizeSubNode extends com.oracle.truffle.polyglot.DefaultScope.VariableNamesObject.VariableNamesMessageResolution.VarNamesGetSizeNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.DefaultScope.VariableNamesObject varNames) {
            return access(varNames);
        }
        private static final class GET_SIZERootNode extends RootNode {
            protected GET_SIZERootNode() {
                super(null);
            }

            @Child private VarNamesGetSizeSubNode node = com.oracle.truffle.polyglot.VariableNamesMessageResolutionForeignFactory.VarNamesGetSizeSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::GET_SIZE::" + com.oracle.truffle.polyglot.DefaultScope.VariableNamesObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof VarNamesGetSizeSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new GET_SIZERootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.DefaultScope.VariableNamesObject.VariableNamesMessageResolution.VarNamesHasSizeNode}.
     */
    abstract static class VarNamesHasSizeSubNode extends com.oracle.truffle.polyglot.DefaultScope.VariableNamesObject.VariableNamesMessageResolution.VarNamesHasSizeNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.DefaultScope.VariableNamesObject varNames) {
            return access(varNames);
        }
        private static final class HAS_SIZERootNode extends RootNode {
            protected HAS_SIZERootNode() {
                super(null);
            }

            @Child private VarNamesHasSizeSubNode node = com.oracle.truffle.polyglot.VariableNamesMessageResolutionForeignFactory.VarNamesHasSizeSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::HAS_SIZE::" + com.oracle.truffle.polyglot.DefaultScope.VariableNamesObject.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof VarNamesHasSizeSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new HAS_SIZERootNode();
        }
    }
}
