/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.polyglot.enterprise.BinaryProtocol;
import com.oracle.truffle.polyglot.enterprise.CleanableWeakReference;
import com.oracle.truffle.polyglot.enterprise.EnterpriseEngineAccessor;
import com.oracle.truffle.polyglot.enterprise.HSContext;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolate;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolateGuestFeatureEnabled;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import com.oracle.truffle.polyglot.enterprise.StackPointerRetriever;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.nativebridge.BinaryInput;
import org.graalvm.nativebridge.BinaryMarshaller;
import org.graalvm.nativebridge.BinaryOutput;
import org.graalvm.nativebridge.ForeignException;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

@ExportLibrary(value=ReflectionLibrary.class)
final class HSTruffleObject
implements TruffleObject {
    private static final BinaryMarshaller<Throwable> THROWABLE_MARSHALLER = PolyglotJNIConfig.getInstance().lookupMarshaller(Throwable.class, new Class[0]);
    private final HSContext context;
    private final long hostReferenceId;

    private HSTruffleObject(HSContext hSContext, long l2) {
        this.context = hSContext;
        this.hostReferenceId = l2;
    }

    long getHostReferenceId() {
        return this.hostReferenceId;
    }

    public static HSTruffleObject createHostObjectReference(long l2, HSContext hSContext) {
        if (ImageSingletons.contains(PolyglotIsolateGuestFeatureEnabled.class)) {
            HSTruffleObject hSTruffleObject = new HSTruffleObject(hSContext, l2);
            new CleanupReference(hSTruffleObject, hSContext, l2);
            return hSTruffleObject;
        }
        throw new UnsupportedOperationException("Should not reach here.");
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object send(Message message, Object[] objectArray) {
        JNI.JByteArray jByteArray;
        JNI.JByteArray jByteArray2;
        BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput;
        boolean bl;
        JNI.JNIEnv jNIEnv = JNIMethodScope.env();
        if (!StackPointerRetriever.fitsOnStack(this.context.hostStackSpaceHeadroom, PolyglotIsolate.getHostStackOverflowLimit())) {
            throw new StackOverflowError("Not enough stack space to perform a host call from isolated guest language.");
        }
        CCharPointer cCharPointer = (CCharPointer)StackValue.get((int)4096);
        boolean bl2 = bl = objectArray.length > 0;
        if (bl) {
            cCharPointerBinaryOutput = BinaryOutput.create((CCharPointer)cCharPointer, (int)4096, (boolean)false);
            try {
                BinaryProtocol.writeGuestTypedValue((BinaryOutput)cCharPointerBinaryOutput, objectArray, this.context.hostToGuestReceiver);
                int n2 = cCharPointerBinaryOutput.getPosition();
                jByteArray2 = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n2);
                JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray2, (int)0, (int)n2, (CCharPointer)cCharPointerBinaryOutput.getAddress());
            }
            finally {
                if (cCharPointerBinaryOutput != null) {
                    cCharPointerBinaryOutput.close();
                }
            }
        } else {
            jByteArray2 = (JNI.JByteArray)WordFactory.nullPointer();
        }
        cCharPointerBinaryOutput = (JNI.JValue)StackValue.get((int)3, JNI.JValue.class);
        cCharPointerBinaryOutput.addressOf(0).setLong(this.hostReferenceId);
        cCharPointerBinaryOutput.addressOf(1).setInt(message.getId());
        cCharPointerBinaryOutput.addressOf(2).setJObject((JNI.JObject)jByteArray2);
        try {
            jByteArray = (JNI.JByteArray)ForeignException.getJNICalls().callJObject(jNIEnv, (JNI.JObject)this.context.guestToHostReceiver, this.context.guestToHostMessageDispatch, (JNI.JValue)cCharPointerBinaryOutput);
        }
        catch (ForeignException foreignException) {
            throw foreignException.throwOriginalException(THROWABLE_MARSHALLER);
        }
        if (jByteArray.isNull()) {
            return EnterpriseEngineAccessor.ENGINE.getHostNull();
        }
        int n3 = JNIUtil.GetArrayLength((JNI.JNIEnv)jNIEnv, (JNI.JArray)jByteArray);
        CCharPointer cCharPointer2 = n3 < 4096 ? cCharPointer : (CCharPointer)UnmanagedMemory.malloc((int)n3);
        try {
            JNIUtil.GetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n3, (CCharPointer)cCharPointer2);
            BinaryInput binaryInput = BinaryInput.create((CCharPointer)cCharPointer2, (int)n3);
            boolean bl3 = binaryInput.readBoolean();
            Object object = BinaryProtocol.readGuestTypedValue(binaryInput, this.context);
            if (bl3) {
                Object object2 = object;
                return object2;
            }
            throw HSTruffleObject.throwUnchecked(RuntimeException.class, (Throwable)object);
        }
        finally {
            if (cCharPointer2 != cCharPointer) {
                UnmanagedMemory.free((PointerBase)cCharPointer2);
            }
        }
    }

    private static <T extends Throwable> T throwUnchecked(Class<T> clazz, Throwable throwable) throws T {
        throw throwable;
    }

    private static class CleanupReference
    extends CleanableWeakReference<HSTruffleObject> {
        private final HSContext context;
        private final long hostObjectId;

        CleanupReference(HSTruffleObject hSTruffleObject, HSContext hSContext, long l2) {
            super(hSTruffleObject);
            this.context = hSContext;
            this.hostObjectId = l2;
        }

        @Override
        public void run() {
            try {
                this.context.releaseGuestToHostReference(this.hostObjectId);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(THROWABLE_MARSHALLER);
            }
        }
    }
}

