/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.jniutils.NativeBridgeSupport;

public final class PolyglotIsolateBridgeSupport
implements NativeBridgeSupport {
    private static final String JNI_POLYGLOT_ISOLATE_TRACE_LEVEL_ENV_NAME = "JNI_POLYGLOT_TRACE_LEVEL";
    private volatile Integer traceLevel;

    public String getFeatureName() {
        return "TRUFFLE-ISOLATE";
    }

    public boolean isTracingEnabled(int n2) {
        return this.traceLevel() >= n2;
    }

    public void trace(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[').append(Thread.currentThread().getName()).append(']');
        JNIMethodScope jNIMethodScope = JNIMethodScope.scopeOrNull();
        if (jNIMethodScope != null) {
            stringBuilder.append(new String(new char[2 + jNIMethodScope.depth() * 2]).replace('\u0000', ' '));
        }
        stringBuilder.append(string);
        System.err.println(stringBuilder.toString());
    }

    private int traceLevel() {
        if (this.traceLevel == null) {
            String string = System.getenv(JNI_POLYGLOT_ISOLATE_TRACE_LEVEL_ENV_NAME);
            if (string != null) {
                try {
                    this.traceLevel = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.printf("Invalid value for %s: %s%n", JNI_POLYGLOT_ISOLATE_TRACE_LEVEL_ENV_NAME, numberFormatException);
                    this.traceLevel = 0;
                }
            } else {
                this.traceLevel = 0;
            }
        }
        return this.traceLevel;
    }
}

