/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.HSObjectReferences;
import com.oracle.truffle.polyglot.enterprise.NativeObjectReferences;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolate;
import java.lang.ref.WeakReference;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNICalls;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.nativebridge.ForeignException;
import org.graalvm.nativeimage.StackValue;

final class HSContext
implements PolyglotIsolate.TearDownHook {
    final long contextId;
    final JNI.JWeak guestToHostReceiver;
    final long hostStackSpaceHeadroom;
    final JNICalls.JNIMethod guestToHostMessageDispatch;
    final HSObjectReferences hostToGuestObjectReferences;
    private final JNICalls.JNIMethod guestToHostReleaseReference;
    private final WeakReference<Object> polyglotContextReceiverReference;
    private boolean disposed;

    HSContext(JNI.JNIEnv jNIEnv, long l2, Object object, JNI.JObject jObject, long l3) {
        this.contextId = l2;
        this.polyglotContextReceiverReference = new WeakReference<Object>(object);
        this.hostStackSpaceHeadroom = l3;
        this.hostToGuestObjectReferences = new HSObjectReferences();
        this.guestToHostReceiver = JNIUtil.NewWeakGlobalRef((JNI.JNIEnv)jNIEnv, (JNI.JObject)jObject, (String)NativeObjectReferences.class.getSimpleName());
        JNI.JClass jClass = jNIEnv.getFunctions().getGetObjectClass().call(jNIEnv, (JNI.JObject)this.guestToHostReceiver);
        this.guestToHostMessageDispatch = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)jClass, (boolean)false, (String)"messageDispatch", (String)"(JI[B)[B");
        this.guestToHostReleaseReference = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)jClass, (boolean)false, (String)"releaseReference", (String)"(J)V");
        PolyglotIsolate.registerTearDownHook(20, this);
    }

    synchronized void dispose(JNI.JNIEnv jNIEnv) {
        if (!this.disposed) {
            this.disposed = true;
            JNIUtil.DeleteWeakGlobalRef((JNI.JNIEnv)jNIEnv, (JNI.JWeak)this.guestToHostReceiver);
            this.hostToGuestObjectReferences.releaseAllReferences();
        }
    }

    synchronized void releaseGuestToHostReference(long l2) {
        JNI.JNIEnv jNIEnv;
        JNI.JObject jObject;
        if (!this.disposed && (jObject = JNIUtil.NewLocalRef((JNI.JNIEnv)(jNIEnv = JNIMethodScope.env()), (JNI.JObject)this.guestToHostReceiver)).isNonNull()) {
            JNI.JValue jValue = (JNI.JValue)StackValue.get(JNI.JValue.class);
            jValue.setLong(l2);
            ForeignException.getJNICalls().callVoid(jNIEnv, jObject, this.guestToHostReleaseReference, jValue);
        }
    }

    Object getPolyglotContextReceiverReference() {
        return this.polyglotContextReceiverReference.get();
    }

    @Override
    public void tearDown(JNI.JNIEnv jNIEnv) {
        this.dispose(jNIEnv);
    }
}

