/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime.enterprise;

import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.runtime.EngineData;
import com.oracle.truffle.runtime.enterprise.AbstractEngineCacheSupport;
import com.oracle.truffle.runtime.enterprise.DebugEngineCacheSupportOptionDescriptors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionValues;

public final class DebugEngineCacheSupport
extends AbstractEngineCacheSupport {
    private static final AtomicReference<Object> persistedEngine = new AtomicReference();
    public static final OptionKey<Boolean> DebugTraceCache = new OptionKey((Object)Boolean.FALSE);
    public static final OptionKey<Boolean> DebugCacheStore = new OptionKey((Object)Boolean.FALSE);
    public static final OptionKey<Boolean> DebugCacheLoad = new OptionKey((Object)Boolean.FALSE);
    public static final OptionKey<AbstractEngineCacheSupport.CompilePolicy> DebugCacheCompile = new OptionKey((Object)AbstractEngineCacheSupport.CompilePolicy.hot);
    public static final OptionKey<Boolean> DebugCachePreinitializeContext = new OptionKey((Object)Boolean.TRUE);
    public static final OptionKey<Boolean> DebugCacheCompileUseLastTier = new OptionKey((Object)Boolean.TRUE);

    public OptionDescriptors getEngineOptions() {
        return new DebugEngineCacheSupportOptionDescriptors();
    }

    public boolean isStoreEnabled(OptionValues optionValues) {
        return (Boolean)optionValues.get(DebugCacheStore);
    }

    @Override
    protected OptionKey<Boolean> getTraceOption() {
        return DebugTraceCache;
    }

    public void onEngineCreated(EngineData engineData) {
    }

    public void onEnginePatch(EngineData engineData) {
    }

    public Object tryLoadingCachedEngine(OptionValues optionValues, Function<String, TruffleLogger> function) {
        if (!((Boolean)optionValues.get(DebugCacheLoad)).booleanValue()) {
            this.traceLoad(optionValues, function, "--engine.DebugCacheLoad is not enabled. Not loading engine.", new Object[0]);
            return null;
        }
        Object var3_3 = persistedEngine.getAndSet(null);
        if (var3_3 == null) {
            this.traceLoad(optionValues, function, "No cached debug engine to load in memory found.", new Object[0]);
            return null;
        }
        this.traceLoad(optionValues, function, "Loaded debug engine from in memory cache.", new Object[0]);
        return var3_3;
    }

    public boolean onEngineClosing(EngineData engineData) {
        OptionValues optionValues = engineData.getEngineOptions();
        if (!((Boolean)optionValues.get(DebugCacheStore)).booleanValue()) {
            return false;
        }
        this.trace(engineData, "Preparing debug engine for storage...", new Object[0]);
        AbstractEngineCacheSupport.CompilePolicy compilePolicy = (AbstractEngineCacheSupport.CompilePolicy)((Object)optionValues.get(DebugCacheCompile));
        persistedEngine.set(this.prepareEngine(engineData, compilePolicy, (Boolean)optionValues.get(DebugCacheCompileUseLastTier), (Boolean)optionValues.get(DebugCachePreinitializeContext)));
        this.trace(engineData, "Stored debug engine in memory.", new Object[0]);
        return true;
    }

    public void onEngineClosed(EngineData engineData) {
    }

    public int getPriority() {
        return 0;
    }
}

