// CheckStyle: start generated
package com.oracle.truffle.nfi.backend.libffi;

import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.backend.libffi.SerializeArgumentNode.BufferSlice;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;

@GeneratedBy(BufferSlice.class)
@SuppressWarnings("javadoc")
final class BufferSliceGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(BufferSlice.class, new InteropLibraryExports());
    }

    private BufferSliceGen() {
    }

    @GeneratedBy(BufferSlice.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private static final Uncached UNCACHED = new Uncached();

        private InteropLibraryExports() {
            super(InteropLibrary.class, BufferSlice.class, false, false, 0);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof BufferSlice;
            InteropLibrary uncached = InteropLibraryExports.UNCACHED;
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof BufferSlice;
            return new Cached(receiver);
        }

        @GeneratedBy(BufferSlice.class)
        private static final class Cached extends InteropLibrary {

            /**
             * Source Info: <pre>
             *   Specialization: {@link BufferSlice#accepts}
             *   Parameter: {@link Class} bufferType</pre>
             */
            @CompilationFinal private Class<? extends NativeArgumentBuffer> bufferType;

            protected Cached(Object receiver) {
                BufferSlice castReceiver = ((BufferSlice) receiver) ;
                Class<? extends NativeArgumentBuffer> bufferType_ = (castReceiver.buffer.getClass());
                VarHandle.storeStoreFence();
                this.bufferType = bufferType_;
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof BufferSlice) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof BufferSlice && accepts_(receiver);
            }

            @Override
            public boolean hasBufferElements(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((BufferSlice) receiver)).hasBufferElements();
            }

            @Override
            public boolean isBufferWritable(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((BufferSlice) receiver)).isBufferWritable();
            }

            @Override
            public long getBufferSize(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((BufferSlice) receiver)).getBufferSize();
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link BufferSlice#accepts(BufferSlice, Class)}
             *     Activation probability: 0.14286
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            private boolean accepts_(Object arg0Value_) {
                BufferSlice arg0Value = ((BufferSlice) arg0Value_);
                return arg0Value.accepts(this.bufferType);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link BufferSlice#writeBufferByte(BufferSlice, long, byte, Class)}
             *     Activation probability: 0.14286
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public void writeBufferByte(Object arg0Value_, long arg1Value, byte arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                BufferSlice arg0Value = ((BufferSlice) arg0Value_);
                arg0Value.writeBufferByte(arg1Value, arg2Value, this.bufferType);
                return;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link BufferSlice#writeBufferShort(BufferSlice, ByteOrder, long, short, Class)}
             *     Activation probability: 0.14286
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public void writeBufferShort(Object arg0Value_, ByteOrder arg1Value, long arg2Value, short arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                BufferSlice arg0Value = ((BufferSlice) arg0Value_);
                arg0Value.writeBufferShort(arg1Value, arg2Value, arg3Value, this.bufferType);
                return;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link BufferSlice#writeBufferInt(BufferSlice, ByteOrder, long, int, Class)}
             *     Activation probability: 0.14286
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public void writeBufferInt(Object arg0Value_, ByteOrder arg1Value, long arg2Value, int arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                BufferSlice arg0Value = ((BufferSlice) arg0Value_);
                arg0Value.writeBufferInt(arg1Value, arg2Value, arg3Value, this.bufferType);
                return;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link BufferSlice#writeBufferLong(BufferSlice, ByteOrder, long, long, Class)}
             *     Activation probability: 0.14286
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public void writeBufferLong(Object arg0Value_, ByteOrder arg1Value, long arg2Value, long arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                BufferSlice arg0Value = ((BufferSlice) arg0Value_);
                arg0Value.writeBufferLong(arg1Value, arg2Value, arg3Value, this.bufferType);
                return;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link BufferSlice#writeBufferFloat(BufferSlice, ByteOrder, long, float, Class)}
             *     Activation probability: 0.14286
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public void writeBufferFloat(Object arg0Value_, ByteOrder arg1Value, long arg2Value, float arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                BufferSlice arg0Value = ((BufferSlice) arg0Value_);
                arg0Value.writeBufferFloat(arg1Value, arg2Value, arg3Value, this.bufferType);
                return;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link BufferSlice#writeBufferDouble(BufferSlice, ByteOrder, long, double, Class)}
             *     Activation probability: 0.14286
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public void writeBufferDouble(Object arg0Value_, ByteOrder arg1Value, long arg2Value, double arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                BufferSlice arg0Value = ((BufferSlice) arg0Value_);
                arg0Value.writeBufferDouble(arg1Value, arg2Value, arg3Value, this.bufferType);
                return;
            }

            @Override
            public byte readBufferByte(Object receiver, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((BufferSlice) receiver)).readBufferByte(byteOffset);
            }

            @Override
            public short readBufferShort(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((BufferSlice) receiver)).readOther(order, byteOffset);
            }

            @Override
            public int readBufferInt(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((BufferSlice) receiver)).readOther(order, byteOffset);
            }

            @Override
            public long readBufferLong(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((BufferSlice) receiver)).readOther(order, byteOffset);
            }

            @Override
            public float readBufferFloat(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((BufferSlice) receiver)).readOther(order, byteOffset);
            }

            @Override
            public double readBufferDouble(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((BufferSlice) receiver)).readOther(order, byteOffset);
            }

        }
        @GeneratedBy(BufferSlice.class)
        @DenyReplace
        private static final class Uncached extends InteropLibrary {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof BufferSlice) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof BufferSlice && accepts_(receiver);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public boolean hasBufferElements(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((BufferSlice) receiver) .hasBufferElements();
            }

            @TruffleBoundary
            @Override
            public boolean isBufferWritable(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((BufferSlice) receiver) .isBufferWritable();
            }

            @TruffleBoundary
            @Override
            public long getBufferSize(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((BufferSlice) receiver) .getBufferSize();
            }

            @TruffleBoundary
            @Override
            public void writeBufferByte(Object arg0Value_, long arg1Value, byte arg2Value) throws InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                BufferSlice arg0Value = ((BufferSlice) arg0Value_);
                arg0Value.writeBufferByte(arg1Value, arg2Value, (arg0Value.buffer.getClass()));
                return;
            }

            @TruffleBoundary
            @Override
            public void writeBufferShort(Object arg0Value_, ByteOrder arg1Value, long arg2Value, short arg3Value) throws InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                BufferSlice arg0Value = ((BufferSlice) arg0Value_);
                arg0Value.writeBufferShort(arg1Value, arg2Value, arg3Value, (arg0Value.buffer.getClass()));
                return;
            }

            @TruffleBoundary
            @Override
            public void writeBufferInt(Object arg0Value_, ByteOrder arg1Value, long arg2Value, int arg3Value) throws InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                BufferSlice arg0Value = ((BufferSlice) arg0Value_);
                arg0Value.writeBufferInt(arg1Value, arg2Value, arg3Value, (arg0Value.buffer.getClass()));
                return;
            }

            @TruffleBoundary
            @Override
            public void writeBufferLong(Object arg0Value_, ByteOrder arg1Value, long arg2Value, long arg3Value) throws InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                BufferSlice arg0Value = ((BufferSlice) arg0Value_);
                arg0Value.writeBufferLong(arg1Value, arg2Value, arg3Value, (arg0Value.buffer.getClass()));
                return;
            }

            @TruffleBoundary
            @Override
            public void writeBufferFloat(Object arg0Value_, ByteOrder arg1Value, long arg2Value, float arg3Value) throws InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                BufferSlice arg0Value = ((BufferSlice) arg0Value_);
                arg0Value.writeBufferFloat(arg1Value, arg2Value, arg3Value, (arg0Value.buffer.getClass()));
                return;
            }

            @TruffleBoundary
            @Override
            public void writeBufferDouble(Object arg0Value_, ByteOrder arg1Value, long arg2Value, double arg3Value) throws InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                BufferSlice arg0Value = ((BufferSlice) arg0Value_);
                arg0Value.writeBufferDouble(arg1Value, arg2Value, arg3Value, (arg0Value.buffer.getClass()));
                return;
            }

            @TruffleBoundary
            @Override
            public byte readBufferByte(Object receiver, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((BufferSlice) receiver) .readBufferByte(byteOffset);
            }

            @TruffleBoundary
            @Override
            public short readBufferShort(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((BufferSlice) receiver) .readOther(order, byteOffset);
            }

            @TruffleBoundary
            @Override
            public int readBufferInt(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((BufferSlice) receiver) .readOther(order, byteOffset);
            }

            @TruffleBoundary
            @Override
            public long readBufferLong(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((BufferSlice) receiver) .readOther(order, byteOffset);
            }

            @TruffleBoundary
            @Override
            public float readBufferFloat(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((BufferSlice) receiver) .readOther(order, byteOffset);
            }

            @TruffleBoundary
            @Override
            public double readBufferDouble(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((BufferSlice) receiver) .readOther(order, byteOffset);
            }

            @TruffleBoundary
            private static boolean accepts_(Object arg0Value_) {
                BufferSlice arg0Value = ((BufferSlice) arg0Value_);
                return arg0Value.accepts((arg0Value.buffer.getClass()));
            }

        }
    }
}
