/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.nfi.CallSignatureNode;
import com.oracle.truffle.nfi.NFIClosure;
import com.oracle.truffle.nfi.NFILanguage;
import com.oracle.truffle.nfi.NFISymbol;
import com.oracle.truffle.nfi.NFIType;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import com.oracle.truffle.nfi.backend.spi.NFIBackendSignatureBuilderLibrary;
import com.oracle.truffle.nfi.backend.spi.NFIBackendSignatureLibrary;
import com.oracle.truffle.nfi.backend.spi.util.ProfiledArrayBuilder;

@ExportLibrary.Repeat(value={@ExportLibrary(value=InteropLibrary.class), @ExportLibrary(value=SignatureLibrary.class, useForAOT=true, useForAOTPriority=1)})
final class NFISignature
implements TruffleObject {
    final String backendId;
    final SignatureCachedState cachedState;
    final Object nativeSignature;
    final NFIType retType;
    final NFIType[] argTypes;
    final int nativeArgCount;
    final int managedArgCount;

    NFISignature(String backendId, SignatureCachedState cachedState, Object nativeSignature, NFIType retType, NFIType[] argTypes, int nativeArgCount, int managedArgCount) {
        this.backendId = backendId;
        this.cachedState = cachedState;
        this.nativeSignature = nativeSignature;
        this.retType = retType;
        this.argTypes = argTypes;
        this.nativeArgCount = nativeArgCount;
        this.managedArgCount = managedArgCount;
    }

    @ExportMessage
    Object call(Object function, Object[] args, @Cached CallSignatureNode.CachedCallSignatureNode call) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
        return call.execute(this, function, args);
    }

    static boolean isBind(String member) {
        return "bind".equals(member);
    }

    static boolean isCreateClosure(String member) {
        return "createClosure".equals(member);
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    Object getMembers(boolean includeInternal) {
        return new SignatureMembers();
    }

    @ExportMessage
    boolean isMemberInvocable(String member) {
        return NFISignature.isBind(member) || NFISignature.isCreateClosure(member);
    }

    static final class SignatureCachedState {
        final NFIType.TypeCachedState retType;
        final ArgsCachedState args;
        private CallTarget polymorphicSignatureCall;
        private CallTarget polymorphicClosureCall;

        private SignatureCachedState(NFIType.TypeCachedState retType, ArgsCachedState args) {
            this.retType = retType;
            this.args = args;
        }

        @NeverDefault
        static SignatureCachedState create(SignatureBuilder builder) {
            return new SignatureCachedState(builder.retTypeState, builder.argsState);
        }

        @NeverDefault
        CallSignatureNode createOptimizedSignatureCall() {
            CompilerAsserts.neverPartOfCompilation((String)"createOptimizedSignatureCall");
            return CallSignatureNode.createOptimizedCall(this.retType, this.args);
        }

        @NeverDefault
        CallSignatureNode createOptimizedClosureCall() {
            CompilerAsserts.neverPartOfCompilation((String)"createOptimizedClosureCall");
            return CallSignatureNode.createOptimizedClosure(this.retType, this.args);
        }

        @CompilerDirectives.TruffleBoundary
        private synchronized void initPolymorphicSignatureCall() {
            if (this.polymorphicSignatureCall == null) {
                CallSignatureNode call = this.createOptimizedSignatureCall();
                CallSignatureNode.CallSignatureRootNode rootNode = new CallSignatureNode.CallSignatureRootNode(NFILanguage.get(null), call);
                this.polymorphicSignatureCall = rootNode.getCallTarget();
            }
        }

        @NeverDefault
        CallTarget getPolymorphicSignatureCall() {
            if (this.polymorphicSignatureCall == null) {
                this.initPolymorphicSignatureCall();
            }
            assert (this.polymorphicSignatureCall != null);
            return this.polymorphicSignatureCall;
        }

        @CompilerDirectives.TruffleBoundary
        private synchronized void initPolymorphicClosureCall() {
            if (this.polymorphicClosureCall == null) {
                CallSignatureNode call = this.createOptimizedClosureCall();
                CallSignatureNode.CallSignatureRootNode rootNode = new CallSignatureNode.CallSignatureRootNode(NFILanguage.get(null), call);
                this.polymorphicClosureCall = rootNode.getCallTarget();
            }
        }

        @NeverDefault
        CallTarget getPolymorphicClosureCall() {
            if (this.polymorphicClosureCall == null) {
                this.initPolymorphicClosureCall();
            }
            assert (this.polymorphicClosureCall != null);
            return this.polymorphicClosureCall;
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class SignatureMembers
    implements TruffleObject {
        SignatureMembers() {
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        Object readArrayElement(long index, @Bind(value="$node") Node node, @Cached InlinedBranchProfile ioob) throws InvalidArrayIndexException {
            if (index == 0L) {
                return "bind";
            }
            if (index == 1L) {
                return "createClosure";
            }
            ioob.enter(node);
            throw InvalidArrayIndexException.create((long)index);
        }

        @ExportMessage
        long getArraySize() {
            return 2L;
        }

        @ExportMessage
        boolean isArrayElementReadable(long index) {
            return Long.compareUnsigned(index, 2L) < 0;
        }
    }

    @ExportLibrary(value=NFIBackendSignatureBuilderLibrary.class)
    static final class SignatureBuilder {
        final String backendId;
        final Object backendBuilder;
        NFIType retType;
        ProfiledArrayBuilder<NFIType> argTypes;
        NFIType.TypeCachedState retTypeState;
        @NeverDefault
        ArgsCachedState argsState;

        SignatureBuilder(String backendId, Object backendBuilder, ProfiledArrayBuilder<NFIType> argTypes) {
            this.backendId = backendId;
            this.backendBuilder = backendBuilder;
            this.argsState = ArgsCachedState.NO_ARGS;
            this.argTypes = argTypes;
        }

        @ExportMessage
        void makeVarargs(@CachedLibrary(value="this.backendBuilder") NFIBackendSignatureBuilderLibrary backendLibrary) {
            backendLibrary.makeVarargs(this.backendBuilder);
        }

        @ExportMessage
        static class Build {
            Build() {
            }

            @Specialization(guards={"builder.argsState == cachedState.args", "builder.retTypeState == cachedState.retType"}, limit="1")
            static NFISignature doCached(SignatureBuilder builder, @Cached(value="create(builder)") SignatureCachedState cachedState, @CachedLibrary(value="builder.backendBuilder") NFIBackendSignatureBuilderLibrary backendLibrary) {
                Object nativeSignature = backendLibrary.build(builder.backendBuilder);
                return new NFISignature(builder.backendId, cachedState, nativeSignature, builder.retType, builder.argTypes.getFinalArray(), cachedState.args.nativeArgCount, cachedState.args.managedArgCount);
            }

            @Specialization(replaces={"doCached"})
            static NFISignature doGeneric(SignatureBuilder builder, @CachedLibrary(value="builder.backendBuilder") NFIBackendSignatureBuilderLibrary backendLibrary) {
                Object nativeSignature = backendLibrary.build(builder.backendBuilder);
                return new NFISignature(builder.backendId, null, nativeSignature, builder.retType, builder.argTypes.getFinalArray(), builder.argsState.nativeArgCount, builder.argsState.managedArgCount);
            }
        }

        @ExportMessage
        static class SetReturnType {
            SetReturnType() {
            }

            @Specialization
            static void doSet(SignatureBuilder builder, NFIType type, @CachedLibrary(value="builder.backendBuilder") NFIBackendSignatureBuilderLibrary backendLibrary) {
                builder.retType = type;
                builder.retTypeState = type.cachedState;
                backendLibrary.setReturnType(builder.backendBuilder, type.backendType);
            }
        }

        @ExportMessage
        static class AddArgument {
            AddArgument() {
            }

            @Specialization(guards={"builder.argsState == prevArgsState", "type.cachedState == argState"}, limit="1")
            static void doCached(SignatureBuilder builder, NFIType type, @Cached(value="builder.argsState") ArgsCachedState prevArgsState, @Cached(value="type.cachedState") NFIType.TypeCachedState argState, @Cached(value="prevArgsState.addArg(argState)") ArgsCachedState newArgsState, @CachedLibrary(value="builder.backendBuilder") NFIBackendSignatureBuilderLibrary backendLibrary) {
                assert (builder.argsState == prevArgsState && type.cachedState == argState);
                builder.argsState = newArgsState;
                backendLibrary.addArgument(builder.backendBuilder, type.backendType);
                builder.argTypes.add(type);
            }

            @Specialization(replaces={"doCached"})
            static void doGeneric(SignatureBuilder builder, NFIType type, @CachedLibrary(value="builder.backendBuilder") NFIBackendSignatureBuilderLibrary backendLibrary) {
                builder.argsState = builder.argsState.addArg(type.cachedState);
                backendLibrary.addArgument(builder.backendBuilder, type.backendType);
                builder.argTypes.add(type);
            }
        }
    }

    static final class ArgsCachedState {
        static final ArgsCachedState NO_ARGS = new ArgsCachedState();
        final int nativeArgCount;
        final int managedArgCount;
        final NFIType.TypeCachedState argType;
        final ArgsCachedState prev;

        private ArgsCachedState() {
            this(0, 0, null, null);
        }

        private ArgsCachedState(int nativeArgCount, int managedArgCount, NFIType.TypeCachedState argType, ArgsCachedState prev) {
            this.nativeArgCount = nativeArgCount;
            this.managedArgCount = managedArgCount;
            this.argType = argType;
            this.prev = prev;
        }

        @NeverDefault
        ArgsCachedState addArg(NFIType.TypeCachedState type) {
            return new ArgsCachedState(this.nativeArgCount + 1, this.managedArgCount + type.managedArgCount, type, this);
        }
    }

    @ExportMessage
    static class InvokeMember {
        InvokeMember() {
        }

        @Specialization(guards={"isBind(member)"})
        static Object doBind(NFISignature signature, String member, Object[] args, @Bind(value="$node") Node node, @CachedLibrary(value="signature") SignatureLibrary signatureLibrary, @Cached.Shared(value="invokeException") @Cached InlinedBranchProfile exception) throws ArityException {
            if (args.length != 1) {
                exception.enter(node);
                throw ArityException.create((int)1, (int)1, (int)args.length);
            }
            return signatureLibrary.bind(signature, args[0]);
        }

        @Specialization(guards={"isCreateClosure(member)"})
        static Object doCreateClosure(NFISignature signature, String member, Object[] args, @Bind(value="$node") Node node, @CachedLibrary(value="signature") SignatureLibrary signatureLibrary, @Cached.Shared(value="invokeException") @Cached InlinedBranchProfile exception) throws ArityException {
            if (args.length != 1) {
                exception.enter(node);
                throw ArityException.create((int)1, (int)1, (int)args.length);
            }
            return signatureLibrary.createClosure(signature, args[0]);
        }

        @Fallback
        static Object doUnknown(NFISignature signature, String member, Object[] args) throws UnknownIdentifierException {
            throw UnknownIdentifierException.create((String)member);
        }
    }

    @ExportMessage
    @ImportStatic(value={NFILanguage.class})
    static class CreateClosure {
        CreateClosure() {
        }

        @NeverDefault
        static NFIClosure createClosure(Object executable, NFISignature signature) {
            return new NFIClosure(executable, signature);
        }

        @Specialization(guards={"executable == cachedClosure.executable", "signature == cachedClosure.signature"}, assumptions={"getSingleContextAssumption()"}, limit="3")
        @GenerateAOT.Exclude
        static Object doCached(NFISignature signature, Object executable, @Cached(value="createClosure(executable, signature)") NFIClosure cachedClosure, @CachedLibrary(value="cachedClosure.signature.nativeSignature") NFIBackendSignatureLibrary lib, @Cached(value="lib.createClosure(cachedClosure.signature.nativeSignature, cachedClosure)") Object cachedRet) {
            return cachedRet;
        }

        @Specialization(replaces={"doCached"})
        @GenerateAOT.Exclude
        static Object doCreate(NFISignature signature, Object executable, @CachedLibrary(value="signature.nativeSignature") NFIBackendSignatureLibrary lib) {
            NFIClosure closure = new NFIClosure(executable, signature);
            return lib.createClosure(signature.nativeSignature, closure);
        }
    }

    @ExportMessage(name="bind")
    static class BindMsg {
        BindMsg() {
        }

        @Specialization
        static Object doSymbol(NFISignature signature, NFISymbol function) {
            return NFISymbol.createBound(function.nativeSymbol, signature);
        }

        @Fallback
        static Object doOther(NFISignature signature, Object function) {
            return NFISymbol.createBound(function, signature);
        }
    }
}

