/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.nfi.SignatureRootNode;
import com.oracle.truffle.nfi.backend.spi.types.NativeLibraryDescriptor;
import java.util.ArrayList;
import java.util.List;

final class NativeSource {
    private final String nfiId;
    private final Content content;

    NativeSource(String nfiId, Content content) {
        this.nfiId = nfiId;
        this.content = content;
    }

    public boolean isDefaultBackend() {
        return this.nfiId == null;
    }

    public String getNFIBackendId() {
        return this.nfiId;
    }

    public Content getContent() {
        return this.content;
    }

    static abstract class Content {
        Content() {
        }
    }

    static final class ParsedLibrary
    extends Content {
        private final NativeLibraryDescriptor libraryDescriptor;
        private final List<String> preBoundSymbols;
        private final List<SignatureRootNode.BuildSignatureNode> preBoundSignatures;

        ParsedLibrary(NativeLibraryDescriptor libraryDescriptor) {
            this.libraryDescriptor = libraryDescriptor;
            this.preBoundSymbols = new ArrayList<String>();
            this.preBoundSignatures = new ArrayList<SignatureRootNode.BuildSignatureNode>();
        }

        public NativeLibraryDescriptor getLibraryDescriptor() {
            return this.libraryDescriptor;
        }

        public int preBoundSymbolsLength() {
            return this.preBoundSymbols.size();
        }

        public String getPreBoundSymbol(int i) {
            return this.preBoundSymbols.get(i);
        }

        public SignatureRootNode.BuildSignatureNode getPreBoundSignature(int i) {
            return this.preBoundSignatures.get(i);
        }

        void register(String symbol, SignatureRootNode.BuildSignatureNode signature) {
            this.preBoundSymbols.add(symbol);
            this.preBoundSignatures.add(signature);
        }
    }

    static final class ParsedSignature
    extends Content {
        private final SignatureRootNode.BuildSignatureNode buildSignature;

        ParsedSignature(SignatureRootNode.BuildSignatureNode buildSignature) {
            this.buildSignature = buildSignature;
        }

        public SignatureRootNode.BuildSignatureNode getBuildSignatureNode() {
            return this.buildSignature;
        }
    }
}

