/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.nfi.CallSignatureNodeFactory;
import com.oracle.truffle.nfi.ConvertTypeNode;
import com.oracle.truffle.nfi.NFILanguage;
import com.oracle.truffle.nfi.NFISignature;
import com.oracle.truffle.nfi.NFISymbol;
import com.oracle.truffle.nfi.NFIType;
import com.oracle.truffle.nfi.backend.spi.NFIBackendSignatureLibrary;

@GenerateAOT
abstract class CallSignatureNode
extends Node {
    CallSignatureNode() {
    }

    abstract Object execute(NFISignature var1, Object var2, Object[] var3) throws ArityException, UnsupportedTypeException, UnsupportedMessageException;

    @NeverDefault
    static CallSignatureNode createOptimizedCall(NFIType.TypeCachedState retType, NFISignature.ArgsCachedState argsState) {
        return CallSignatureNodeFactory.OptimizedCallSignatureNodeGen.create(retType, argsState);
    }

    @NeverDefault
    static CallSignatureNode createOptimizedClosure(NFIType.TypeCachedState retType, NFISignature.ArgsCachedState argsState) {
        return CallSignatureNodeFactory.OptimizedCallClosureNodeGen.create(retType, argsState);
    }

    static abstract class OptimizedCallSignatureNode
    extends CallSignatureNode {
        @Node.Child
        ConvertTypeNode convertRet;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final NFIType.TypeCachedState[] argTypes;
        @Node.Children
        final ConvertTypeNode[] convertArgs;
        private final int managedArgCount;

        OptimizedCallSignatureNode(NFIType.TypeCachedState retType, NFISignature.ArgsCachedState argsState) {
            this.convertRet = retType.createFromNative();
            this.argTypes = new NFIType.TypeCachedState[argsState.nativeArgCount];
            this.convertArgs = new ConvertTypeNode[argsState.nativeArgCount];
            this.managedArgCount = argsState.managedArgCount;
            NFISignature.ArgsCachedState cur = argsState;
            for (int i = argsState.nativeArgCount - 1; i >= 0; --i) {
                this.argTypes[i] = cur.argType;
                this.convertArgs[i] = cur.argType.createToNative();
                cur = cur.prev;
            }
        }

        @ExplodeLoop
        Object[] prepareArgs(NFISignature signature, Object[] args) throws UnsupportedTypeException {
            Object[] preparedArgs = new Object[this.convertArgs.length];
            int argIdx = 0;
            for (int i = 0; i < this.convertArgs.length; ++i) {
                Object input = null;
                if (this.argTypes[i].managedArgCount == 1) {
                    input = args[argIdx++];
                }
                preparedArgs[i] = this.convertArgs[i].execute(signature.argTypes[i], input);
            }
            assert (argIdx == this.managedArgCount);
            return preparedArgs;
        }

        @Specialization
        Object doCall(NFISignature signature, Object function, Object[] args, @Cached InlinedBranchProfile exception, @CachedLibrary(limit="1") NFIBackendSignatureLibrary backendLibrary, @Cached BackendSymbolUnwrapNode backendSymbolUnwrapNode) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            if (args.length != this.managedArgCount) {
                exception.enter((Node)this);
                throw ArityException.create((int)this.managedArgCount, (int)this.managedArgCount, (int)args.length);
            }
            Object[] preparedArgs = this.prepareArgs(signature, args);
            Object ret = backendLibrary.call(signature.nativeSignature, backendSymbolUnwrapNode.execute(this, function), preparedArgs);
            return this.convertRet.execute(signature.retType, ret);
        }
    }

    static abstract class OptimizedCallClosureNode
    extends CallSignatureNode {
        @Node.Child
        ConvertTypeNode convertRet;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final NFIType.TypeCachedState[] argTypes;
        @Node.Children
        final ConvertTypeNode[] convertArgs;
        final int managedArgCount;

        OptimizedCallClosureNode(NFIType.TypeCachedState retType, NFISignature.ArgsCachedState argsState) {
            this.convertRet = retType.createToNative();
            this.argTypes = new NFIType.TypeCachedState[argsState.nativeArgCount];
            this.convertArgs = new ConvertTypeNode[argsState.nativeArgCount];
            this.managedArgCount = argsState.managedArgCount;
            NFISignature.ArgsCachedState cur = argsState;
            for (int i = argsState.nativeArgCount - 1; i >= 0; --i) {
                this.argTypes[i] = cur.argType;
                this.convertArgs[i] = cur.argType.createFromNative();
                cur = cur.prev;
            }
        }

        @ExplodeLoop
        Object[] prepareArgs(NFISignature signature, Object[] args) throws UnsupportedTypeException {
            Object[] preparedArgs = new Object[this.managedArgCount];
            int argIdx = 0;
            for (int i = 0; i < this.convertArgs.length; ++i) {
                if (this.argTypes[i].managedArgCount != 1) continue;
                preparedArgs[argIdx++] = this.convertArgs[i].execute(signature.argTypes[i], args[i]);
            }
            assert (argIdx == this.managedArgCount);
            return preparedArgs;
        }

        @Specialization(limit="1")
        @GenerateAOT.Exclude
        Object doCall(NFISignature signature, Object function, Object[] args, @Bind(value="this") Node node, @Cached InlinedBranchProfile exception, @CachedLibrary(value="function") InteropLibrary interop) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            if (args.length != this.convertArgs.length) {
                exception.enter(node);
                throw ArityException.create((int)this.convertArgs.length, (int)this.convertArgs.length, (int)args.length);
            }
            Object[] preparedArgs = this.prepareArgs(signature, args);
            Object ret = interop.execute(function, preparedArgs);
            return this.convertRet.execute(signature.retType, ret);
        }
    }

    @GenerateAOT
    @GenerateUncached
    @GenerateCached(value=false)
    @GenerateInline
    static abstract class BackendSymbolUnwrapNode
    extends Node {
        BackendSymbolUnwrapNode() {
        }

        abstract Object execute(Node var1, Object var2);

        @Specialization
        Object unwrapNFISymbol(NFISymbol symbol) {
            return symbol.nativeSymbol;
        }

        @Fallback
        Object noUnwrap(Object symbol) {
            return symbol;
        }
    }

    static final class CallSignatureRootNode
    extends RootNode {
        @Node.Child
        CallSignatureNode callSignature;

        CallSignatureRootNode(NFILanguage language, CallSignatureNode callSignature) {
            super((TruffleLanguage)language);
            this.callSignature = callSignature;
        }

        public Object execute(VirtualFrame frame) {
            NFISignature signature = (NFISignature)frame.getArguments()[0];
            Object function = frame.getArguments()[1];
            Object[] args = (Object[])frame.getArguments()[2];
            try {
                return this.callSignature.execute(signature, function, args);
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw CallSignatureRootNode.silenceException(RuntimeException.class, (Exception)e);
            }
        }

        static <E extends Exception> RuntimeException silenceException(Class<E> type, Exception ex) throws E {
            throw ex;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class CachedCallSignatureNode
    extends CallSignatureNode {
        CachedCallSignatureNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"cachedState != null", "signature.cachedState == cachedState"}, limit="3")
        Object doOptimizedDirect(NFISignature signature, Object function, Object[] args, @Cached(value="signature.cachedState") NFISignature.SignatureCachedState cachedState, @Cached(value="cachedState.createOptimizedSignatureCall()") CallSignatureNode call) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            try {
                assert (cachedState == signature.cachedState);
                Object object = call.execute(signature, function, args);
                return object;
            }
            finally {
                NFILanguage.get(this).rethrowPendingException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(replaces={"doOptimizedDirect"}, guards={"signature.cachedState != null"})
        @ReportPolymorphism.Megamorphic
        Object doOptimizedIndirect(NFISignature signature, Object function, Object[] args, @Cached IndirectCallNode call) {
            try {
                Object object = call.call(signature.cachedState.getPolymorphicSignatureCall(), new Object[]{signature, function, args});
                return object;
            }
            finally {
                NFILanguage.get(this).rethrowPendingException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"signature.cachedState == null"})
        @ReportPolymorphism.Megamorphic
        static Object doSlowPath(NFISignature signature, Object function, Object[] args, @Bind(value="this") Node node, @Cached InlinedBranchProfile exception, @Cached ConvertTypeNode.ConvertToNativeNode convertArg, @Cached ConvertTypeNode.ConvertFromNativeNode convertRet, @CachedLibrary(limit="3") NFIBackendSignatureLibrary nativeLibrary, @Cached BackendSymbolUnwrapNode backendSymbolUnwrapNode) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            try {
                if (args.length != signature.managedArgCount) {
                    exception.enter(node);
                    throw ArityException.create((int)signature.managedArgCount, (int)signature.managedArgCount, (int)args.length);
                }
                Object[] preparedArgs = new Object[signature.nativeArgCount];
                int argIdx = 0;
                for (int i = 0; i < preparedArgs.length; ++i) {
                    Object input = null;
                    if (signature.argTypes[i].cachedState.managedArgCount == 1) {
                        input = args[argIdx++];
                    }
                    preparedArgs[i] = convertArg.executeInlined(node, signature.argTypes[i], input);
                }
                Object ret = nativeLibrary.call(signature.nativeSignature, backendSymbolUnwrapNode.execute(node, function), preparedArgs);
                Object object = convertRet.executeInlined(node, signature.retType, ret);
                return object;
            }
            finally {
                NFILanguage.get(node).rethrowPendingException();
            }
        }
    }
}

