/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.stumbleupon.async.Deferred;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import org.hbase.async.AtomicIncrementRequest;
import org.hbase.async.Bytes;
import org.hbase.async.HBaseClient;

final class BufferedIncrement {
    private final byte[] table;
    private final byte[] key;
    private final byte[] family;
    private final byte[] qualifier;
    private static final Loader LOADER = new Loader();
    static final CacheStats ZERO_STATS = new CacheStats(0L, 0L, 0L, 0L, 0L, 0L);

    BufferedIncrement(byte[] table, byte[] key, byte[] family, byte[] qualifier) {
        this.table = table;
        this.key = key;
        this.family = family;
        this.qualifier = qualifier;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof BufferedIncrement)) {
            return false;
        }
        BufferedIncrement incr = (BufferedIncrement)other;
        return Bytes.equals(this.qualifier, incr.qualifier) && Bytes.equals(this.key, incr.key) && Bytes.equals(this.family, incr.family) && Bytes.equals(this.table, incr.table);
    }

    public int hashCode() {
        return Arrays.hashCode(this.table) + 41 * (Arrays.hashCode(this.key) + 41 * (Arrays.hashCode(this.family) + 41 * (Arrays.hashCode(this.qualifier) + 41)));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(52 + this.table.length + this.key.length * 2 + this.family.length + this.qualifier.length);
        buf.append("BufferedIncrement(table=");
        Bytes.pretty(buf, this.table);
        buf.append(", key=");
        Bytes.pretty(buf, this.key);
        buf.append(", family=");
        Bytes.pretty(buf, this.family);
        buf.append(", qualifier=");
        Bytes.pretty(buf, this.qualifier);
        buf.append(')');
        return buf.toString();
    }

    static LoadingCache<BufferedIncrement, Amount> newCache(HBaseClient client, int size) {
        int ncpu = Runtime.getRuntime().availableProcessors();
        return CacheBuilder.newBuilder().concurrencyLevel(ncpu * 4).maximumSize((long)size).recordStats().removalListener((RemovalListener)new EvictionHandler(client)).build((CacheLoader)LOADER);
    }

    private static final class EvictionHandler
    implements RemovalListener<BufferedIncrement, Amount> {
        private final HBaseClient client;

        EvictionHandler(HBaseClient client) {
            this.client = client;
        }

        public void onRemoval(RemovalNotification<BufferedIncrement, Amount> entry) {
            Amount amount = (Amount)entry.getValue();
            long raw = amount.getRawAndInvalidate();
            long delta = Amount.amount(raw);
            if (Amount.numUpdatesLeft(raw) == 16383) {
                assert (delta == 0L) : "WTF? Pristine Amount with non-0 delta: " + amount;
                return;
            }
            BufferedIncrement incr = (BufferedIncrement)entry.getKey();
            AtomicIncrementRequest req = new AtomicIncrementRequest(incr.table, incr.key, incr.family, incr.qualifier, delta);
            this.client.atomicIncrement(req).chain(amount.deferred);
        }
    }

    static final class Loader
    extends CacheLoader<BufferedIncrement, Amount> {
        private static final short MAX_UPDATES = 16383;

        Loader() {
        }

        public Amount load(BufferedIncrement key) {
            return new Amount(16383);
        }
    }

    static final class Amount
    extends AtomicLong {
        private static final int UPDATE_BITS = 15;
        private static final long UPDATE_MASK = 32767L;
        private static final long OVERFLOW_MASK = -281474976710656L;
        final Deferred<Long> deferred = new Deferred();
        private static final long serialVersionUID = 1333868942L;

        Amount(short max_updates) {
            super(max_updates);
            assert (max_updates > 0) : "WTF: max_updates=" + max_updates;
        }

        final boolean update(long delta) {
            int updates;
            long new_amount;
            long next;
            long current;
            do {
                if ((updates = Amount.numUpdatesLeft(current = super.get())) == 0) {
                    return false;
                }
                new_amount = Amount.amount(current) + delta;
                if (Amount.checkOverflow(new_amount)) continue;
                return false;
            } while (!super.compareAndSet(current, next = new_amount << 15 | (long)(updates - 1)));
            return true;
        }

        final long getRawAndInvalidate() {
            long next;
            long current;
            while (!super.compareAndSet(current = super.get(), next = Amount.amount(current) << 15)) {
            }
            return current;
        }

        static final long amount(long n) {
            return n >> 15;
        }

        static final int numUpdatesLeft(long n) {
            return (int)(n & 0x7FFFL);
        }

        static final boolean checkOverflow(long value) {
            long masked = value & 0xFFFF000000000000L;
            return masked == 0L || masked == -281474976710656L;
        }

        @Override
        public String toString() {
            long n = super.get();
            return "Amount(" + Amount.amount(n) + ", " + Amount.numUpdatesLeft(n) + " updates left, " + this.deferred + ')';
        }
    }
}

