/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.hbase.async.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRTableMappingRules {
    public static final String MAPR_ENGINE = "mapr";
    public static final String HBASE_ENGINE = "hbase";
    public static final String HBASE_TABLE_NAMESPACE_MAPPINGS = "hbase.table.namespace.mappings";
    private static final String RULE_SPLITTER = ":";
    private static final String RULE_SEPARATOR = ",";
    private static final String EMPTY_RULE = "";
    private static final Pattern BSLASH_PATTERN = Pattern.compile("\\\\+");
    private static final Logger LOG = LoggerFactory.getLogger(MapRTableMappingRules.class);
    private static final Map<String, RuleList> ruleListMap_ = new HashMap<String, RuleList>();
    private final ClusterType clusterType_;
    private final Configuration conf_;
    private RuleList ruleList_ = null;
    private volatile FileSystem fs_ = null;
    private Cache<String, Path> namePathCache_ = CacheBuilder.newBuilder().maximumSize(128L).build();
    public static final String HBASE_AVAILABLE = "hbase.available";
    public static final String MAPRFS_PREFIX = "maprfs://";
    public static final String HBASE_PREFIX = "hbase://";
    public static final Path HBASE_PREFIX_PATH = new Path("hbase://");
    public static final byte[] ROOT_TABLE_NAME = "-ROOT-".getBytes();
    public static final byte[] META_TABLE_NAME = ".META.".getBytes();
    public static final String UTF8_ENCODING = "UTF-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapRTableMappingRules(Configuration conf) {
        String mappingRules = conf.get(HBASE_TABLE_NAMESPACE_MAPPINGS, EMPTY_RULE).trim();
        Map<String, RuleList> map = ruleListMap_;
        synchronized (map) {
            this.ruleList_ = ruleListMap_.get(mappingRules);
            if (this.ruleList_ == null) {
                this.ruleList_ = new RuleList(mappingRules);
                ruleListMap_.put(mappingRules, this.ruleList_);
            }
        }
        this.conf_ = conf;
        this.clusterType_ = conf.getBoolean(HBASE_AVAILABLE, true) ? ClusterType.HBASE_MAPR : ClusterType.MAPR_ONLY;
    }

    public boolean isMapRDefault() {
        return this.ruleList_.isAllTableGoose() || MAPR_ENGINE.equals(this.conf_.get("db.engine.default", HBASE_ENGINE));
    }

    public ClusterType getClusterType() {
        return this.clusterType_;
    }

    public boolean isMapRTable(String tableName) {
        return this.getMapRTablePath(tableName) != null;
    }

    public static boolean isMapRTable(Configuration conf, String tableName) {
        return new MapRTableMappingRules(conf).isMapRTable(tableName);
    }

    public String toString() {
        return "TableMappingRule [rules_='" + this.ruleList_.rules_ + "']";
    }

    public static boolean isMetaTable(String tableName) {
        return Bytes.equals(tableName.getBytes(), ROOT_TABLE_NAME) || Bytes.equals(tableName.getBytes(), META_TABLE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getMapRTablePath(String tableName) throws IllegalArgumentException {
        if (tableName == null) {
            throw new IllegalArgumentException("Table name can not be null.");
        }
        Path tablePath = (Path)this.namePathCache_.getIfPresent((Object)tableName);
        if (tablePath == null) {
            Cache<String, Path> cache = this.namePathCache_;
            synchronized (cache) {
                tablePath = (Path)this.namePathCache_.getIfPresent((Object)tableName);
                if (tablePath == null) {
                    tablePath = this.getTablePath(tableName);
                    this.namePathCache_.put((Object)tableName, (Object)tablePath);
                }
            }
        }
        return tablePath != HBASE_PREFIX_PATH ? tablePath : null;
    }

    private Path getTablePath(String tableName) {
        if ((tableName = BSLASH_PATTERN.matcher(tableName).replaceAll("/")).startsWith("/") || tableName.toLowerCase().startsWith(MAPRFS_PREFIX)) {
            return new Path(tableName);
        }
        if (tableName.toLowerCase().startsWith(HBASE_PREFIX) || MapRTableMappingRules.isMetaTable(tableName)) {
            return HBASE_PREFIX_PATH;
        }
        if (tableName.contains("/")) {
            try {
                return new Path(this.getFS().getHomeDirectory(), tableName);
            }
            catch (Exception e) {
                return HBASE_PREFIX_PATH;
            }
        }
        for (Rule rule : this.ruleList_) {
            String path = rule.uri.toString();
            if (rule.glob.equals(tableName)) {
                return this.makePath(path, tableName);
            }
            if (!rule.pattern.matcher(tableName).matches()) continue;
            return this.makePath(path.endsWith("/") ? path : path + "/", tableName);
        }
        return HBASE_PREFIX_PATH;
    }

    public static Path getMapRTablePath(Configuration conf, String tableName) {
        return new MapRTableMappingRules(conf).getMapRTablePath(tableName);
    }

    protected Path makePath(String parent, String table) {
        Path path = parent.endsWith("/") ? new Path(parent, table) : new Path(parent);
        try {
            if (!parent.startsWith("/")) {
                path = new Path(this.getFS().getHomeDirectory(), path);
            }
        }
        catch (Exception e) {
            return null;
        }
        return path;
    }

    protected synchronized FileSystem getFS() throws IOException {
        if (this.fs_ == null) {
            this.fs_ = FileSystem.get((Configuration)this.conf_);
        }
        return this.fs_;
    }

    static {
        ruleListMap_.put(EMPTY_RULE, new RuleList());
    }

    static class Rule {
        static final String REGEX_SPECIAL_CHARS = "[\\^$.|?+()";
        final URI uri;
        final String glob;
        final Pattern pattern;

        Rule(String glob, URI uri) {
            this.glob = glob;
            this.uri = uri;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < glob.length(); ++i) {
                char ch = glob.charAt(i);
                if (REGEX_SPECIAL_CHARS.indexOf(ch) != -1) {
                    sb.append('\\');
                } else if (ch == '*') {
                    sb.append('.');
                }
                sb.append(ch);
            }
            this.pattern = Pattern.compile(sb.toString());
        }

        public String toString() {
            return "Rule [pattern=" + this.glob + ", uri=" + this.uri + "]";
        }

        boolean matches(String text) {
            return this.pattern.matcher(text).matches();
        }
    }

    static class RuleList
    extends ArrayList<Rule> {
        private static final long serialVersionUID = 1381209101513814010L;
        private final String rules_;
        private boolean isAllTableGoose_ = false;

        public RuleList() {
            this.rules_ = MapRTableMappingRules.EMPTY_RULE;
        }

        RuleList(String rules) {
            this.rules_ = rules;
            String[] mappings = this.rules_.split(MapRTableMappingRules.RULE_SEPARATOR);
            for (int i = 0; i < mappings.length; ++i) {
                String mapping = mappings[i].trim().replaceAll("/+", "/");
                if (this.checkAndAdd(mapping)) continue;
                LOG.warn("Invalid mapping '" + mapping + "' found, ignoring.");
            }
        }

        public boolean isAllTableGoose() {
            return this.isAllTableGoose_;
        }

        public void setAllTableGoose(boolean isAllTableGoose_) {
            this.isAllTableGoose_ = isAllTableGoose_;
        }

        protected boolean checkAndAdd(String mapping) {
            int firstSplit = mapping.indexOf(MapRTableMappingRules.RULE_SPLITTER);
            int lastSplit = mapping.lastIndexOf(MapRTableMappingRules.RULE_SPLITTER);
            int length = mapping.length();
            if (firstSplit <= 0 || lastSplit == length - 1) {
                return false;
            }
            try {
                String[] parts = mapping.split(MapRTableMappingRules.RULE_SPLITTER, 2);
                String glob = parts[0].trim();
                if (glob.equals("*")) {
                    this.isAllTableGoose_ = true;
                }
                URI uri = new URI(parts[1].trim());
                for (Rule rule : this) {
                    if (!rule.pattern.matcher(glob).matches()) continue;
                    LOG.warn("Duplicate mapping '" + mapping + "' found, ignoring. Original rule '" + rule.glob + MapRTableMappingRules.RULE_SPLITTER + rule.uri + "'");
                    return true;
                }
                this.add(new Rule(glob, uri));
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static enum ClusterType {
        HBASE_ONLY,
        MAPR_ONLY,
        HBASE_MAPR;

    }
}

