/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import java.net.SocketAddress;
import org.hbase.async.Bytes;
import org.hbase.async.HBaseClient;
import org.hbase.async.RegionClient;
import org.hbase.async.SecureRpcHelper;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.Channels;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SecureRpcHelper94
extends SecureRpcHelper {
    private static final Logger LOG = LoggerFactory.getLogger(SecureRpcHelper94.class);
    public static final int SWITCH_TO_SIMPLE_AUTH = -88;

    public SecureRpcHelper94(HBaseClient hbase_client, RegionClient region_client, SocketAddress remote_endpoint) {
        super(hbase_client, region_client, remote_endpoint);
    }

    @Override
    public void sendHello(Channel channel) {
        byte[] connectionHeader = new byte[]{115, 114, 112, 99, 4};
        byte[] buf = new byte[6];
        ChannelBuffer buffer = ChannelBuffers.wrappedBuffer((byte[])buf);
        buffer.clear();
        buffer.writeBytes(connectionHeader);
        buffer.writeByte((int)this.client_auth_provider.getAuthMethodCode());
        Channels.write((Channel)channel, (Object)buffer);
        if (this.sasl_client != null) {
            byte[] challengeBytes = null;
            if (this.sasl_client.hasInitialResponse()) {
                challengeBytes = this.processChallenge(new byte[0]);
            }
            if (challengeBytes != null) {
                buf = new byte[4 + challengeBytes.length];
                buffer = ChannelBuffers.wrappedBuffer((byte[])buf);
                buffer.clear();
                buffer.writeInt(challengeBytes.length);
                buffer.writeBytes(challengeBytes);
                Channels.write((Channel)channel, (Object)buffer);
            }
        } else {
            this.sendRPCHeader(channel);
            this.region_client.sendVersion(channel);
        }
    }

    @Override
    public ChannelBuffer handleResponse(ChannelBuffer buf, Channel chan) {
        if (this.sasl_client == null) {
            return buf;
        }
        if (!this.sasl_client.isComplete()) {
            int state;
            int readIdx = buf.readerIndex();
            int rpcid = buf.readInt();
            if (rpcid != -33) {
                LOG.warn("Expected a value of -33 during SASL handshake, recieved " + rpcid);
            }
            if ((state = buf.readInt()) != 0) {
                buf.readerIndex(readIdx);
                return buf;
            }
            int len = buf.readInt();
            if (len == -88) {
                throw new IllegalStateException("Server is requesting to fallback to simple authentication");
            }
            byte[] b = new byte[len];
            buf.readBytes(b);
            byte[] challengeBytes = this.processChallenge(b);
            if (challengeBytes != null) {
                byte[] outBytes = new byte[4 + challengeBytes.length];
                ChannelBuffer outBuffer = ChannelBuffers.wrappedBuffer((byte[])outBytes);
                outBuffer.clear();
                outBuffer.writeInt(challengeBytes.length);
                outBuffer.writeBytes(challengeBytes);
                Channels.write((Channel)chan, (Object)outBuffer);
            }
            if (this.sasl_client.isComplete()) {
                String qop = (String)this.sasl_client.getNegotiatedProperty("javax.security.sasl.qop");
                LOG.info("SASL client context established. Negotiated QoP: " + qop + " on for: " + (Object)((Object)this.region_client));
                this.sendRPCHeader(chan);
                this.region_client.sendVersion(chan);
            }
            return null;
        }
        return this.unwrap(buf);
    }

    private void sendRPCHeader(Channel channel) {
        byte[] user_bytes = Bytes.UTF8(this.client_auth_provider.getClientUsername());
        String klass = "org.apache.hadoop.hbase.ipc.HRegionInterface";
        byte[] class_bytes = Bytes.UTF8("org.apache.hadoop.hbase.ipc.HRegionInterface");
        byte[] buf = new byte[5 + class_bytes.length + 1 + 2 + user_bytes.length + 1];
        ChannelBuffer out_buffer = ChannelBuffers.wrappedBuffer((byte[])buf);
        out_buffer.clear();
        out_buffer.writerIndex(out_buffer.writerIndex() + 4);
        out_buffer.writeByte(class_bytes.length);
        out_buffer.writeBytes(class_bytes);
        out_buffer.writeByte(1);
        out_buffer.writeShort(user_bytes.length);
        out_buffer.writeBytes(user_bytes);
        out_buffer.writeByte(0);
        out_buffer.setInt(0, out_buffer.writerIndex() - 4);
        out_buffer = this.wrap(out_buffer);
        Channels.write((Channel)channel, (Object)out_buffer);
    }
}

