/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.event;

import java.io.Serializable;
import java.util.Set;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.entities.RelationDescription;
import org.hibernate.envers.entities.RelationType;
import org.hibernate.envers.entities.mapper.id.IdMapper;
import org.hibernate.envers.event.EnversListener;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.synchronization.AuditProcess;
import org.hibernate.envers.synchronization.work.CollectionChangeWorkUnit;
import org.hibernate.envers.tools.Tools;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;

public abstract class BaseEnversEventListener
implements EnversListener {
    private AuditConfiguration enversConfiguration;

    protected BaseEnversEventListener(AuditConfiguration enversConfiguration) {
        this.enversConfiguration = enversConfiguration;
    }

    @Override
    public AuditConfiguration getAuditConfiguration() {
        return this.enversConfiguration;
    }

    protected final void generateBidirectionalCollectionChangeWorkUnits(AuditProcess auditProcess, EntityPersister entityPersister, String entityName, Object[] newState, Object[] oldState, SessionImplementor session) {
        if (!this.enversConfiguration.getGlobalCfg().isGenerateRevisionsForCollections()) {
            return;
        }
        String[] propertyNames = entityPersister.getPropertyNames();
        for (int i = 0; i < propertyNames.length; ++i) {
            Object newValue;
            String propertyName = propertyNames[i];
            RelationDescription relDesc = this.enversConfiguration.getEntCfg().getRelationDescription(entityName, propertyName);
            if (relDesc == null || !relDesc.isBidirectional() || relDesc.getRelationType() != RelationType.TO_ONE || !relDesc.isInsertable()) continue;
            Object oldValue = oldState == null ? null : oldState[i];
            Object object = newValue = newState == null ? null : newState[i];
            if (Tools.entitiesEqual(session, relDesc.getToEntityName(), oldValue, newValue)) continue;
            if (newValue != null) {
                this.addCollectionChangeWorkUnit(auditProcess, session, entityName, relDesc, newValue);
            }
            if (oldValue == null) continue;
            this.addCollectionChangeWorkUnit(auditProcess, session, entityName, relDesc, oldValue);
        }
    }

    private void addCollectionChangeWorkUnit(AuditProcess auditProcess, SessionImplementor session, String fromEntityName, RelationDescription relDesc, Object value) {
        Serializable id;
        String toEntityName;
        if (value instanceof HibernateProxy) {
            HibernateProxy hibernateProxy = (HibernateProxy)value;
            toEntityName = session.bestGuessEntityName(value);
            id = hibernateProxy.getHibernateLazyInitializer().getIdentifier();
            value = Tools.getTargetFromProxy(session.getFactory(), hibernateProxy);
        } else {
            toEntityName = session.guessEntityName(value);
            IdMapper idMapper = this.enversConfiguration.getEntCfg().get(toEntityName).getIdMapper();
            id = (Serializable)idMapper.mapToIdFromEntity(value);
        }
        Set<String> toPropertyNames = this.enversConfiguration.getEntCfg().getToPropertyNames(fromEntityName, relDesc.getFromPropertyName(), toEntityName);
        String toPropertyName = toPropertyNames.iterator().next();
        auditProcess.addWorkUnit(new CollectionChangeWorkUnit(session, toEntityName, toPropertyName, this.enversConfiguration, id, value));
    }

    protected void checkIfTransactionInProgress(SessionImplementor session) {
        if (!session.isTransactionInProgress()) {
            throw new AuditException("Unable to create revision because of non-active transaction");
        }
    }
}

