/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation.query;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.envers.configuration.internal.AuditEntitiesConfiguration;
import org.hibernate.envers.configuration.internal.GlobalConfiguration;
import org.hibernate.envers.internal.entities.mapper.id.AbstractCompositeIdMapper;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.internal.entities.mapper.relation.query.AbstractRelationQueryGenerator;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.strategy.AuditStrategy;
import org.hibernate.internal.util.StringHelper;

public final class OneAuditEntityQueryGenerator
extends AbstractRelationQueryGenerator {
    private final String mappedBy;
    private final boolean multipleIdMapperKey;
    private final MiddleIdData referencedIdData;

    public OneAuditEntityQueryGenerator(GlobalConfiguration globalCfg, AuditEntitiesConfiguration verEntCfg, AuditStrategy auditStrategy, MiddleIdData referencingIdData, String referencedEntityName, MiddleIdData referencedIdData, boolean revisionTypeInId, String mappedBy, boolean mappedByKey, String orderBy) {
        super(globalCfg, verEntCfg, auditStrategy, verEntCfg.getAuditEntityName(referencedEntityName), referencingIdData, revisionTypeInId, orderBy);
        this.mappedBy = mappedBy;
        this.referencedIdData = referencedIdData;
        this.multipleIdMapperKey = referencedIdData.getOriginalMapper() instanceof AbstractCompositeIdMapper && mappedByKey;
    }

    @Override
    protected QueryBuilder buildQueryBuilderCommon(SessionFactoryImplementor sessionFactory) {
        QueryBuilder qb = new QueryBuilder(this.entityName, "e__", sessionFactory);
        qb.addProjection(null, "e__", null, false);
        if (this.multipleIdMapperKey) {
            IdMapper mapper = this.getMultipleIdPrefixedMapper();
            mapper.addNamedIdEqualsToQuery(qb.getRootParameters(), null, this.referencingIdData.getPrefixedMapper(), true);
        } else {
            this.referencingIdData.getPrefixedMapper().addNamedIdEqualsToQuery(qb.getRootParameters(), null, true);
        }
        if (!StringHelper.isEmpty((String)this.orderBy)) {
            qb.addOrderFragment("e__", this.orderBy);
        }
        return qb;
    }

    @Override
    protected void applyValidPredicates(QueryBuilder qb, Parameters rootParameters, boolean inclusive) {
        String revisionPropertyPath = this.verEntCfg.getRevisionNumberPath();
        this.auditStrategy.addEntityAtRevisionRestriction(this.globalCfg, qb, rootParameters, revisionPropertyPath, this.verEntCfg.getRevisionEndFieldName(), true, this.referencedIdData, revisionPropertyPath, this.verEntCfg.getOriginalIdPropName(), "e__", "e2__", true);
        rootParameters.addWhereWithNamedParam(this.getRevisionTypePath(), false, "!=", "delrevisiontype");
    }

    @Override
    protected void applyValidAndRemovePredicates(QueryBuilder remQb) {
        Parameters disjoint = remQb.getRootParameters().addSubParameters("or");
        Parameters valid = disjoint.addSubParameters("and");
        Parameters removed = disjoint.addSubParameters("and");
        this.applyValidPredicates(remQb, valid, false);
        removed.addWhereWithNamedParam(this.verEntCfg.getRevisionNumberPath(), false, "=", "revision");
        removed.addWhereWithNamedParam(this.getRevisionTypePath(), false, "=", "delrevisiontype");
    }

    private IdMapper getMultipleIdPrefixedMapper() {
        String prefix = this.verEntCfg.getOriginalIdPropName() + "." + this.mappedBy + ".";
        return this.referencingIdData.getOriginalMapper().prefixMappedProperties(prefix);
    }
}

