/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.osgi;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.persistence.spi.PersistenceProvider;
import org.hibernate.SessionFactory;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.hibernate.osgi.OsgiJtaPlatform;
import org.hibernate.osgi.OsgiPersistenceProviderService;
import org.hibernate.osgi.OsgiServiceUtil;
import org.hibernate.osgi.OsgiSessionFactoryService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class HibernateBundleActivator
implements BundleActivator {
    private OsgiServiceUtil osgiServiceUtil;
    private ServiceRegistration<?> persistenceProviderService;
    private ServiceRegistration<?> sessionFactoryService;

    public void start(BundleContext context) throws Exception {
        this.osgiServiceUtil = new OsgiServiceUtil(context);
        OsgiJtaPlatform osgiJtaPlatform = new OsgiJtaPlatform(this.osgiServiceUtil);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("javax.persistence.provider", HibernatePersistenceProvider.class.getName());
        this.persistenceProviderService = context.registerService(PersistenceProvider.class.getName(), (Object)new OsgiPersistenceProviderService(osgiJtaPlatform, this.osgiServiceUtil), properties);
        this.sessionFactoryService = context.registerService(SessionFactory.class.getName(), (Object)new OsgiSessionFactoryService(osgiJtaPlatform, this.osgiServiceUtil), new Hashtable());
    }

    public void stop(BundleContext context) throws Exception {
        this.osgiServiceUtil.stop();
        this.osgiServiceUtil = null;
        this.persistenceProviderService.unregister();
        this.persistenceProviderService = null;
        this.sessionFactoryService.unregister();
        this.sessionFactoryService = null;
    }
}

