/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.query.dsl.impl.FieldContext;

public class FieldsContext
implements Iterable<FieldContext> {
    public static final String[] NO_FIELD = new String[0];
    private final List<FieldContext> fieldContexts;
    private int firstOfContext = 0;

    public FieldsContext(String[] fieldNames) {
        if (fieldNames == null) {
            fieldNames = NO_FIELD;
        }
        this.fieldContexts = new ArrayList<FieldContext>(fieldNames.length < 4 ? 4 : fieldNames.length);
        for (String fieldName : fieldNames) {
            this.doAdd(fieldName);
        }
    }

    public void add(String fieldName) {
        this.doAdd(fieldName);
        this.firstOfContext = this.fieldContexts.size() - 1;
    }

    private void doAdd(String fieldName) {
        this.fieldContexts.add(new FieldContext(fieldName));
    }

    public void addAll(String ... fieldNames) {
        if (fieldNames.length != 0) {
            this.firstOfContext = this.fieldContexts.size();
            for (String fieldName : fieldNames) {
                this.doAdd(fieldName);
            }
        }
    }

    public void boostedTo(float boost) {
        for (FieldContext fieldContext : this.getCurrentFieldContexts()) {
            fieldContext.getFieldCustomizer().boostedTo(boost);
        }
    }

    public void ignoreAnalyzer() {
        for (FieldContext fieldContext : this.getCurrentFieldContexts()) {
            fieldContext.setIgnoreAnalyzer(true);
        }
    }

    public void ignoreFieldBridge() {
        for (FieldContext fieldContext : this.getCurrentFieldContexts()) {
            fieldContext.setIgnoreFieldBridge(true);
        }
    }

    public void withFieldBridge(FieldBridge fieldBridge) {
        for (FieldContext fieldContext : this.getCurrentFieldContexts()) {
            fieldContext.setFieldBridge(fieldBridge);
        }
    }

    private List<FieldContext> getCurrentFieldContexts() {
        return this.fieldContexts.subList(this.firstOfContext, this.fieldContexts.size());
    }

    public FieldContext getFirst() {
        return this.fieldContexts.get(0);
    }

    public int size() {
        return this.fieldContexts.size();
    }

    @Override
    public Iterator<FieldContext> iterator() {
        return this.fieldContexts.iterator();
    }
}

