/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.reader.impl;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.hibernate.search.indexes.spi.ReaderProvider;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ManagedMultiReader
extends MultiReader {
    private static final Log log = LoggerFactory.make();
    final IndexReader[] subReaders;
    final ReaderProvider[] managers;

    public ManagedMultiReader(IndexReader[] subReaders, ReaderProvider[] managers) {
        super(subReaders, true);
        this.subReaders = subReaders;
        this.managers = managers;
        assert (subReaders.length == managers.length);
    }

    protected synchronized void doClose() throws IOException {
        boolean debugEnabled = log.isDebugEnabled();
        if (debugEnabled) {
            log.debugf("Closing MultiReader: %s", (Object)this);
        }
        for (int i = 0; i < this.subReaders.length; ++i) {
            ReaderProvider container = this.managers[i];
            container.closeIndexReader(this.subReaders[i]);
        }
        if (debugEnabled) {
            log.trace("MultiReader closed.");
        }
    }

    public String toString() {
        return "CacheableMultiReader [subReaders=" + Arrays.toString(this.subReaders) + ", managers=" + Arrays.toString(this.managers) + "]";
    }
}

