/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.batchindexing.impl;

import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

abstract class ErrorHandledRunnable
implements Runnable {
    private static final Log log = LoggerFactory.make();
    protected final ExtendedSearchIntegrator extendedIntegrator;

    protected ErrorHandledRunnable(ExtendedSearchIntegrator extendedIntegrator) {
        this.extendedIntegrator = extendedIntegrator;
    }

    @Override
    public final void run() {
        ErrorHandler errorHandler = this.extendedIntegrator.getErrorHandler();
        try {
            this.runWithErrorHandler();
        }
        catch (Exception re) {
            errorHandler.handleException(log.massIndexerUnexpectedErrorMessage(), (Throwable)re);
            this.cleanUpOnError();
        }
    }

    protected abstract void runWithErrorHandler() throws Exception;

    protected void cleanUpOnError() {
    }
}

