/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.boot;

import org.hibernate.boot.internal.BootstrapContextImpl;
import org.hibernate.boot.internal.InFlightMetadataCollectorImpl;
import org.hibernate.boot.internal.MetadataBuilderImpl;
import org.hibernate.boot.model.naming.ObjectNameNormalizer;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.ClassLoaderAccess;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MappingDefaults;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;

public class MetadataBuildingContextTestingImpl
implements MetadataBuildingContext {
    private final MetadataBuildingOptions buildingOptions;
    private final MappingDefaults mappingDefaults;
    private final InFlightMetadataCollector metadataCollector;
    private final BootstrapContext bootstrapContext;
    private final ObjectNameNormalizer objectNameNormalizer;

    public MetadataBuildingContextTestingImpl(StandardServiceRegistry serviceRegistry) {
        this.buildingOptions = new MetadataBuilderImpl.MetadataBuildingOptionsImpl(serviceRegistry);
        this.bootstrapContext = new BootstrapContextImpl(serviceRegistry, this.buildingOptions);
        this.mappingDefaults = new MetadataBuilderImpl.MappingDefaultsImpl(serviceRegistry);
        this.metadataCollector = new InFlightMetadataCollectorImpl(this.bootstrapContext, this.buildingOptions);
        this.objectNameNormalizer = new ObjectNameNormalizer(){

            protected MetadataBuildingContext getBuildingContext() {
                return MetadataBuildingContextTestingImpl.this;
            }
        };
    }

    public BootstrapContext getBootstrapContext() {
        return this.bootstrapContext;
    }

    public MetadataBuildingOptions getBuildingOptions() {
        return this.buildingOptions;
    }

    public MappingDefaults getMappingDefaults() {
        return this.mappingDefaults;
    }

    public InFlightMetadataCollector getMetadataCollector() {
        return this.metadataCollector;
    }

    public ClassLoaderAccess getClassLoaderAccess() {
        return this.bootstrapContext.getClassLoaderAccess();
    }

    public ObjectNameNormalizer getObjectNameNormalizer() {
        return this.objectNameNormalizer;
    }
}

