/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.JDBCException;
import org.hibernate.cfg.JDBCBinderException;
import org.hibernate.cfg.reveng.dialect.MetaDataDialect;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.tool.util.TableNameQualifier;
import org.jboss.logging.Logger;

public class IndexProcessor {
    private static final Logger log = Logger.getLogger(IndexProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processIndices(MetaDataDialect metaDataDialect, String defaultSchema, String defaultCatalog, Table table) {
        HashMap<String, Index> indexes = new HashMap<String, Index>();
        HashMap<String, UniqueKey> uniquekeys = new HashMap<String, UniqueKey>();
        HashMap<Column, ArrayList<UniqueKey>> uniqueColumns = new HashMap<Column, ArrayList<UniqueKey>>();
        Iterator<Map<String, Object>> indexIterator = null;
        try {
            Map<String, Object> indexRs = null;
            indexIterator = metaDataDialect.getIndexInfo(IndexProcessor.getCatalogForDBLookup(table.getCatalog(), defaultCatalog), IndexProcessor.getSchemaForDBLookup(table.getSchema(), defaultSchema), table.getName());
            while (indexIterator.hasNext()) {
                boolean unique;
                indexRs = indexIterator.next();
                String indexName = (String)indexRs.get("INDEX_NAME");
                String columnName = (String)indexRs.get("COLUMN_NAME");
                boolean bl = unique = (Boolean)indexRs.get("NON_UNIQUE") == false;
                if (columnName != null || indexName != null) {
                    Column column;
                    if (unique) {
                        UniqueKey key = (UniqueKey)uniquekeys.get(indexName);
                        if (key == null) {
                            key = new UniqueKey();
                            key.setName(indexName);
                            key.setTable(table);
                            table.addUniqueKey(key);
                            uniquekeys.put(indexName, key);
                        }
                        if (indexes.containsKey(indexName)) {
                            throw new JDBCBinderException("UniqueKey exists also as Index! ");
                        }
                        column = IndexProcessor.getColumn(metaDataDialect, table, columnName);
                        key.addColumn(column);
                        if (!unique || key.getColumnSpan() != 1) continue;
                        ArrayList<UniqueKey> l = (ArrayList<UniqueKey>)uniqueColumns.get(column);
                        if (l == null) {
                            l = new ArrayList<UniqueKey>();
                            uniqueColumns.put(column, l);
                        }
                        l.add(key);
                        continue;
                    }
                    Index index = (Index)indexes.get(indexName);
                    if (index == null) {
                        index = new Index();
                        index.setName(indexName);
                        index.setTable(table);
                        table.addIndex(index);
                        indexes.put(indexName, index);
                    }
                    if (uniquekeys.containsKey(indexName)) {
                        throw new JDBCBinderException("Index exists also as Unique! ");
                    }
                    column = IndexProcessor.getColumn(metaDataDialect, table, columnName);
                    index.addColumn(column);
                    continue;
                }
                if (0 == (Short)indexRs.get("TYPE")) continue;
                log.warn((Object)("Index was not statistical, but no column name was found in " + indexName));
            }
        }
        catch (JDBCException t) {
            log.warn((Object)("Exception while trying to get indexinfo on " + TableNameQualifier.qualify(table.getCatalog(), table.getSchema(), table.getName()) + "=" + t.getMessage()));
        }
        finally {
            if (indexIterator != null) {
                try {
                    metaDataDialect.close(indexIterator);
                }
                catch (JDBCException se) {
                    log.warn((Object)"Exception while trying to close resultset for index meta data", (Throwable)se);
                }
            }
        }
        for (Map.Entry entry : uniqueColumns.entrySet()) {
            Column col = (Column)entry.getKey();
            for (UniqueKey key : (List)entry.getValue()) {
                if (key.getColumnSpan() != 1) continue;
                col.setUnique(true);
            }
        }
        Iterator iterator = uniquekeys.entrySet().iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    private static String getCatalogForDBLookup(String catalog, String defaultCatalog) {
        return catalog == null ? defaultCatalog : catalog;
    }

    private static String getSchemaForDBLookup(String schema, String defaultSchema) {
        return schema == null ? defaultSchema : schema;
    }

    private static Column getColumn(MetaDataDialect metaDataDialect, Table table, String columnName) {
        Column column = new Column();
        column.setName(IndexProcessor.quote(columnName, metaDataDialect));
        Column existing = table.getColumn(column);
        if (existing != null) {
            column = existing;
        }
        return column;
    }

    private static String quote(String columnName, MetaDataDialect metaDataDialect) {
        if (columnName == null) {
            return columnName;
        }
        if (metaDataDialect.needQuote(columnName)) {
            if (columnName.length() > 1 && columnName.charAt(0) == '`' && columnName.charAt(columnName.length() - 1) == '`') {
                return columnName;
            }
            return "`" + columnName + "`";
        }
        return columnName;
    }
}

