/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.util.Locale;
import org.hibernate.models.spi.RenderingCollector;

public class RenderingCollectorImpl
implements RenderingCollector {
    private final StringBuilder buffer = new StringBuilder();
    private int currentIndentation = 0;

    @Override
    public void addLine(String line) {
        this.buffer.append(" ".repeat(this.currentIndentation));
        this.buffer.append(line);
        this.buffer.append("\n");
    }

    @Override
    public void addLine(String pattern, Object ... args) {
        this.buffer.append(" ".repeat(this.currentIndentation));
        this.buffer.append(String.format(Locale.ROOT, pattern, args));
        this.buffer.append("\n");
    }

    @Override
    public void addLine() {
        this.buffer.append("\n");
    }

    @Override
    public void indent(int depth) {
        this.currentIndentation += depth * 4;
    }

    @Override
    public void unindent(int depth) {
        this.currentIndentation -= depth * 4;
        assert (this.currentIndentation >= 0);
    }

    public String toString() {
        return this.buffer.toString();
    }
}

