/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.lang.annotation.Annotation;
import org.hibernate.models.ModelsException;
import org.hibernate.models.internal.ArrayTypeDescriptor;
import org.hibernate.models.internal.BooleanTypeDescriptor;
import org.hibernate.models.internal.ByteTypeDescriptor;
import org.hibernate.models.internal.CharacterTypeDescriptor;
import org.hibernate.models.internal.ClassTypeDescriptor;
import org.hibernate.models.internal.DoubleTypeDescriptor;
import org.hibernate.models.internal.EnumTypeDescriptor;
import org.hibernate.models.internal.FloatTypeDescriptor;
import org.hibernate.models.internal.IntegerTypeDescriptor;
import org.hibernate.models.internal.LongTypeDescriptor;
import org.hibernate.models.internal.NestedTypeDescriptor;
import org.hibernate.models.internal.ShortTypeDescriptor;
import org.hibernate.models.internal.StringTypeDescriptor;
import org.hibernate.models.spi.ValueTypeDescriptor;

public class TypeDescriptors {
    public static <T, W> ValueTypeDescriptor<W> resolveTypeDescriptor(Class<T> attributeType) {
        assert (attributeType != null);
        if (attributeType == Byte.TYPE) {
            return ByteTypeDescriptor.BYTE_TYPE_DESCRIPTOR;
        }
        if (attributeType == Boolean.TYPE) {
            return BooleanTypeDescriptor.BOOLEAN_TYPE_DESCRIPTOR;
        }
        if (attributeType == Short.TYPE) {
            return ShortTypeDescriptor.SHORT_TYPE_DESCRIPTOR;
        }
        if (attributeType == Integer.TYPE) {
            return IntegerTypeDescriptor.INTEGER_TYPE_DESCRIPTOR;
        }
        if (attributeType == Long.TYPE) {
            return LongTypeDescriptor.LONG_TYPE_DESCRIPTOR;
        }
        if (attributeType == Float.TYPE) {
            return FloatTypeDescriptor.FLOAT_TYPE_DESCRIPTOR;
        }
        if (attributeType == Double.TYPE) {
            return DoubleTypeDescriptor.DOUBLE_TYPE_DESCRIPTOR;
        }
        if (attributeType == Character.TYPE) {
            return CharacterTypeDescriptor.CHARACTER_TYPE_DESCRIPTOR;
        }
        if (attributeType == String.class) {
            return StringTypeDescriptor.STRING_TYPE_DESCRIPTOR;
        }
        if (attributeType == Class.class) {
            return ClassTypeDescriptor.CLASS_TYPE_DESCRIPTOR;
        }
        if (attributeType.isArray()) {
            Class<?> componentType = attributeType.getComponentType();
            ValueTypeDescriptor<W> elementTypeDescriptor = TypeDescriptors.resolveTypeDescriptor(componentType);
            return new ArrayTypeDescriptor<W>(elementTypeDescriptor);
        }
        if (attributeType.isEnum()) {
            return new EnumTypeDescriptor<T>(attributeType);
        }
        if (Annotation.class.isAssignableFrom(attributeType)) {
            return new NestedTypeDescriptor<T>(attributeType);
        }
        throw new ModelsException("Unsupported attribute value type - " + attributeType.getName());
    }
}

