/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.jandex;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.hibernate.models.ModelsException;
import org.hibernate.models.internal.util.StringHelper;
import org.hibernate.models.spi.ClassLoading;
import org.jboss.jandex.Indexer;

public class JandexIndexerHelper {
    public static void apply(Class<?> clazz, Indexer indexer, ClassLoading classLoading) {
        JandexIndexerHelper.apply(clazz.getName(), indexer, classLoading);
    }

    public static void apply(String className, Indexer indexer, ClassLoading classLoading) {
        String resourceName = StringHelper.classNameToResourceName(className);
        URL resource = classLoading.locateResource(resourceName);
        if (resource == null) {
            throw new JandexIndexingException(className);
        }
        try (InputStream inputStream = resource.openStream();){
            indexer.index(inputStream);
        }
        catch (IOException e) {
            throw new JandexIndexingException(e);
        }
    }

    public static class JandexIndexingException
    extends ModelsException {
        public JandexIndexingException(String className) {
            super("Could not locate classpath resource for " + className);
        }

        public JandexIndexingException(Throwable cause) {
            super("Error indexing standard types", cause);
        }
    }
}

