/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.jdk;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.models.internal.ArrayTypeDetailsImpl;
import org.hibernate.models.internal.ClassTypeDetailsImpl;
import org.hibernate.models.internal.ParameterizedTypeDetailsImpl;
import org.hibernate.models.internal.PrimitiveTypeDetailsImpl;
import org.hibernate.models.internal.TypeVariableDetailsImpl;
import org.hibernate.models.internal.VoidTypeDetailsImpl;
import org.hibernate.models.internal.WildcardTypeDetailsImpl;
import org.hibernate.models.internal.jdk.JdkBuilders;
import org.hibernate.models.internal.jdk.JdkTypeSwitch;
import org.hibernate.models.internal.jdk.JdkTypeSwitcher;
import org.hibernate.models.internal.util.CollectionHelper;
import org.hibernate.models.spi.ArrayTypeDetails;
import org.hibernate.models.spi.ClassBasedTypeDetails;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassTypeDetails;
import org.hibernate.models.spi.ParameterizedTypeDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeDetailsHelper;
import org.hibernate.models.spi.TypeVariableDetails;
import org.hibernate.models.spi.WildcardTypeDetails;

public class JdkTrackingTypeSwitch
implements JdkTypeSwitch<TypeDetails> {
    private final JdkTypeSwitcher switcher;
    private final SourceModelBuildingContext buildingContext;

    public JdkTrackingTypeSwitch(JdkTypeSwitcher switcher, SourceModelBuildingContext buildingContext) {
        this.switcher = switcher;
        this.buildingContext = buildingContext;
    }

    @Override
    public ClassBasedTypeDetails caseClass(Class<?> classType) {
        if (classType.isArray()) {
            return this.asArrayType(classType);
        }
        ClassDetails classDetails = this.buildingContext.getClassDetailsRegistry().resolveClassDetails(classType.getName());
        if (classType.isPrimitive()) {
            return new PrimitiveTypeDetailsImpl(classDetails);
        }
        if (JdkBuilders.isVoid(classDetails.toJavaClass())) {
            return new VoidTypeDetailsImpl(classDetails);
        }
        return new ClassTypeDetailsImpl(classDetails, TypeDetails.Kind.CLASS);
    }

    @Override
    public ParameterizedTypeDetails caseParameterizedType(ParameterizedType parameterizedType) {
        ClassDetails classDetails = this.buildingContext.getClassDetailsRegistry().resolveClassDetails(parameterizedType.getRawType().getTypeName());
        return new ParameterizedTypeDetailsImpl(classDetails, this.extractTypeParameters(parameterizedType), null);
    }

    @Override
    public WildcardTypeDetails caseWildcardType(WildcardType wildcardType) {
        Object[] lowerBounds = wildcardType.getLowerBounds();
        if (CollectionHelper.isEmpty(lowerBounds)) {
            int numberOfBounds = CollectionHelper.length(wildcardType.getUpperBounds());
            ClassTypeDetails upper = numberOfBounds == 1 ? this.switcher.switchType(wildcardType.getUpperBounds()[0]) : ClassBasedTypeDetails.OBJECT_TYPE_DETAILS;
            return new WildcardTypeDetailsImpl(upper, true);
        }
        int numberOfBounds = CollectionHelper.length(lowerBounds);
        ClassTypeDetails lower = numberOfBounds == 1 ? this.switcher.switchType((Type)lowerBounds[0]) : ClassBasedTypeDetails.OBJECT_TYPE_DETAILS;
        return new WildcardTypeDetailsImpl(lower, false);
    }

    @Override
    public TypeVariableDetails caseTypeVariable(TypeVariable<?> typeVariable) {
        ClassDetails declaringClass;
        Object genericDeclaration = typeVariable.getGenericDeclaration();
        if (genericDeclaration instanceof Class) {
            Class genericClass = (Class)genericDeclaration;
            declaringClass = this.buildingContext.getClassDetailsRegistry().getClassDetails(genericClass.getName());
        } else {
            declaringClass = this.buildingContext.getClassDetailsRegistry().getClassDetails(((Method)genericDeclaration).getDeclaringClass().getName());
        }
        return new TypeVariableDetailsImpl(typeVariable.getTypeName(), declaringClass, this.resolveTypes(typeVariable.getBounds()));
    }

    @Override
    public TypeDetails caseGenericArrayType(GenericArrayType genericArrayType) {
        TypeDetails componentType = this.switcher.switchType(genericArrayType.getGenericComponentType());
        return TypeDetailsHelper.arrayOf(componentType, this.buildingContext);
    }

    @Override
    public TypeDetails defaultCase(Type type) {
        throw new UnsupportedOperationException("Unexpected Type kind - " + type);
    }

    private ArrayTypeDetails asArrayType(Class<?> arrayClass) {
        assert (arrayClass.isArray());
        ClassDetails arrayClassDetails = this.buildingContext.getClassDetailsRegistry().resolveClassDetails(arrayClass.getName());
        return new ArrayTypeDetailsImpl(arrayClassDetails, this.switcher.switchType(arrayClass.getComponentType()));
    }

    public List<TypeDetails> extractTypeParameters(ParameterizedType parameterizedType) {
        return this.resolveTypes(parameterizedType.getActualTypeArguments());
    }

    public List<TypeDetails> resolveTypes(Type[] types) {
        if (CollectionHelper.isEmpty(types)) {
            return Collections.emptyList();
        }
        ArrayList<TypeDetails> result = CollectionHelper.arrayList(types.length);
        for (Type actualTypeArgument : types) {
            TypeDetails switchedType = this.switcher.switchType(actualTypeArgument);
            result.add(switchedType);
        }
        return result;
    }
}

