/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.spi;

import org.hibernate.models.IllegalCastException;
import org.hibernate.models.internal.AnnotationHelper;
import org.hibernate.models.internal.ModifierUtils;
import org.hibernate.models.internal.RenderingCollectorImpl;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.RecordComponentDetails;
import org.hibernate.models.spi.RenderingCollector;
import org.hibernate.models.spi.SourceModelBuildingContext;

public interface FieldDetails
extends MemberDetails {
    @Override
    default public AnnotationTarget.Kind getKind() {
        return AnnotationTarget.Kind.FIELD;
    }

    @Override
    default public String resolveAttributeName() {
        return this.getName();
    }

    @Override
    default public boolean isPersistable() {
        return ModifierUtils.hasPersistableFieldModifiers(this.getModifiers());
    }

    @Override
    default public FieldDetails asFieldDetails() {
        return this;
    }

    @Override
    default public MethodDetails asMethodDetails() {
        throw new IllegalCastException("FieldDetails cannot be cast to MethodDetails");
    }

    @Override
    default public RecordComponentDetails asRecordComponentDetails() {
        throw new IllegalCastException("FieldDetails cannot be cast to RecordComponentDetails");
    }

    @Override
    default public void render(SourceModelBuildingContext modelContext) {
        RenderingCollectorImpl renderingCollector = new RenderingCollectorImpl();
        this.render(renderingCollector, modelContext);
        renderingCollector.render();
    }

    @Override
    default public void render(RenderingCollector collector, SourceModelBuildingContext modelContext) {
        this.forEachDirectAnnotationUsage(usage -> AnnotationHelper.render(collector, usage, modelContext));
        collector.addLine("%s %s", this.getType().determineRawClass().getName(), this.getName());
    }
}

