/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.spi;

import java.beans.Introspector;
import java.util.List;
import org.hibernate.models.IllegalCastException;
import org.hibernate.models.internal.AnnotationHelper;
import org.hibernate.models.internal.ModifierUtils;
import org.hibernate.models.internal.RenderingCollectorImpl;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.RecordComponentDetails;
import org.hibernate.models.spi.RenderingCollector;
import org.hibernate.models.spi.SourceModelBuildingContext;

public interface MethodDetails
extends MemberDetails {
    public MethodKind getMethodKind();

    @Override
    default public AnnotationTarget.Kind getKind() {
        return AnnotationTarget.Kind.METHOD;
    }

    public ClassDetails getReturnType();

    public List<ClassDetails> getArgumentTypes();

    @Override
    default public boolean isPersistable() {
        return this.getMethodKind() == MethodKind.GETTER && ModifierUtils.hasPersistableMethodModifiers(this.getModifiers());
    }

    @Override
    default public String resolveAttributeName() {
        String methodName = this.getName();
        if (methodName.startsWith("is")) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        if (methodName.startsWith("get")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        return null;
    }

    @Override
    default public FieldDetails asFieldDetails() {
        throw new IllegalCastException("MethodDetails cannot be cast to FieldDetails");
    }

    @Override
    default public MethodDetails asMethodDetails() {
        return this;
    }

    @Override
    default public RecordComponentDetails asRecordComponentDetails() {
        throw new IllegalCastException("MethodDetails cannot be cast to RecordComponentDetails");
    }

    @Override
    default public void render(SourceModelBuildingContext modelContext) {
        RenderingCollectorImpl renderingCollector = new RenderingCollectorImpl();
        this.render(renderingCollector, modelContext);
        renderingCollector.render();
    }

    @Override
    default public void render(RenderingCollector collector, SourceModelBuildingContext modelContext) {
        this.forEachDirectAnnotationUsage(usage -> AnnotationHelper.render(collector, usage, modelContext));
        collector.addLine("%s %s (%s)", this.getType() == null ? "void" : this.getType().determineRawClass().getName(), this.getName(), this.getMethodKind().name());
        collector.indent(2);
        this.getArgumentTypes().forEach(arg -> collector.addLine(" - %s", arg.getName()));
        collector.unindent(2);
    }

    public static enum MethodKind {
        GETTER,
        SETTER,
        OTHER;

    }
}

