/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.FetchClauseType;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteMaterialization;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.predicate.LikePredicate;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.model.internal.TableInsertStandard;

public class PostgreSQLLegacySqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public PostgreSQLLegacySqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    protected void renderInsertIntoNoColumns(TableInsertStandard tableInsert) {
        this.renderIntoIntoAndTable(tableInsert);
        this.appendSql("default values");
    }

    protected void renderExpressionAsClauseItem(Expression expression) {
        expression.accept((SqlAstWalker)this);
    }

    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        JdbcMappingContainer lhsExpressionType = lhs.getExpressionType();
        if (lhsExpressionType != null && lhsExpressionType.getJdbcTypeCount() == 1 && lhsExpressionType.getSingleJdbcMapping().getJdbcType().getDdlTypeCode() == 2009) {
            switch (operator) {
                case EQUAL: 
                case NOT_DISTINCT_FROM: 
                case NOT_EQUAL: 
                case DISTINCT_FROM: {
                    this.appendSql("cast(");
                    lhs.accept((SqlAstWalker)this);
                    this.appendSql(" as text)");
                    this.appendSql(operator.sqlText());
                    this.appendSql("cast(");
                    rhs.accept((SqlAstWalker)this);
                    this.appendSql(" as text)");
                    return;
                }
            }
        }
        this.renderComparisonStandard(lhs, operator, rhs);
    }

    public void visitBooleanExpressionPredicate(BooleanExpressionPredicate booleanExpressionPredicate) {
        boolean isNegated = booleanExpressionPredicate.isNegated();
        if (isNegated) {
            this.appendSql("not(");
        }
        booleanExpressionPredicate.getExpression().accept((SqlAstWalker)this);
        if (isNegated) {
            this.appendSql(')');
        }
    }

    public void visitNullnessPredicate(NullnessPredicate nullnessPredicate) {
        Expression expression = nullnessPredicate.getExpression();
        JdbcMappingContainer expressionType = expression.getExpressionType();
        if (this.isStruct(expressionType)) {
            expression.accept((SqlAstWalker)this);
            if (nullnessPredicate.isNegated()) {
                this.appendSql(" is distinct from null");
            } else {
                this.appendSql(" is not distinct from null");
            }
        } else {
            super.visitNullnessPredicate(nullnessPredicate);
        }
    }

    protected void renderMaterializationHint(CteMaterialization materialization) {
        if (this.getDialect().getVersion().isSameOrAfter(12)) {
            if (materialization == CteMaterialization.NOT_MATERIALIZED) {
                this.appendSql("not ");
            }
            this.appendSql("materialized ");
        }
    }

    protected boolean supportsRowConstructor() {
        return true;
    }

    protected boolean supportsArrayConstructor() {
        return true;
    }

    public boolean supportsFilterClause() {
        return this.getDialect().getVersion().isSameOrAfter(9, 4);
    }

    protected String getForUpdate() {
        return this.getDialect().getVersion().isSameOrAfter(9, 3) ? " for no key update" : " for update";
    }

    protected String getForShare(int timeoutMillis) {
        return " for share";
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        if (this.getQueryPartForRowNumbering() == queryPart || this.isRowsOnlyFetchClauseType(queryPart)) {
            return false;
        }
        return !this.getDialect().supportsFetchClause(queryPart.getFetchClauseType());
    }

    public void visitQueryGroup(QueryGroup queryGroup) {
        if (this.shouldEmulateFetchClause((QueryPart)queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions((QueryPart)queryGroup, true);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    public void visitQuerySpec(QuerySpec querySpec) {
        if (this.shouldEmulateFetchClause((QueryPart)querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions((QueryPart)querySpec, true);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            if (this.getDialect().supportsFetchClause(FetchClauseType.ROWS_ONLY)) {
                this.renderOffsetFetchClause(queryPart, true);
            } else {
                this.renderLimitOffsetClause(queryPart);
            }
        }
    }

    protected boolean supportsRecursiveSearchClause() {
        return this.getDialect().getVersion().isSameOrAfter(14);
    }

    protected boolean supportsRecursiveCycleClause() {
        return this.getDialect().getVersion().isSameOrAfter(14);
    }

    protected boolean supportsRecursiveCycleUsingClause() {
        return this.getDialect().getVersion().isSameOrAfter(14);
    }

    protected void renderStandardCycleClause(CteStatement cte) {
        super.renderStandardCycleClause(cte);
        if (cte.getCycleMarkColumn() != null && cte.getCyclePathColumn() == null && this.supportsRecursiveCycleUsingClause()) {
            this.appendSql(" using ");
            this.appendSql(this.determineCyclePathColumnName(cte));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            if (this.getDialect().getVersion().isSameOrAfter(9, 5)) {
                this.appendSql("()");
                return;
            } else {
                this.appendSql("(select 1");
                this.appendSql(this.getFromDualForSelectOnly());
                this.appendSql(')');
            }
            return;
        } else if (expression instanceof Summarization) {
            Summarization summarization = (Summarization)expression;
            if (!this.getDialect().getVersion().isSameOrAfter(9, 5)) throw new UnsupportedOperationException("Summarization is not supported by DBMS");
            this.appendSql(summarization.getKind().sqlText());
            this.appendSql('(');
            this.renderCommaSeparated(summarization.getGroupings());
            this.appendSql(')');
            return;
        } else {
            expression.accept((SqlAstWalker)this);
        }
    }

    public void visitLikePredicate(LikePredicate likePredicate) {
        likePredicate.getMatchExpression().accept((SqlAstWalker)this);
        if (likePredicate.isNegated()) {
            this.appendSql(" not");
        }
        if (likePredicate.isCaseSensitive()) {
            this.appendSql(" like ");
        } else {
            this.appendSql(' ');
            this.appendSql(this.getDialect().getCaseInsensitiveLike());
            this.appendSql(' ');
        }
        likePredicate.getPattern().accept((SqlAstWalker)this);
        if (likePredicate.getEscapeCharacter() != null) {
            this.appendSql(" escape ");
            likePredicate.getEscapeCharacter().accept((SqlAstWalker)this);
        } else {
            this.appendSql(" escape ''");
        }
    }

    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
        this.appendSql('(');
        arithmeticExpression.getLeftHandOperand().accept((SqlAstWalker)this);
        this.appendSql(arithmeticExpression.getOperator().getOperatorSqlTextString());
        arithmeticExpression.getRightHandOperand().accept((SqlAstWalker)this);
        this.appendSql(')');
    }
}

