/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.util;

import java.beans.Introspector;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.tools.Diagnostic;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.processor.Context;
import org.hibernate.processor.MetaModelGenerationException;
import org.hibernate.processor.annotation.AnnotationMetaEntity;
import org.hibernate.processor.model.Metamodel;
import org.hibernate.processor.util.AccessType;
import org.hibernate.processor.util.AccessTypeInformation;
import org.hibernate.processor.util.BasicAttributeVisitor;
import org.hibernate.processor.util.NullnessUtil;
import org.hibernate.processor.util.StringUtil;
import org.hibernate.processor.util.TypeRenderingVisitor;

public final class TypeUtils {
    public static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_ANNOTATION_PARAMETER_NAME = "value";
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TypeKind, @UnknownKeyFor @NonNull @Initialized String> PRIMITIVE_WRAPPERS = new HashMap<TypeKind, String>();
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TypeKind, @UnknownKeyFor @NonNull @Initialized String> PRIMITIVES = new HashMap<TypeKind, String>();
    private static final @UnknownKeyFor @NonNull @Initialized String PROPERTY = AccessType.PROPERTY.toString();
    private static final @UnknownKeyFor @NonNull @Initialized String FIELD = AccessType.FIELD.toString();
    public static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> PRIMITIVE_TYPES;

    private TypeUtils() {
    }

    public static @UnknownKeyFor @NonNull @Initialized String toTypeString(@UnknownKeyFor @NonNull @Initialized TypeMirror type) {
        return type.getKind().isPrimitive() ? NullnessUtil.castNonNull(PRIMITIVE_WRAPPERS.get((Object)type.getKind())) : TypeRenderingVisitor.toString(type);
    }

    public static @UnknownKeyFor @NonNull @Initialized String toArrayTypeString(@UnknownKeyFor @NonNull @Initialized ArrayType type, @UnknownKeyFor @NonNull @Initialized Context context) {
        TypeMirror componentType = type.getComponentType();
        if (componentType.getKind().isPrimitive()) {
            return PRIMITIVES.get((Object)componentType.getKind()) + "[]";
        }
        TypeMirror component = componentType.accept(new SimpleTypeVisitor8<TypeMirror, Void>(){

            @Override
            protected TypeMirror defaultAction(TypeMirror e, Void aVoid) {
                return e;
            }
        }, null);
        return TypeUtils.extractClosestRealTypeAsString(component, context) + "[]";
    }

    public static @Nullable @UnknownKeyFor @Initialized TypeElement getSuperclassTypeElement(@UnknownKeyFor @NonNull @Initialized TypeElement element) {
        TypeMirror superClass = element.getSuperclass();
        if (superClass.getKind() == TypeKind.DECLARED) {
            Element superClassElement = ((DeclaredType)superClass).asElement();
            return (TypeElement)superClassElement;
        }
        return null;
    }

    public static @UnknownKeyFor @NonNull @Initialized String extractClosestRealTypeAsString(@UnknownKeyFor @NonNull @Initialized TypeMirror type, @UnknownKeyFor @NonNull @Initialized Context context) {
        TypeMirror mirror = TypeUtils.extractClosestRealType(type, context, new HashSet<TypeVariable>());
        return mirror == null ? "?" : mirror.toString();
    }

    private static @Nullable @UnknownKeyFor @Initialized TypeMirror lowerBound(@Nullable @UnknownKeyFor @Initialized TypeMirror bound) {
        return bound == null || bound.getKind() == TypeKind.NULL ? null : bound;
    }

    private static @Nullable @UnknownKeyFor @Initialized TypeMirror upperBound(@Nullable @UnknownKeyFor @Initialized TypeMirror bound) {
        if (bound != null && bound.getKind() == TypeKind.DECLARED) {
            DeclaredType type = (DeclaredType)bound;
            return type.asElement().getSimpleName().contentEquals("java.lang.Object") ? null : bound;
        }
        return null;
    }

    public static @Nullable @UnknownKeyFor @Initialized TypeMirror extractClosestRealType(@UnknownKeyFor @NonNull @Initialized TypeMirror type, final @UnknownKeyFor @NonNull @Initialized Context context, final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized TypeVariable> beingVisited) {
        if (type == null) {
            return null;
        }
        switch (type.getKind()) {
            case TYPEVAR: {
                TypeVariable typeVariable = (TypeVariable)type;
                if (!beingVisited.add(typeVariable)) {
                    return context.getTypeUtils().getWildcardType(null, null);
                }
                WildcardType wildcardType = context.getTypeUtils().getWildcardType(TypeUtils.upperBound(TypeUtils.extractClosestRealType(typeVariable.getUpperBound(), context, beingVisited)), TypeUtils.lowerBound(TypeUtils.extractClosestRealType(typeVariable.getLowerBound(), context, beingVisited)));
                beingVisited.remove(typeVariable);
                return wildcardType;
            }
            case WILDCARD: {
                WildcardType wildcardType = (WildcardType)type;
                return context.getTypeUtils().getWildcardType(TypeUtils.extractClosestRealType(wildcardType.getExtendsBound(), context, beingVisited), TypeUtils.extractClosestRealType(wildcardType.getSuperBound(), context, beingVisited));
            }
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)type;
                TypeElement typeElement = (TypeElement)declaredType.asElement();
                return context.getTypeUtils().getDeclaredType(typeElement, (TypeMirror[])declaredType.getTypeArguments().stream().map(new Function<TypeMirror, TypeMirror>(){

                    @Override
                    public @Nullable TypeMirror apply(TypeMirror arg) {
                        return TypeUtils.extractClosestRealType(arg, context, beingVisited);
                    }
                }).toArray(TypeMirror[]::new));
            }
        }
        return context.getTypeUtils().erasure(type);
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean containsAnnotation(@UnknownKeyFor @NonNull @Initialized Element element, String ... annotations) {
        assert (element != null);
        assert (annotations != null);
        Set<String> annotationClassNames = Set.of(annotations);
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationClassNames.contains(annotationMirror.getAnnotationType().toString())) continue;
            return true;
        }
        return false;
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isAnnotationMirrorOfType(@UnknownKeyFor @NonNull @Initialized AnnotationMirror annotationMirror, @UnknownKeyFor @NonNull @Initialized String qualifiedName) {
        assert (annotationMirror != null);
        assert (qualifiedName != null);
        Element element = annotationMirror.getAnnotationType().asElement();
        TypeElement typeElement = (TypeElement)element;
        return typeElement.getQualifiedName().contentEquals(qualifiedName);
    }

    public static @Nullable @UnknownKeyFor @Initialized AnnotationMirror getAnnotationMirror(@UnknownKeyFor @NonNull @Initialized Element element, @UnknownKeyFor @NonNull @Initialized String qualifiedName) {
        assert (element != null);
        assert (qualifiedName != null);
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!TypeUtils.isAnnotationMirrorOfType(annotationMirror, qualifiedName)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean hasAnnotation(@UnknownKeyFor @NonNull @Initialized Element element, @UnknownKeyFor @NonNull @Initialized String qualifiedName) {
        return TypeUtils.getAnnotationMirror(element, qualifiedName) != null;
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean hasAnnotation(@UnknownKeyFor @NonNull @Initialized Element element, String ... qualifiedNames) {
        for (String qualifiedName : qualifiedNames) {
            if (!TypeUtils.hasAnnotation(element, qualifiedName)) continue;
            return true;
        }
        return false;
    }

    public static @Nullable @UnknownKeyFor @Initialized AnnotationValue getAnnotationValue(@UnknownKeyFor @NonNull @Initialized AnnotationMirror annotationMirror, @UnknownKeyFor @NonNull @Initialized String member) {
        assert (annotationMirror != null);
        assert (member != null);
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().contentEquals(member)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void determineAccessTypeForHierarchy(@UnknownKeyFor @NonNull @Initialized TypeElement searchedElement, @UnknownKeyFor @NonNull @Initialized Context context) {
        String qualifiedName = searchedElement.getQualifiedName().toString();
        context.logMessage(Diagnostic.Kind.OTHER, "Determining access type for " + qualifiedName);
        AccessTypeInformation accessTypeInfo = context.getAccessTypeInfo(qualifiedName);
        if (accessTypeInfo != null && accessTypeInfo.isAccessTypeResolved()) {
            context.logMessage(Diagnostic.Kind.OTHER, "AccessType for " + searchedElement + " found in cache: " + accessTypeInfo);
        } else {
            AccessType forcedAccessType = TypeUtils.determineAnnotationSpecifiedAccessType(searchedElement);
            if (forcedAccessType != null) {
                context.logMessage(Diagnostic.Kind.OTHER, "Explicit access type on " + searchedElement + ":" + forcedAccessType);
                AccessTypeInformation newAccessTypeInfo = new AccessTypeInformation(qualifiedName, forcedAccessType, null);
                context.addAccessTypeInformation(qualifiedName, newAccessTypeInfo);
                TypeUtils.updateEmbeddableAccessType(searchedElement, context, forcedAccessType);
            } else {
                AccessType defaultAccessType = TypeUtils.getAccessTypeInCaseElementIsRoot(searchedElement, context);
                if (defaultAccessType != null) {
                    AccessTypeInformation newAccessTypeInfo = new AccessTypeInformation(qualifiedName, null, defaultAccessType);
                    context.addAccessTypeInformation(qualifiedName, newAccessTypeInfo);
                    TypeUtils.updateEmbeddableAccessType(searchedElement, context, defaultAccessType);
                    TypeUtils.setDefaultAccessTypeForMappedSuperclassesInHierarchy(searchedElement, defaultAccessType, context);
                } else {
                    AccessType newDefaultAccessType = TypeUtils.getDefaultAccessForHierarchy(searchedElement, context);
                    if (newDefaultAccessType == null) {
                        newDefaultAccessType = AccessType.PROPERTY;
                    }
                    AccessTypeInformation newAccessTypeInfo = new AccessTypeInformation(qualifiedName, null, newDefaultAccessType);
                    context.addAccessTypeInformation(qualifiedName, newAccessTypeInfo);
                    TypeUtils.updateEmbeddableAccessType(searchedElement, context, newDefaultAccessType);
                }
            }
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized TypeMirror getCollectionElementType(@UnknownKeyFor @NonNull @Initialized DeclaredType type, @UnknownKeyFor @NonNull @Initialized String returnTypeName, @Nullable @UnknownKeyFor @Initialized String explicitTargetEntityName, @UnknownKeyFor @NonNull @Initialized Context context) {
        if (explicitTargetEntityName != null) {
            return context.getElementUtils().getTypeElement(explicitTargetEntityName).asType();
        }
        List<? extends TypeMirror> typeArguments = type.getTypeArguments();
        if (typeArguments.isEmpty()) {
            throw new MetaModelGenerationException("Unable to determine collection type");
        }
        if ("java.util.Map".equals(returnTypeName)) {
            return typeArguments.get(1);
        }
        return typeArguments.get(0);
    }

    private static void updateEmbeddableAccessType(@UnknownKeyFor @NonNull @Initialized TypeElement element, @UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized AccessType defaultAccessType) {
        for (Element element2 : ElementFilter.fieldsIn(element.getEnclosedElements())) {
            TypeUtils.updateEmbeddableAccessTypeForMember(context, defaultAccessType, element2);
        }
        for (Element element3 : ElementFilter.methodsIn(element.getEnclosedElements())) {
            TypeUtils.updateEmbeddableAccessTypeForMember(context, defaultAccessType, element3);
        }
    }

    private static void updateEmbeddableAccessTypeForMember(@UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized AccessType defaultAccessType, @UnknownKeyFor @NonNull @Initialized Element member) {
        String embeddedClassName = member.asType().accept(new EmbeddedAttributeVisitor(context), member);
        if (embeddedClassName != null) {
            AccessTypeInformation accessTypeInfo = context.getAccessTypeInfo(embeddedClassName);
            if (accessTypeInfo == null) {
                AccessTypeInformation newAccessTypeInfo = new AccessTypeInformation(embeddedClassName, null, defaultAccessType);
                context.addAccessTypeInformation(embeddedClassName, newAccessTypeInfo);
            } else {
                accessTypeInfo.setDefaultAccessType(defaultAccessType);
            }
        }
    }

    private static @Nullable @UnknownKeyFor @Initialized AccessType getDefaultAccessForHierarchy(@UnknownKeyFor @NonNull @Initialized TypeElement element, @UnknownKeyFor @NonNull @Initialized Context context) {
        AccessType defaultAccessType = null;
        TypeElement superClass = element;
        do {
            if ((superClass = TypeUtils.getSuperclassTypeElement(superClass)) == null) continue;
            String qualifiedName = superClass.getQualifiedName().toString();
            AccessTypeInformation accessTypeInfo = context.getAccessTypeInfo(qualifiedName);
            if (accessTypeInfo != null && accessTypeInfo.getDefaultAccessType() != null) {
                return accessTypeInfo.getDefaultAccessType();
            }
            if (!TypeUtils.containsAnnotation(superClass, "jakarta.persistence.Entity", "jakarta.persistence.MappedSuperclass")) continue;
            defaultAccessType = TypeUtils.getAccessTypeInCaseElementIsRoot(superClass, context);
            if (defaultAccessType != null) {
                AccessTypeInformation newAccessTypeInfo = new AccessTypeInformation(qualifiedName, null, defaultAccessType);
                context.addAccessTypeInformation(qualifiedName, newAccessTypeInfo);
                TypeUtils.setDefaultAccessTypeForMappedSuperclassesInHierarchy(superClass, defaultAccessType, context);
                break;
            }
            defaultAccessType = TypeUtils.getDefaultAccessForHierarchy(superClass, context);
        } while (superClass != null);
        return defaultAccessType;
    }

    private static void setDefaultAccessTypeForMappedSuperclassesInHierarchy(@UnknownKeyFor @NonNull @Initialized TypeElement element, @UnknownKeyFor @NonNull @Initialized AccessType defaultAccessType, @UnknownKeyFor @NonNull @Initialized Context context) {
        TypeElement superClass = element;
        do {
            if ((superClass = TypeUtils.getSuperclassTypeElement(superClass)) == null) continue;
            String qualifiedName = superClass.getQualifiedName().toString();
            if (!TypeUtils.containsAnnotation(superClass, "jakarta.persistence.MappedSuperclass")) continue;
            AccessType forcedAccessType = TypeUtils.determineAnnotationSpecifiedAccessType(superClass);
            AccessTypeInformation accessTypeInfo = forcedAccessType != null ? new AccessTypeInformation(qualifiedName, null, forcedAccessType) : new AccessTypeInformation(qualifiedName, null, defaultAccessType);
            context.addAccessTypeInformation(qualifiedName, accessTypeInfo);
        } while (superClass != null);
    }

    private static @Nullable @UnknownKeyFor @Initialized AccessType getAccessTypeInCaseElementIsRoot(@UnknownKeyFor @NonNull @Initialized TypeElement searchedElement, @UnknownKeyFor @NonNull @Initialized Context context) {
        for (Element element : searchedElement.getEnclosedElements()) {
            for (AnnotationMirror annotationMirror : context.getElementUtils().getAllAnnotationMirrors(element)) {
                if (!TypeUtils.isIdAnnotation(annotationMirror)) continue;
                return TypeUtils.getAccessTypeOfIdAnnotation(element);
            }
        }
        return null;
    }

    private static @Nullable @UnknownKeyFor @Initialized AccessType getAccessTypeOfIdAnnotation(@UnknownKeyFor @NonNull @Initialized Element element) {
        ElementKind kind = element.getKind();
        if (kind == ElementKind.FIELD || kind == ElementKind.METHOD) {
            return kind == ElementKind.FIELD ? AccessType.FIELD : AccessType.PROPERTY;
        }
        return null;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isIdAnnotation(@UnknownKeyFor @NonNull @Initialized AnnotationMirror annotationMirror) {
        return TypeUtils.isAnnotationMirrorOfType(annotationMirror, "jakarta.persistence.Id") || TypeUtils.isAnnotationMirrorOfType(annotationMirror, "jakarta.persistence.EmbeddedId");
    }

    public static @Nullable @UnknownKeyFor @Initialized AccessType determineAnnotationSpecifiedAccessType(@UnknownKeyFor @NonNull @Initialized Element element) {
        AnnotationValue accessType;
        AnnotationMirror mirror = TypeUtils.getAnnotationMirror(element, "jakarta.persistence.Access");
        if (mirror != null && (accessType = TypeUtils.getAnnotationValue(mirror, DEFAULT_ANNOTATION_PARAMETER_NAME)) != null) {
            VariableElement enumValue = (VariableElement)accessType.getValue();
            Name enumValueName = enumValue.getSimpleName();
            if (enumValueName.contentEquals(PROPERTY)) {
                return AccessType.PROPERTY;
            }
            if (enumValueName.contentEquals(FIELD)) {
                return AccessType.FIELD;
            }
        }
        return null;
    }

    public static @UnknownKeyFor @NonNull @Initialized ElementKind getElementKindForAccessType(@UnknownKeyFor @NonNull @Initialized AccessType accessType) {
        return accessType == AccessType.FIELD ? ElementKind.FIELD : ElementKind.METHOD;
    }

    public static @UnknownKeyFor @NonNull @Initialized String getKeyType(@UnknownKeyFor @NonNull @Initialized DeclaredType type, @UnknownKeyFor @NonNull @Initialized Context context) {
        List<? extends TypeMirror> typeArguments = type.getTypeArguments();
        if (typeArguments.isEmpty()) {
            context.logMessage(Diagnostic.Kind.ERROR, "Unable to determine type argument for " + type);
            return "java.lang.Object";
        }
        return TypeUtils.extractClosestRealTypeAsString(typeArguments.get(0), context);
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isClassOrRecordType(@UnknownKeyFor @NonNull @Initialized Element element) {
        ElementKind kind = element.getKind();
        return kind.isClass() && kind != ElementKind.ENUM;
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean primitiveClassMatchesKind(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> itemType, @UnknownKeyFor @NonNull @Initialized TypeKind kind) {
        switch (kind) {
            case SHORT: {
                return itemType.equals(Short.class);
            }
            case INT: {
                return itemType.equals(Integer.class);
            }
            case LONG: {
                return itemType.equals(Long.class);
            }
            case BOOLEAN: {
                return itemType.equals(Boolean.class);
            }
            case FLOAT: {
                return itemType.equals(Float.class);
            }
            case DOUBLE: {
                return itemType.equals(Double.class);
            }
            case CHAR: {
                return itemType.equals(Character.class);
            }
            case BYTE: {
                return itemType.equals(Byte.class);
            }
        }
        return false;
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isPropertyGetter(@UnknownKeyFor @NonNull @Initialized ExecutableType executable, @UnknownKeyFor @NonNull @Initialized Element element) {
        return element.getKind() == ElementKind.METHOD && StringUtil.isProperty(element.getSimpleName().toString(), TypeUtils.toTypeString(executable.getReturnType()));
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isBasicAttribute(@UnknownKeyFor @NonNull @Initialized Element element, @UnknownKeyFor @NonNull @Initialized Element returnedElement, @UnknownKeyFor @NonNull @Initialized Context context) {
        return TypeUtils.hasAnnotation(element, "jakarta.persistence.Basic", "jakarta.persistence.OneToOne", "jakarta.persistence.ManyToOne", "jakarta.persistence.Embedded", "jakarta.persistence.EmbeddedId", "jakarta.persistence.Id") || TypeUtils.hasAnnotation(element, "org.hibernate.annotations.Type") || returnedElement.asType().accept(new BasicAttributeVisitor(context), returnedElement) != false;
    }

    public static @Nullable @UnknownKeyFor @Initialized String getFullyQualifiedClassNameOfTargetEntity(@UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized String member) {
        TypeMirror parameterType;
        AnnotationValue value = TypeUtils.getAnnotationValue(mirror, member);
        if (value != null && (parameterType = (TypeMirror)value.getValue()).getKind() != TypeKind.VOID) {
            return parameterType.toString();
        }
        return null;
    }

    public static @Nullable @UnknownKeyFor @Initialized String getTargetEntity(@UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized AnnotationMirror> annotations) {
        for (AnnotationMirror annotationMirror : annotations) {
            if (TypeUtils.isAnnotationMirrorOfType(annotationMirror, "jakarta.persistence.ElementCollection")) {
                return TypeUtils.getFullyQualifiedClassNameOfTargetEntity(annotationMirror, "targetClass");
            }
            if (TypeUtils.isAnnotationMirrorOfType(annotationMirror, "jakarta.persistence.OneToMany") || TypeUtils.isAnnotationMirrorOfType(annotationMirror, "jakarta.persistence.ManyToMany") || TypeUtils.isAnnotationMirrorOfType(annotationMirror, "jakarta.persistence.ManyToOne") || TypeUtils.isAnnotationMirrorOfType(annotationMirror, "jakarta.persistence.OneToOne")) {
                return TypeUtils.getFullyQualifiedClassNameOfTargetEntity(annotationMirror, "targetEntity");
            }
            if (!TypeUtils.isAnnotationMirrorOfType(annotationMirror, "org.hibernate.annotations.Target")) continue;
            return TypeUtils.getFullyQualifiedClassNameOfTargetEntity(annotationMirror, DEFAULT_ANNOTATION_PARAMETER_NAME);
        }
        return null;
    }

    public static @UnknownKeyFor @NonNull @Initialized String propertyName(@UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity parent, @UnknownKeyFor @NonNull @Initialized Element element) {
        Elements elementsUtil = parent.getContext().getElementUtils();
        if (element.getKind() == ElementKind.FIELD) {
            return element.getSimpleName().toString();
        }
        if (element.getKind() == ElementKind.METHOD) {
            String name = element.getSimpleName().toString();
            if (name.startsWith("get")) {
                return elementsUtil.getName(Introspector.decapitalize(name.substring(3))).toString();
            }
            if (name.startsWith("is")) {
                return elementsUtil.getName(Introspector.decapitalize(name.substring(2))).toString();
            }
            return elementsUtil.getName(Introspector.decapitalize(name)).toString();
        }
        return elementsUtil.getName(element.getSimpleName() + "/* " + element.getKind() + " */").toString();
    }

    public static @Nullable @UnknownKeyFor @Initialized String findMappedSuperClass(@UnknownKeyFor @NonNull @Initialized Metamodel entity, @UnknownKeyFor @NonNull @Initialized Context context) {
        Element element = entity.getElement();
        if (element instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)element;
            TypeMirror superClass = typeElement.getSuperclass();
            while (superClass.getKind() == TypeKind.DECLARED) {
                DeclaredType declaredType = (DeclaredType)superClass;
                TypeElement superClassElement = (TypeElement)declaredType.asElement();
                if (TypeUtils.extendsSuperMetaModel(superClassElement, entity.isMetaComplete(), context)) {
                    return superClassElement.getQualifiedName().toString();
                }
                superClass = superClassElement.getSuperclass();
            }
        }
        return null;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean extendsSuperMetaModel(@UnknownKeyFor @NonNull @Initialized Element superClassElement, @UnknownKeyFor @NonNull @Initialized boolean entityMetaComplete, @UnknownKeyFor @NonNull @Initialized Context context) {
        TypeElement typeElement = (TypeElement)superClassElement;
        String superClassName = typeElement.getQualifiedName().toString();
        return context.containsMetaEntity(superClassName) || context.containsMetaEmbeddable(superClassName) || !entityMetaComplete && TypeUtils.containsAnnotation(superClassElement, "jakarta.persistence.Entity", "jakarta.persistence.MappedSuperclass");
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isPrimitive(@UnknownKeyFor @NonNull @Initialized String paramType) {
        return PRIMITIVE_TYPES.contains(paramType);
    }

    static {
        PRIMITIVE_WRAPPERS.put(TypeKind.CHAR, "Character");
        PRIMITIVE_WRAPPERS.put(TypeKind.BYTE, "Byte");
        PRIMITIVE_WRAPPERS.put(TypeKind.SHORT, "Short");
        PRIMITIVE_WRAPPERS.put(TypeKind.INT, "Integer");
        PRIMITIVE_WRAPPERS.put(TypeKind.LONG, "Long");
        PRIMITIVE_WRAPPERS.put(TypeKind.BOOLEAN, "Boolean");
        PRIMITIVE_WRAPPERS.put(TypeKind.FLOAT, "Float");
        PRIMITIVE_WRAPPERS.put(TypeKind.DOUBLE, "Double");
        PRIMITIVES.put(TypeKind.CHAR, "char");
        PRIMITIVES.put(TypeKind.BYTE, "byte");
        PRIMITIVES.put(TypeKind.SHORT, "short");
        PRIMITIVES.put(TypeKind.INT, "int");
        PRIMITIVES.put(TypeKind.LONG, "long");
        PRIMITIVES.put(TypeKind.BOOLEAN, "boolean");
        PRIMITIVES.put(TypeKind.FLOAT, "float");
        PRIMITIVES.put(TypeKind.DOUBLE, "double");
        PRIMITIVE_TYPES = Set.of("boolean", "char", "long", "int", "short", "byte", "double", "float");
    }

    static class EmbeddedAttributeVisitor
    extends SimpleTypeVisitor8<String, Element> {
        private final @UnknownKeyFor @NonNull @Initialized Context context;

        EmbeddedAttributeVisitor(@UnknownKeyFor @NonNull @Initialized Context context) {
            this.context = context;
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized String visitDeclared(@UnknownKeyFor @NonNull @Initialized DeclaredType declaredType, @UnknownKeyFor @NonNull @Initialized Element element) {
            TypeElement returnedElement = (TypeElement)this.context.getTypeUtils().asElement(declaredType);
            return TypeUtils.containsAnnotation(returnedElement, "jakarta.persistence.Embeddable") ? returnedElement.getQualifiedName().toString() : null;
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized String visitExecutable(@UnknownKeyFor @NonNull @Initialized ExecutableType executable, @UnknownKeyFor @NonNull @Initialized Element element) {
            if (element.getKind().equals((Object)ElementKind.METHOD)) {
                String string = element.getSimpleName().toString();
                return StringUtil.isProperty(string, TypeUtils.toTypeString(executable.getReturnType())) ? executable.getReturnType().accept(this, element) : null;
            }
            return null;
        }
    }
}

