/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.oracle;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.spatial.CommonSpatialFunction;
import org.hibernate.spatial.FunctionKey;
import org.hibernate.spatial.KeyedSqmFunctionDescriptors;
import org.hibernate.spatial.dialect.oracle.OracleSpatialSQLMMFunction;
import org.hibernate.spatial.dialect.oracle.STRelateFunction;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeReference;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;

public class OracleSQLMMFunctionDescriptors
implements KeyedSqmFunctionDescriptors {
    private final Map<FunctionKey, SqmFunctionDescriptor> map = new HashMap<FunctionKey, SqmFunctionDescriptor>();
    private final BasicTypeRegistry typeRegistry;

    public OracleSQLMMFunctionDescriptors(FunctionContributions functionContributions) {
        this.typeRegistry = functionContributions.getTypeConfiguration().getBasicTypeRegistry();
        this.registerSQLMMFunctions();
    }

    private void registerSQLMMFunctions() {
        this.addSTFunction(CommonSpatialFunction.ST_ASTEXT, "GET_WKT", StandardBasicTypes.STRING);
        this.addSTFunction(CommonSpatialFunction.ST_GEOMETRYTYPE, StandardBasicTypes.STRING);
        this.addSTFunction(CommonSpatialFunction.ST_ASBINARY, "GET_WKB", StandardBasicTypes.BINARY);
        this.addSTFunction(CommonSpatialFunction.ST_DIMENSION, StandardBasicTypes.INTEGER);
        this.addSTFunction(CommonSpatialFunction.ST_ISEMPTY, StandardBasicTypes.BOOLEAN);
        this.addSTFunction(CommonSpatialFunction.ST_SRID, StandardBasicTypes.INTEGER);
        this.addSTFunction(CommonSpatialFunction.ST_ISSIMPLE, StandardBasicTypes.BOOLEAN);
        this.addSTFunction(CommonSpatialFunction.ST_OVERLAPS, "ST_OVERLAP", StandardBasicTypes.BOOLEAN);
        this.addSTFunction(CommonSpatialFunction.ST_INTERSECTS, StandardBasicTypes.BOOLEAN);
        this.addSTFunction(CommonSpatialFunction.ST_CONTAINS, StandardBasicTypes.BOOLEAN);
        this.addSTFunction(CommonSpatialFunction.ST_DISJOINT, StandardBasicTypes.BOOLEAN);
        this.addSTFunction(CommonSpatialFunction.ST_CROSSES, StandardBasicTypes.BOOLEAN);
        this.addSTFunction(CommonSpatialFunction.ST_CONTAINS, StandardBasicTypes.BOOLEAN);
        this.addSTFunction(CommonSpatialFunction.ST_TOUCHES, StandardBasicTypes.BOOLEAN);
        this.addSTFunction(CommonSpatialFunction.ST_WITHIN, StandardBasicTypes.BOOLEAN);
        this.addSTFunction(CommonSpatialFunction.ST_EQUALS, StandardBasicTypes.BOOLEAN);
        this.addSTFunction(CommonSpatialFunction.ST_DISTANCE, StandardBasicTypes.DOUBLE);
        this.addSTRelateFunction();
        this.addSTFunction(CommonSpatialFunction.ST_DIFFERENCE);
        this.addSTFunction(CommonSpatialFunction.ST_INTERSECTION);
        this.addSTFunction(CommonSpatialFunction.ST_SYMDIFFERENCE);
        this.addSTFunction(CommonSpatialFunction.ST_BUFFER);
        this.addSTFunction(CommonSpatialFunction.ST_UNION);
        this.addSTFunction(CommonSpatialFunction.ST_BOUNDARY);
        this.addSTFunction(CommonSpatialFunction.ST_CONVEXHULL);
        this.addSTFunction(CommonSpatialFunction.ST_ENVELOPE);
    }

    private <T> void addSTFunction(CommonSpatialFunction func, String stMethod, BasicTypeReference<T> tpe) {
        this.map.put(func.getKey(), (SqmFunctionDescriptor)new OracleSpatialSQLMMFunction(func.getKey().getName(), stMethod, func.getNumArgs(), StandardFunctionReturnTypeResolvers.invariant((BasicType)this.typeRegistry.resolve(tpe))));
    }

    private void addSTFunction(CommonSpatialFunction func, String stMethod) {
        this.map.put(func.getKey(), (SqmFunctionDescriptor)new OracleSpatialSQLMMFunction(func.getKey().getName(), stMethod, func.getNumArgs(), StandardFunctionReturnTypeResolvers.useFirstNonNull(), true));
    }

    private <T> void addSTFunction(CommonSpatialFunction func, BasicTypeReference<T> tpe) {
        this.addSTFunction(func, func.getKey().getName().toUpperCase(Locale.ROOT), tpe);
    }

    private void addSTFunction(CommonSpatialFunction func) {
        this.addSTFunction(func, func.getKey().getName().toUpperCase(Locale.ROOT));
    }

    private void addSTRelateFunction() {
        this.map.put(CommonSpatialFunction.ST_RELATE.getKey(), (SqmFunctionDescriptor)new STRelateFunction(this.typeRegistry));
    }

    @Override
    public Map<FunctionKey, SqmFunctionDescriptor> asMap() {
        return Collections.unmodifiableMap(this.map);
    }
}

