/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.jta;

import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.hibernate.engine.jdbc.connections.internal.ConnectionProviderInitiator;
import org.hibernate.engine.jdbc.connections.internal.DriverManagerConnectionProviderImpl;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.internal.build.AllowSysOut;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Stoppable;
import org.hibernate.testing.jta.TestingJtaPlatformImpl;

public class JtaAwareConnectionProviderImpl
implements ConnectionProvider,
Configurable,
Stoppable {
    private static final String CONNECTION_KEY = "_database_connection";
    private DriverManagerConnectionProviderImpl delegate;
    private final List<Connection> nonEnlistedConnections = new ArrayList<Connection>();

    public void configure(Map<String, Object> configurationValues) {
        HashMap<String, Object> connectionSettings = new HashMap<String, Object>();
        JtaAwareConnectionProviderImpl.transferSetting("hibernate.connection.driver_class", configurationValues, connectionSettings);
        JtaAwareConnectionProviderImpl.transferSetting("hibernate.connection.url", configurationValues, connectionSettings);
        JtaAwareConnectionProviderImpl.transferSetting("hibernate.connection.username", configurationValues, connectionSettings);
        JtaAwareConnectionProviderImpl.transferSetting("hibernate.connection.password", configurationValues, connectionSettings);
        JtaAwareConnectionProviderImpl.transferSetting("hibernate.connection.isolation", configurationValues, connectionSettings);
        Properties passThroughSettings = ConnectionProviderInitiator.getConnectionProperties(configurationValues);
        for (String setting : passThroughSettings.stringPropertyNames()) {
            JtaAwareConnectionProviderImpl.transferSetting("hibernate.connection." + setting, configurationValues, connectionSettings);
        }
        connectionSettings.put("hibernate.connection.autocommit", "false");
        this.delegate = new DriverManagerConnectionProviderImpl();
        this.delegate.configure(connectionSettings);
    }

    private static void transferSetting(String settingName, Map<String, Object> source, Map<String, Object> target) {
        Object value = source.get(settingName);
        if (value != null) {
            target.put(settingName, value);
        }
    }

    public void stop() {
        this.delegate.stop();
    }

    public Connection getConnection() throws SQLException {
        Transaction currentTransaction = this.findCurrentTransaction();
        try {
            if (currentTransaction == null) {
                Connection connection = this.delegate.getConnection();
                this.nonEnlistedConnections.add(connection);
                return connection;
            }
            Connection connection = (Connection)TestingJtaPlatformImpl.synchronizationRegistry().getResource((Object)CONNECTION_KEY);
            if (connection == null) {
                connection = this.delegate.getConnection();
                TestingJtaPlatformImpl.synchronizationRegistry().putResource((Object)CONNECTION_KEY, (Object)connection);
                try {
                    XAResourceWrapper xaResourceWrapper = new XAResourceWrapper(this, connection);
                    currentTransaction.enlistResource((XAResource)xaResourceWrapper);
                }
                catch (Exception e) {
                    this.delist(connection);
                    throw e;
                }
            }
            return connection;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    public void closeConnection(Connection conn) throws SQLException {
        if (conn == null) {
            return;
        }
        if (this.nonEnlistedConnections.contains(conn)) {
            this.nonEnlistedConnections.remove(conn);
            this.delegate.closeConnection(conn);
        }
    }

    public boolean supportsAggressiveRelease() {
        return true;
    }

    protected Transaction findCurrentTransaction() {
        try {
            return TestingJtaPlatformImpl.transactionManager().getTransaction();
        }
        catch (SystemException e) {
            throw new IllegalStateException("Could not locate current transaction");
        }
    }

    public boolean isUnwrappableAs(Class<?> unwrapType) {
        return this.delegate.isUnwrappableAs(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        return (T)this.delegate.unwrap(unwrapType);
    }

    @AllowSysOut
    private void delist(Connection connection) {
        try {
            TestingJtaPlatformImpl.synchronizationRegistry().putResource((Object)CONNECTION_KEY, null);
        }
        catch (Exception e) {
            System.err.println("!!!Error trying to reset synchronization registry!!!");
        }
        try {
            this.delegate.closeConnection(connection);
        }
        catch (SQLException e) {
            System.err.println("!!!Error trying to close JDBC connection from delist callbacks!!!");
        }
    }

    public static class XAResourceWrapper
    implements XAResource {
        private final JtaAwareConnectionProviderImpl pool;
        private final Connection connection;
        private int transactionTimeout;

        public XAResourceWrapper(JtaAwareConnectionProviderImpl pool, Connection connection) {
            this.pool = pool;
            this.connection = connection;
        }

        @Override
        public int prepare(Xid xid) throws XAException {
            throw new RuntimeException("this should never be called");
        }

        @Override
        public void commit(Xid xid, boolean onePhase) throws XAException {
            if (!onePhase) {
                throw new IllegalArgumentException("must be one phase");
            }
            try {
                this.connection.commit();
            }
            catch (SQLException e) {
                throw new XAException(e.toString());
            }
            finally {
                try {
                    this.pool.delist(this.connection);
                }
                catch (Exception exception) {}
            }
        }

        @Override
        public void rollback(Xid xid) throws XAException {
            try {
                this.connection.rollback();
            }
            catch (SQLException e) {
                throw new XAException(e.toString());
            }
            finally {
                try {
                    this.pool.delist(this.connection);
                }
                catch (Exception exception) {}
            }
        }

        @Override
        public void end(Xid xid, int i) throws XAException {
        }

        @Override
        public void start(Xid xid, int i) throws XAException {
        }

        @Override
        public void forget(Xid xid) throws XAException {
        }

        @Override
        public int getTransactionTimeout() {
            return this.transactionTimeout;
        }

        @Override
        public boolean setTransactionTimeout(int i) {
            this.transactionTimeout = i;
            return true;
        }

        @Override
        public boolean isSameRM(XAResource xaResource) {
            return xaResource == this;
        }

        @Override
        public Xid[] recover(int i) {
            return new Xid[0];
        }
    }
}

