/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.domain.contacts;

import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.SecondaryTable;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.time.LocalDate;
import java.util.List;
import org.hibernate.testing.orm.domain.contacts.Address;
import org.hibernate.testing.orm.domain.contacts.PhoneNumber;

@Entity
@Table(name="contacts")
@SecondaryTable(name="contact_supp")
public class Contact {
    private Integer id;
    private Name name;
    private Gender gender;
    private LocalDate birthDay;
    private Contact alternativeContact;
    private List<Address> addresses;
    private List<PhoneNumber> phoneNumbers;

    public Contact() {
    }

    public Contact(Integer id, Name name, Gender gender, LocalDate birthDay) {
        this.id = id;
        this.name = name;
        this.gender = gender;
        this.birthDay = birthDay;
    }

    @Id
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Name getName() {
        return this.name;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(table="contact_supp")
    public LocalDate getBirthDay() {
        return this.birthDay;
    }

    public void setBirthDay(LocalDate birthDay) {
        this.birthDay = birthDay;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    public Contact getAlternativeContact() {
        return this.alternativeContact;
    }

    public void setAlternativeContact(Contact alternativeContact) {
        this.alternativeContact = alternativeContact;
    }

    @ElementCollection
    @CollectionTable(name="contact_addresses")
    @OrderColumn
    public List<Address> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<Address> addresses) {
        this.addresses = addresses;
    }

    @ElementCollection
    @CollectionTable(name="contact_phones")
    public List<PhoneNumber> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public void setPhoneNumbers(List<PhoneNumber> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    public static enum Gender {
        MALE,
        FEMALE,
        OTHER;

    }

    @Embeddable
    public static class Name {
        private String first;
        private String last;

        public Name() {
        }

        public Name(String first, String last) {
            this.first = first;
            this.last = last;
        }

        @Column(name="firstname")
        public String getFirst() {
            return this.first;
        }

        public void setFirst(String first) {
            this.first = first;
        }

        @Column(name="lastname")
        public String getLast() {
            return this.last;
        }

        public void setLast(String last) {
            this.last = last;
        }
    }
}

