/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.util.uuid;

import java.util.UUID;

public class SafeRandomUUIDGenerator {
    public static UUID safeRandomUUID() {
        UUID uuid = UUID.randomUUID();
        if (!SafeRandomUUIDGenerator.isSafeUUID(uuid)) {
            uuid = SafeRandomUUIDGenerator.safeRandomUUID();
        }
        return uuid;
    }

    public static String safeRandomUUIDAsString() {
        return SafeRandomUUIDGenerator.safeRandomUUID().toString();
    }

    public static boolean isSafeUUID(UUID uuid) {
        if (uuid == null) {
            throw new RuntimeException("The UUID cannot be tested if it's null!");
        }
        return (uuid.getLeastSignificantBits() & 0xFFL) != 0L;
    }
}

