/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.query.impl;

import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.IndexReaderMetadataResolver;

public final class MappedTypeNameQuery
extends Query {
    private final IndexReaderMetadataResolver metadataResolver;
    private final String mappedTypeName;

    public MappedTypeNameQuery(IndexReaderMetadataResolver metadataResolver, String mappedTypeName) {
        this.metadataResolver = metadataResolver;
        this.mappedTypeName = mappedTypeName;
    }

    public String toString(String field) {
        return ((Object)((Object)this)).getClass().getName() + "{" + this.mappedTypeName + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        MappedTypeNameQuery other = (MappedTypeNameQuery)((Object)obj);
        return this.mappedTypeName.equals(other.mappedTypeName);
    }

    public int hashCode() {
        return this.mappedTypeName.hashCode();
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) {
        return new ConstantScoreWeight(this, 1.0f){

            public Scorer scorer(LeafReaderContext context) {
                String leafMappedTypeName = MappedTypeNameQuery.this.metadataResolver.resolveMappedTypeName(context);
                DocIdSetIterator matchingDocs = MappedTypeNameQuery.this.mappedTypeName.equals(leafMappedTypeName) ? DocIdSetIterator.all((int)context.reader().maxDoc()) : DocIdSetIterator.empty();
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, matchingDocs);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }
        };
    }
}

