/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchFieldContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchIndexesContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchObjectFieldContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchObjectFieldQueryElementFactory;
import org.hibernate.search.backend.lucene.search.impl.SearchQueryElementTypeKey;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneMultiIndexSearchObjectFieldContext
implements LuceneSearchObjectFieldContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneSearchIndexesContext indexesContext;
    private final String absolutePath;
    private final List<LuceneSearchObjectFieldContext> fieldForEachIndex;
    private Map<String, LuceneSearchFieldContext> staticChildrenByName;

    public LuceneMultiIndexSearchObjectFieldContext(LuceneSearchIndexesContext indexesContext, String absolutePath, List<LuceneSearchObjectFieldContext> fieldForEachIndex) {
        this.indexesContext = indexesContext;
        this.absolutePath = absolutePath;
        this.fieldForEachIndex = fieldForEachIndex;
    }

    @Override
    public boolean isObjectField() {
        return true;
    }

    @Override
    public LuceneSearchObjectFieldContext toObjectField() {
        return this;
    }

    @Override
    public String absolutePath() {
        return this.absolutePath;
    }

    @Override
    public List<String> nestedPathHierarchy() {
        return this.getFromFieldIfCompatible(LuceneSearchFieldContext::nestedPathHierarchy, Object::equals, "nestedPathHierarchy");
    }

    public EventContext eventContext() {
        return this.indexesEventContext().append(EventContexts.fromIndexFieldAbsolutePath((String)this.absolutePath));
    }

    private EventContext indexesEventContext() {
        return EventContexts.fromIndexNames(this.indexesContext.indexNames());
    }

    @Override
    public <T> T queryElement(SearchQueryElementTypeKey<T> key, LuceneSearchContext searchContext) {
        LuceneSearchObjectFieldQueryElementFactory<T> factory = this.queryElementFactory(key);
        if (factory == null) {
            throw log.cannotUseQueryElementForObjectField(this.absolutePath(), key.toString(), this.eventContext());
        }
        try {
            return factory.create(searchContext, this);
        }
        catch (SearchException e) {
            throw log.cannotUseQueryElementForObjectFieldBecauseCreationException(this.absolutePath, key.toString(), e.getMessage(), e, this.indexesEventContext());
        }
    }

    @Override
    public Map<String, ? extends LuceneSearchFieldContext> staticChildrenByName() {
        if (this.staticChildrenByName != null) {
            return this.staticChildrenByName;
        }
        this.getFromFieldIfCompatible(field -> field.staticChildrenByName().keySet(), Object::equals, "staticChildren");
        TreeMap<String, LuceneSearchFieldContext> result = new TreeMap<String, LuceneSearchFieldContext>();
        Function<String, LuceneSearchFieldContext> createChildFieldContext = this.indexesContext::field;
        for (LuceneSearchObjectFieldContext fieldContext : this.fieldForEachIndex) {
            for (LuceneSearchFieldContext luceneSearchFieldContext : fieldContext.staticChildrenByName().values()) {
                try {
                    result.computeIfAbsent(luceneSearchFieldContext.absolutePath(), createChildFieldContext);
                }
                catch (SearchException e) {
                    throw log.inconsistentConfigurationForFieldForSearch(this.absolutePath, e.getMessage(), this.indexesEventContext(), e);
                }
            }
        }
        this.staticChildrenByName = result;
        return this.staticChildrenByName;
    }

    @Override
    public boolean nested() {
        return this.getFromFieldIfCompatible(LuceneSearchObjectFieldContext::nested, Object::equals, "nested");
    }

    @Override
    public <T> LuceneSearchObjectFieldQueryElementFactory<T> queryElementFactory(SearchQueryElementTypeKey<T> key) {
        LuceneSearchObjectFieldQueryElementFactory<T> factory = null;
        for (LuceneSearchObjectFieldContext fieldContext : this.fieldForEachIndex) {
            LuceneSearchObjectFieldQueryElementFactory<T> factoryForFieldContext = fieldContext.queryElementFactory(key);
            if (factory == null) {
                factory = factoryForFieldContext;
                continue;
            }
            this.checkFactoryCompatibility(key, factory, factoryForFieldContext);
        }
        return factory;
    }

    private <T> T getFromFieldIfCompatible(Function<LuceneSearchObjectFieldContext, T> getter, BiPredicate<T, T> compatiblityChecker, String attributeName) {
        T attribute = null;
        for (LuceneSearchObjectFieldContext fieldContext : this.fieldForEachIndex) {
            T attributeForFieldContext = getter.apply(fieldContext);
            if (attribute == null) {
                attribute = attributeForFieldContext;
                continue;
            }
            this.checkAttributeCompatibility(compatiblityChecker, attributeName, attribute, attributeForFieldContext);
        }
        return attribute;
    }

    private <T> void checkFactoryCompatibility(SearchQueryElementTypeKey<T> key, LuceneSearchObjectFieldQueryElementFactory<T> factory1, LuceneSearchObjectFieldQueryElementFactory<T> factory2) {
        if (factory1 == null && factory2 == null) {
            return;
        }
        try {
            try {
                if (factory1 == null || factory2 == null) {
                    throw log.partialSupportForQueryElement(key.toString());
                }
                factory1.checkCompatibleWith(factory2);
            }
            catch (SearchException e) {
                throw log.inconsistentSupportForQueryElement(key.toString(), e.getMessage(), e);
            }
        }
        catch (SearchException e) {
            throw log.inconsistentConfigurationForFieldForSearch(this.absolutePath, e.getMessage(), this.indexesEventContext(), e);
        }
    }

    private <T> void checkAttributeCompatibility(BiPredicate<T, T> compatiblityChecker, String attributeName, T attribute1, T attribute2) {
        try {
            if (!compatiblityChecker.test(attribute1, attribute2)) {
                throw log.differentFieldAttribute(attributeName, attribute1, attribute2);
            }
        }
        catch (SearchException e) {
            throw log.inconsistentConfigurationForFieldForSearch(this.absolutePath, e.getMessage(), this.indexesEventContext(), e);
        }
    }
}

