/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.codec.impl;

import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.FilterCodec;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.lucene95.Lucene95Codec;
import org.apache.lucene.codecs.perfield.PerFieldKnnVectorsFormat;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexField;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.lowlevel.codec.impl.HibernateSearchKnnVectorsFormat;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneVectorFieldCodec;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexValueFieldType;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldFilter;

public class HibernateSearchLuceneCodec
extends FilterCodec {
    public static final Codec DEFAULT_CODEC = new Lucene95Codec();
    private final KnnVectorsFormat knnVectorsFormat;

    public HibernateSearchLuceneCodec(LuceneIndexModel model) {
        this((KnnVectorsFormat)new IndexModelBasedPerFieldKnnVectorsFormat(model));
    }

    public HibernateSearchLuceneCodec(KnnVectorsFormat knnVectorsFormat) {
        super(DEFAULT_CODEC.getName(), DEFAULT_CODEC);
        this.knnVectorsFormat = knnVectorsFormat;
    }

    public KnnVectorsFormat knnVectorsFormat() {
        return this.knnVectorsFormat;
    }

    private static class IndexModelBasedPerFieldKnnVectorsFormat
    extends PerFieldKnnVectorsFormat {
        private final LuceneIndexModel model;

        private IndexModelBasedPerFieldKnnVectorsFormat(LuceneIndexModel model) {
            this.model = model;
        }

        public KnnVectorsFormat getKnnVectorsFormatForField(String fieldName) {
            KnnVectorsFormat knnVectorsFormat;
            LuceneFieldCodec codec;
            LuceneIndexField field = (LuceneIndexField)this.model.fieldOrNull(fieldName, IndexFieldFilter.ALL);
            if (field != null && (codec = ((LuceneIndexValueFieldType)field.toValueField().type()).codec()) instanceof LuceneVectorFieldCodec && (knnVectorsFormat = ((LuceneVectorFieldCodec)codec).knnVectorFormat()) != null) {
                return knnVectorsFormat;
            }
            return HibernateSearchKnnVectorsFormat.defaultFormat();
        }
    }
}

