/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.impl;

import java.util.ArrayList;
import java.util.Set;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntry;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.MetadataFields;
import org.hibernate.search.backend.lucene.lowlevel.query.impl.Queries;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.work.impl.AddEntryWork;
import org.hibernate.search.backend.lucene.work.impl.ComputeSizeInBytesWork;
import org.hibernate.search.backend.lucene.work.impl.CountWork;
import org.hibernate.search.backend.lucene.work.impl.CreateIndexIfMissingWork;
import org.hibernate.search.backend.lucene.work.impl.DeleteEntriesByQueryWork;
import org.hibernate.search.backend.lucene.work.impl.DeleteEntryWork;
import org.hibernate.search.backend.lucene.work.impl.DropIndexIfExistingWork;
import org.hibernate.search.backend.lucene.work.impl.ExplainWork;
import org.hibernate.search.backend.lucene.work.impl.FlushWork;
import org.hibernate.search.backend.lucene.work.impl.IndexManagementWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneSearcher;
import org.hibernate.search.backend.lucene.work.impl.MergeSegmentsWork;
import org.hibernate.search.backend.lucene.work.impl.ReadWork;
import org.hibernate.search.backend.lucene.work.impl.RefreshWork;
import org.hibernate.search.backend.lucene.work.impl.ScrollWork;
import org.hibernate.search.backend.lucene.work.impl.SearchWork;
import org.hibernate.search.backend.lucene.work.impl.SingleDocumentIndexingWork;
import org.hibernate.search.backend.lucene.work.impl.UpdateEntryWork;
import org.hibernate.search.backend.lucene.work.impl.ValidateIndexExistsWork;

public final class LuceneWorkFactory {
    private final MultiTenancyStrategy multiTenancyStrategy;

    public LuceneWorkFactory(MultiTenancyStrategy multiTenancyStrategy) {
        this.multiTenancyStrategy = multiTenancyStrategy;
    }

    public IndexManagementWork<Void> createIndexIfMissing() {
        return new CreateIndexIfMissingWork();
    }

    public IndexManagementWork<Void> dropIndexIfExisting() {
        return new DropIndexIfExistingWork();
    }

    public IndexManagementWork<Void> validateIndexExists() {
        return new ValidateIndexExistsWork();
    }

    public IndexManagementWork<?> flush() {
        return new FlushWork();
    }

    public IndexManagementWork<?> refresh() {
        return new RefreshWork();
    }

    public IndexManagementWork<?> mergeSegments() {
        return new MergeSegmentsWork();
    }

    public IndexManagementWork<Long> computeSizeInBytes() {
        return new ComputeSizeInBytesWork();
    }

    public SingleDocumentIndexingWork add(String tenantId, String entityTypeName, Object entityIdentifier, String documentIdentifier, LuceneIndexEntry indexEntry) {
        return new AddEntryWork(tenantId, entityTypeName, entityIdentifier, documentIdentifier, indexEntry);
    }

    public SingleDocumentIndexingWork update(String tenantId, String entityTypeName, Object entityIdentifier, String documentIdentifier, LuceneIndexEntry indexEntry) {
        Query filter = this.multiTenancyStrategy.filterOrNull(tenantId);
        return new UpdateEntryWork(tenantId, entityTypeName, entityIdentifier, documentIdentifier, filter, indexEntry);
    }

    public SingleDocumentIndexingWork delete(String tenantId, String entityTypeName, Object entityIdentifier, String documentIdentifier) {
        Query filter = this.multiTenancyStrategy.filterOrNull(tenantId);
        return new DeleteEntryWork(tenantId, entityTypeName, entityIdentifier, documentIdentifier, filter);
    }

    public IndexManagementWork<?> deleteAll(Set<String> tenantIds, Set<String> routingKeys) {
        ArrayList<Query> filters = new ArrayList<Query>();
        Query filter = this.multiTenancyStrategy.filterOrNull(tenantIds);
        if (filter != null) {
            filters.add(filter);
        }
        if (!routingKeys.isEmpty()) {
            filters.add(Queries.anyTerm(MetadataFields.routingKeyFieldName(), routingKeys));
        }
        return new DeleteEntriesByQueryWork(Queries.boolFilter((Query)new MatchAllDocsQuery(), filters));
    }

    public <R> ReadWork<R> search(LuceneSearcher<R, ?> searcher, Integer offset, Integer limit, int totalHitCountThreshold) {
        return new SearchWork<R>(searcher, offset, limit, totalHitCountThreshold);
    }

    public <ER> ReadWork<ER> scroll(LuceneSearcher<?, ER> searcher, int offset, int limit, int totalHitCountThreshold) {
        return new ScrollWork<ER>(searcher, offset, limit, totalHitCountThreshold);
    }

    public ReadWork<Integer> count(LuceneSearcher<?, ?> searcher) {
        return new CountWork(searcher);
    }

    public ReadWork<Explanation> explain(LuceneSearcher<?, ?> searcher, String explainedDocumentTypeName, String explainedDocumentId, Query explainedDocumentFilter) {
        return new ExplainWork(searcher, explainedDocumentTypeName, explainedDocumentId, explainedDocumentFilter);
    }
}

