/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.docvalues.impl;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LongValues;
import org.apache.lucene.search.LongValuesSource;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.DocValuesUtils;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.MultiValueMode;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.ChildDocIds;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.NestedDocsProvider;

public abstract class LongMultiValuesToSingleValuesSource
extends LongValuesSource {
    protected final MultiValueMode mode;
    protected final NestedDocsProvider nestedDocsProvider;

    public static LongMultiValuesToSingleValuesSource fromLongField(String field, MultiValueMode mode, NestedDocsProvider nested) {
        return LongMultiValuesToSingleValuesSource.fromField(field, mode, nested);
    }

    public static LongMultiValuesToSingleValuesSource fromIntField(String field, MultiValueMode mode, NestedDocsProvider nested) {
        return LongMultiValuesToSingleValuesSource.fromLongField(field, mode, nested);
    }

    private static LongMultiValuesToSingleValuesSource fromField(String field, MultiValueMode mode, NestedDocsProvider nested) {
        return new MultiFieldValuesToSingleValuesSource(field, mode, nested);
    }

    public LongMultiValuesToSingleValuesSource(MultiValueMode mode, NestedDocsProvider nestedDocsProvider) {
        this.mode = mode;
        this.nestedDocsProvider = nestedDocsProvider;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LongMultiValuesToSingleValuesSource that = (LongMultiValuesToSingleValuesSource)((Object)o);
        return Objects.equals((Object)this.mode, (Object)that.mode) && Objects.equals(this.nestedDocsProvider, that.nestedDocsProvider);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mode, this.nestedDocsProvider});
    }

    public LongValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
        SortedNumericDocValues values = this.getSortedNumericDocValues(ctx);
        if (this.nestedDocsProvider == null) {
            return this.select(values);
        }
        return this.select(values, this.nestedDocsProvider.childDocs(ctx, (DocIdSetIterator)values));
    }

    public NumericDocValues getRawNumericDocValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
        return new RawNumericDocValues(this.getValues(ctx, scores));
    }

    protected abstract SortedNumericDocValues getSortedNumericDocValues(LeafReaderContext var1) throws IOException;

    protected LongValues select(final SortedNumericDocValues values) {
        final NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)values);
        if (singleton != null) {
            return new LongValues(){

                public long longValue() throws IOException {
                    return singleton.longValue();
                }

                public boolean advanceExact(int target) throws IOException {
                    return singleton.advanceExact(target);
                }
            };
        }
        return new LongValues(){
            private long value;

            public long longValue() {
                return this.value;
            }

            public boolean advanceExact(int doc) throws IOException {
                if (values.advanceExact(doc)) {
                    this.value = LongMultiValuesToSingleValuesSource.this.mode.pick(values);
                    return true;
                }
                return false;
            }
        };
    }

    protected LongValues select(final SortedNumericDocValues values, final ChildDocIds childDocsWithValues) {
        if (childDocsWithValues == null) {
            return DocValuesUtils.LONG_VALUES_EMPTY;
        }
        return new LongValues(){
            int lastSeenParentDoc = -1;
            long lastEmittedValue = -1L;

            public long longValue() {
                return this.lastEmittedValue;
            }

            public boolean advanceExact(int parentDoc) throws IOException {
                assert (parentDoc >= this.lastSeenParentDoc) : "can only evaluate current and upcoming parent docs";
                if (parentDoc == this.lastSeenParentDoc) {
                    return true;
                }
                if (!childDocsWithValues.advanceExactParent(parentDoc)) {
                    return false;
                }
                this.lastSeenParentDoc = parentDoc;
                this.lastEmittedValue = LongMultiValuesToSingleValuesSource.this.mode.pick(values, childDocsWithValues);
                return true;
            }
        };
    }

    private static class MultiFieldValuesToSingleValuesSource
    extends LongMultiValuesToSingleValuesSource {
        private final String field;

        private MultiFieldValuesToSingleValuesSource(String field, MultiValueMode mode, NestedDocsProvider nested) {
            super(mode, nested);
            this.field = field;
        }

        public String toString() {
            return "long(" + this.field + "," + this.mode + "," + this.nestedDocsProvider + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!super.equals(o)) {
                return false;
            }
            MultiFieldValuesToSingleValuesSource that = (MultiFieldValuesToSingleValuesSource)((Object)o);
            return Objects.equals(this.field, that.field);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.field);
        }

        public boolean needsScores() {
            return false;
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return DocValues.isCacheable((LeafReaderContext)ctx, (String[])new String[]{this.field});
        }

        public LongValuesSource rewrite(IndexSearcher searcher) {
            return this;
        }

        @Override
        protected SortedNumericDocValues getSortedNumericDocValues(LeafReaderContext ctx) throws IOException {
            return DocValues.getSortedNumeric((LeafReader)ctx.reader(), (String)this.field);
        }
    }

    private static class RawNumericDocValues
    extends NumericDocValues {
        private int docID = -1;
        private final LongValues values;

        public RawNumericDocValues(LongValues values) {
            this.values = values;
        }

        public boolean advanceExact(int target) throws IOException {
            this.docID = target;
            return this.values.advanceExact(target);
        }

        public long longValue() throws IOException {
            return this.values.longValue();
        }

        public int docID() {
            return this.docID;
        }

        public int nextDoc() {
            throw new UnsupportedOperationException();
        }

        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        public long cost() {
            throw new UnsupportedOperationException();
        }
    }
}

