/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.analysis.model.dsl.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharFilterFactory;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenizerFactory;
import org.hibernate.search.backend.lucene.analysis.impl.LuceneAnalysisComponentFactory;
import org.hibernate.search.backend.lucene.analysis.model.dsl.LuceneAnalysisComponentParametersStep;
import org.hibernate.search.backend.lucene.analysis.model.dsl.LuceneAnalyzerOptionalComponentsStep;
import org.hibernate.search.backend.lucene.analysis.model.dsl.LuceneAnalyzerTokenizerStep;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneAnalysisComponentBuilder;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneAnalyzerBuilder;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneCharFilterParametersStep;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneTokenFilterParametersStep;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneTokenizerParametersStep;
import org.hibernate.search.backend.lucene.logging.impl.AnalysisLog;

class LuceneAnalyzerComponentsStep
implements LuceneAnalyzerTokenizerStep,
LuceneAnalyzerOptionalComponentsStep,
LuceneAnalyzerBuilder {
    private final String name;
    private final LuceneTokenizerParametersStep tokenizer;
    private final List<LuceneCharFilterParametersStep> charFilters = new ArrayList<LuceneCharFilterParametersStep>();
    private final List<LuceneTokenFilterParametersStep> tokenFilters = new ArrayList<LuceneTokenFilterParametersStep>();

    LuceneAnalyzerComponentsStep(String name) {
        this.tokenizer = new LuceneTokenizerParametersStep(this);
        this.name = name;
    }

    @Override
    public LuceneAnalyzerOptionalComponentsStep tokenizer(String factoryName) {
        return this.tokenizer(TokenizerFactory.lookupClass((String)factoryName));
    }

    @Override
    public LuceneAnalyzerOptionalComponentsStep tokenizer(Class<? extends TokenizerFactory> factoryType) {
        this.tokenizer.factory(factoryType);
        return this;
    }

    @Override
    public LuceneAnalyzerOptionalComponentsStep param(String name, String value) {
        this.tokenizer.param(name, value);
        return this;
    }

    @Override
    public LuceneAnalysisComponentParametersStep charFilter(String factoryName) {
        return this.charFilter(CharFilterFactory.lookupClass((String)factoryName));
    }

    @Override
    public LuceneAnalysisComponentParametersStep charFilter(Class<? extends CharFilterFactory> factoryType) {
        LuceneCharFilterParametersStep filter = new LuceneCharFilterParametersStep(this, factoryType);
        this.charFilters.add(filter);
        return filter;
    }

    @Override
    public LuceneAnalysisComponentParametersStep tokenFilter(String factoryName) {
        return this.tokenFilter(TokenFilterFactory.lookupClass((String)factoryName));
    }

    @Override
    public LuceneAnalysisComponentParametersStep tokenFilter(Class<? extends TokenFilterFactory> factoryType) {
        LuceneTokenFilterParametersStep filter = new LuceneTokenFilterParametersStep(this, factoryType);
        this.tokenFilters.add(filter);
        return filter;
    }

    @Override
    public Analyzer build(LuceneAnalysisComponentFactory factory) {
        try {
            return factory.createAnalyzer(this.tokenizer.build(factory), (CharFilterFactory[])LuceneAnalysisComponentBuilder.buildAll(this.charFilters, CharFilterFactory[]::new, factory), (TokenFilterFactory[])LuceneAnalysisComponentBuilder.buildAll(this.tokenFilters, TokenFilterFactory[]::new, factory));
        }
        catch (IOException | RuntimeException e) {
            throw AnalysisLog.INSTANCE.unableToCreateAnalyzer(this.name, e.getMessage(), e);
        }
    }
}

