/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.document.Document;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentContentImpl;
import org.hibernate.search.backend.lucene.document.impl.LuceneFlattenedObjectFieldBuilder;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexFieldReference;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexObjectFieldReference;
import org.hibernate.search.backend.lucene.document.impl.LuceneNestedObjectFieldBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexCompositeNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexField;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexObjectField;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexValueField;
import org.hibernate.search.backend.lucene.logging.impl.IndexingLog;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexCompositeNodeType;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexValueFieldType;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.IndexObjectFieldReference;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldFilter;
import org.hibernate.search.engine.backend.document.spi.NoOpDocumentElement;

abstract class AbstractLuceneDocumentElementBuilder
implements DocumentElement {
    protected final LuceneIndexModel model;
    protected final LuceneIndexCompositeNode schemaNode;
    protected final LuceneDocumentContentImpl documentContent;
    private List<LuceneFlattenedObjectFieldBuilder> flattenedObjectDocumentBuilders;
    private List<LuceneNestedObjectFieldBuilder> nestedObjectDocumentBuilders;

    AbstractLuceneDocumentElementBuilder(LuceneIndexModel model, LuceneIndexCompositeNode schemaNode, LuceneDocumentContentImpl documentContent) {
        this.model = model;
        this.schemaNode = schemaNode;
        this.documentContent = documentContent;
    }

    public <F> void addValue(IndexFieldReference<F> fieldReference, F value) {
        LuceneIndexFieldReference luceneFieldReference = (LuceneIndexFieldReference)fieldReference;
        LuceneIndexValueField fieldSchemaNode = luceneFieldReference.getSchemaNode();
        this.addValue(fieldSchemaNode, value);
    }

    public DocumentElement addObject(IndexObjectFieldReference fieldReference) {
        LuceneIndexObjectFieldReference luceneFieldReference = (LuceneIndexObjectFieldReference)fieldReference;
        LuceneIndexObjectField fieldSchemaNode = luceneFieldReference.getSchemaNode();
        return this.addObject(fieldSchemaNode, false);
    }

    public void addNullObject(IndexObjectFieldReference fieldReference) {
        LuceneIndexObjectFieldReference luceneFieldReference = (LuceneIndexObjectFieldReference)fieldReference;
        LuceneIndexObjectField fieldSchemaNode = luceneFieldReference.getSchemaNode();
        this.addObject(fieldSchemaNode, true);
    }

    public void addValue(String relativeFieldName, Object value) {
        String absoluteFieldPath = this.schemaNode.absolutePath(relativeFieldName);
        LuceneIndexField node = (LuceneIndexField)this.model.fieldOrNull(absoluteFieldPath, IndexFieldFilter.ALL);
        if (node == null) {
            throw IndexingLog.INSTANCE.unknownFieldForIndexing(absoluteFieldPath, this.model.eventContext());
        }
        this.addValueUnknownType(node.toValueField(), value);
    }

    public DocumentElement addObject(String relativeFieldName) {
        String absoluteFieldPath = this.schemaNode.absolutePath(relativeFieldName);
        LuceneIndexField fieldSchemaNode = (LuceneIndexField)this.model.fieldOrNull(absoluteFieldPath, IndexFieldFilter.ALL);
        if (fieldSchemaNode == null) {
            throw IndexingLog.INSTANCE.unknownFieldForIndexing(absoluteFieldPath, this.model.eventContext());
        }
        return this.addObject(fieldSchemaNode.toObjectField(), false);
    }

    public void addNullObject(String relativeFieldName) {
        String absoluteFieldPath = this.schemaNode.absolutePath(relativeFieldName);
        LuceneIndexField fieldSchemaNode = (LuceneIndexField)this.model.fieldOrNull(absoluteFieldPath, IndexFieldFilter.ALL);
        if (fieldSchemaNode == null) {
            throw IndexingLog.INSTANCE.unknownFieldForIndexing(absoluteFieldPath, this.model.eventContext());
        }
        this.addObject(fieldSchemaNode.toObjectField(), true);
    }

    void checkNoValueYetForSingleValued(String absoluteFieldPath) {
        this.documentContent.checkNoValueYetForSingleValued(absoluteFieldPath);
    }

    private void addNestedObjectDocumentBuilder(LuceneNestedObjectFieldBuilder nestedObjectDocumentBuilder) {
        if (this.nestedObjectDocumentBuilders == null) {
            this.nestedObjectDocumentBuilders = new ArrayList<LuceneNestedObjectFieldBuilder>();
        }
        this.nestedObjectDocumentBuilders.add(nestedObjectDocumentBuilder);
    }

    private void addFlattenedObjectDocumentBuilder(LuceneFlattenedObjectFieldBuilder flattenedObjectDocumentBuilder) {
        if (this.flattenedObjectDocumentBuilders == null) {
            this.flattenedObjectDocumentBuilders = new ArrayList<LuceneFlattenedObjectFieldBuilder>();
        }
        this.flattenedObjectDocumentBuilders.add(flattenedObjectDocumentBuilder);
    }

    private void checkTreeConsistency(LuceneIndexCompositeNode expectedParentNode) {
        if (!Objects.equals(expectedParentNode, this.schemaNode)) {
            throw IndexingLog.INSTANCE.invalidFieldForDocumentElement(expectedParentNode.absolutePath(), this.schemaNode.absolutePath());
        }
    }

    void contribute(MultiTenancyStrategy multiTenancyStrategy, String tenantId, String routingKey, String rootId, List<Document> nestedDocuments) {
        if (this.flattenedObjectDocumentBuilders != null) {
            for (LuceneFlattenedObjectFieldBuilder flattenedObjectDocumentBuilder : this.flattenedObjectDocumentBuilders) {
                flattenedObjectDocumentBuilder.contribute(multiTenancyStrategy, tenantId, routingKey, rootId, nestedDocuments);
            }
        }
        if (this.nestedObjectDocumentBuilders != null) {
            for (LuceneNestedObjectFieldBuilder nestedObjectDocumentBuilder : this.nestedObjectDocumentBuilders) {
                nestedObjectDocumentBuilder.contribute(multiTenancyStrategy, tenantId, routingKey, rootId, nestedDocuments);
            }
        }
    }

    abstract void ensureDynamicValueDetectedByExistsPredicateOnObjectField();

    private <F> void addValue(LuceneIndexValueField<F> node, F value) {
        LuceneIndexCompositeNode expectedParentNode = (LuceneIndexCompositeNode)node.parent();
        this.checkTreeConsistency(expectedParentNode);
        LuceneIndexValueFieldType type = (LuceneIndexValueFieldType)node.type();
        String absolutePath = node.absolutePath();
        if (!node.multiValued()) {
            this.checkNoValueYetForSingleValued(absolutePath);
        }
        type.codec().addToDocument(this.documentContent, absolutePath, value);
        if (value != null && node.dynamic()) {
            this.ensureDynamicValueDetectedByExistsPredicateOnObjectField();
        }
    }

    private DocumentElement addObject(LuceneIndexObjectField node, boolean nullObject) {
        LuceneIndexCompositeNode expectedParentNode = (LuceneIndexCompositeNode)node.parent();
        this.checkTreeConsistency(expectedParentNode);
        String absolutePath = node.absolutePath();
        if (!node.multiValued()) {
            this.checkNoValueYetForSingleValued(absolutePath);
        }
        if (nullObject) {
            return NoOpDocumentElement.get();
        }
        if (((LuceneIndexCompositeNodeType)node.type()).nested()) {
            LuceneNestedObjectFieldBuilder nestedDocumentBuilder = new LuceneNestedObjectFieldBuilder(this.model, node, this);
            this.addNestedObjectDocumentBuilder(nestedDocumentBuilder);
            return nestedDocumentBuilder;
        }
        LuceneFlattenedObjectFieldBuilder flattenedDocumentBuilder = new LuceneFlattenedObjectFieldBuilder(this.model, node, this, this.documentContent);
        this.addFlattenedObjectDocumentBuilder(flattenedDocumentBuilder);
        return flattenedDocumentBuilder;
    }

    private void addValueUnknownType(LuceneIndexValueField<?> node, Object value) {
        if (value == null) {
            this.addValue(node, null);
        } else {
            LuceneIndexValueField<?> typeCheckedNode = node.withValueType(value.getClass(), this.model.eventContext());
            this.addValue(typeCheckedNode, value);
        }
    }
}

