/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.logging.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.CategorizedLogger;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;

@CategorizedLogger(category="org.hibernate.search.analysis.lucene", description="Logs related to the analysis specific to the Lucene backend.\nMay include information on misconfigured or misbehaving analyzers/normalisers.\n")
@MessageLogger(projectCode="HSEARCH")
public interface AnalysisLog {
    public static final String CATEGORY_NAME = "org.hibernate.search.analysis.lucene";
    public static final AnalysisLog INSTANCE = (AnalysisLog)LoggerFactory.make(AnalysisLog.class, (String)"org.hibernate.search.analysis.lucene", (MethodHandles.Lookup)MethodHandles.lookup());

    @Message(id=329, value="Unable to apply analysis configuration: %1$s")
    public SearchException unableToApplyAnalysisConfiguration(String var1, @Cause Exception var2);

    @Message(id=337, value="Ambiguous value for parameter '%1$s': this parameter is set to two different values '%2$s' and '%3$s'.")
    public SearchException analysisComponentParameterConflict(String var1, String var2, String var3);

    @Message(id=342, value="Invalid index field type: both analyzer '%1$s' and normalizer '%2$s' are assigned to this type. Either an analyzer or a normalizer can be assigned, but not both.")
    public SearchException cannotApplyAnalyzerAndNormalizer(String var1, String var2, @Param EventContext var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=344, value="Invalid normalizer implementation: the normalizer for definition '%s' produced %d tokens. Normalizers should never produce more than one token. The tokens have been concatenated by Hibernate Search, but you should fix your normalizer definition.")
    public void normalizerProducedMultipleTokens(String var1, int var2);

    @Message(id=345, value="Invalid index field type: both analyzer '%1$s' and sorts are enabled. Sorts are not supported on analyzed fields. If you need an analyzer simply to transform the text (lowercasing, ...) without splitting it into tokens, use a normalizer instead. If you need an actual analyzer (with tokenization), define two separate fields: one with an analyzer that is not sortable, and one with a normalizer that is sortable.")
    public SearchException cannotUseAnalyzerOnSortableField(String var1, @Param EventContext var2);

    @Message(id=353, value="Unknown analyzer: '%1$s'. Make sure you defined this analyzer.")
    public SearchException unknownAnalyzer(String var1, @Param EventContext var2);

    @Message(id=600052, value="Unable to create analyzer for name '%1$s': %2$s")
    public SearchException unableToCreateAnalyzer(String var1, String var2, @Cause Exception var3);

    @Message(id=600053, value="Unable to create normalizer for name '%1$s': %2$s")
    public SearchException unableToCreateNormalizer(String var1, String var2, @Cause Exception var3);

    @Message(id=600054, value="Unknown normalizer: '%1$s'. Make sure you defined this normalizer.")
    public SearchException unknownNormalizer(String var1, @Param EventContext var2);

    @Message(id=600073, value="Invalid index field type: both null token '%2$s' ('indexNullAs') and analyzer '%1$s' are assigned to this type. 'indexNullAs' is not supported on analyzed fields.")
    public SearchException cannotUseIndexNullAsAndAnalyzer(String var1, String var2, @Param EventContext var3);

    @Message(id=600094, value="Invalid index field type: both analyzer '%1$s' and aggregations are enabled. Aggregations are not supported on analyzed fields. If you need an analyzer simply to transform the text (lowercasing, ...) without splitting it into tokens, use a normalizer instead. If you need an actual analyzer (with tokenization), define two separate fields: one with an analyzer that is not aggregable, and one with a normalizer that is aggregable.")
    public SearchException cannotUseAnalyzerOnAggregableField(String var1, @Param EventContext var2);

    @Message(id=600104, value="Invalid index field type: search analyzer '%1$s' is assigned to this type, but the indexing analyzer is missing. Assign an indexing analyzer and a search analyzer, or remove the search analyzer.")
    public SearchException searchAnalyzerWithoutAnalyzer(String var1, @Param EventContext var2);

    @Message(id=600142, value="Unable to create instance of analysis component '%1$s': %2$s")
    public SearchException unableToCreateAnalysisComponent(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2, @Cause Exception var3);

    @Message(id=600181, value="An analyzer '%1$s' cannot be found.")
    public SearchException noSuchAnalyzer(String var1);

    @Message(id=600182, value="A normalizer '%1$s' cannot be found.")
    public SearchException noSuchNormalizer(String var1);

    @Message(id=600183, value="Failed to apply '%1$s' to '%2$s': '%3$s'")
    public SearchException unableToPerformAnalysisOperation(String var1, String var2, String var3, @Cause IOException var4);
}

