/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.logging.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.lucene.util.Version;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.CategorizedLogger;
import org.hibernate.search.util.common.logging.impl.EventContextFormatter;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;

@CategorizedLogger(category="org.hibernate.search.configuration.lucene", description="Logs related to the Lucene-specific backend configuration.\n")
@MessageLogger(projectCode="HSEARCH")
public interface ConfigurationLog
extends BasicLogger {
    public static final String CATEGORY_NAME = "org.hibernate.search.configuration.lucene";
    public static final ConfigurationLog INSTANCE = (ConfigurationLog)LoggerFactory.make(ConfigurationLog.class, (String)"org.hibernate.search.configuration.lucene", (MethodHandles.Lookup)MethodHandles.lookup());

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=75, value="Missing value for configuration property '%1$s': using LATEST (currently '%2$s'). %3$s")
    public void recommendConfiguringLuceneVersion(String var1, Version var2, @FormatWith(value=EventContextFormatter.class) EventContext var3);

    @Message(id=228, value="Unable to parse '%1$ss' into a Lucene version: %2$s")
    public SearchException illegalLuceneVersionFormat(String var1, String var2, @Cause Exception var3);

    @Message(id=600030, value="Invalid multi-tenancy strategy name: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidMultiTenancyStrategyName(String var1, List<String> var2);

    @Message(id=600031, value="Invalid tenant identifiers: '%1$s'. No tenant identifier is expected, because multi-tenancy is disabled for this backend.")
    public SearchException tenantIdProvidedButMultiTenancyDisabled(Set<String> var1, @Param EventContext var2);

    @Message(id=600032, value="Missing tenant identifier. A tenant identifier is expected, because multi-tenancy is enabled for this backend.")
    public SearchException multiTenancyEnabledButNoTenantIdProvided(@Param EventContext var1);

    @Message(id=600087, value="Invalid filesystem access strategy name: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidFileSystemAccessStrategyName(String var1, List<String> var2);

    @Message(id=600088, value="Invalid locking strategy name: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidLockingStrategyName(String var1, List<String> var2);

    @Message(id=600089, value="Incorrect sharding strategy implementation: strategy '%1$s' did not declare any shard identifiers during initialization. Declare shard identifiers using context.shardIdentifiers(...) or, if sharding is disabled, call context.disableSharding().")
    public SearchException missingShardIdentifiersAfterShardingStrategyInitialization(Object var1);

    @Message(id=600090, value="When using sharding strategy '%1$s', this configuration property must be set.")
    public SearchException missingPropertyValueForShardingStrategy(String var1);

    @Message(id=600091, value="Invalid routing key: '%1$s'. Valid keys are: %2$s.")
    public SearchException invalidRoutingKeyForExplicitShardingStrategy(String var1, Collection<String> var2);

    @Message(id=600108, value="Invalid I/O strategy name: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidIOStrategyName(String var1, List<String> var2);

    @Message(id=600123, value="Invalid value for IndexWriter setting '%1$s': '%2$s'. %3$s")
    public SearchException illegalIndexWriterSetting(String var1, Object var2, String var3, @Cause Exception var4);

    @Message(id=600124, value="Invalid value for merge policy setting '%1$s': '%2$s'. %3$s")
    public SearchException illegalMergePolicySetting(String var1, Object var2, String var3, @Cause Exception var4);

    @Message(id=600146, value="Unable to apply query caching configuration: %1$s")
    public SearchException unableToApplyQueryCacheConfiguration(String var1, @Cause Exception var2);

    @Message(id=600148, value="Invalid backend configuration: mapping requires multi-tenancy but no multi-tenancy strategy is set.")
    public SearchException multiTenancyRequiredButExplicitlyDisabledByBackend();

    @Message(id=600149, value="Invalid backend configuration: mapping requires single-tenancy but multi-tenancy strategy is set.")
    public SearchException multiTenancyNotRequiredButExplicitlyEnabledByTheBackend();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=600188, value="Setting Lucene compatibility to Version %s")
    public void luceneCompatibilityVersion(Version var1);
}

