/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.logging.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import org.hibernate.search.backend.lucene.logging.impl.MappingLog;
import org.hibernate.search.engine.backend.types.Highlightable;
import org.hibernate.search.engine.backend.types.TermVector;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.Logger;

public class MappingLog_$logger
implements MappingLog,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = MappingLog_$logger.class.getName();
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;

    public MappingLog_$logger(Logger log) {
        this.log = log;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String indexSchemaNodeNameConflict$str() {
        return "HSEARCH600034: Duplicate index field definition: '%1$s'. Index field names must be unique. Look for two property mappings with the same field name, or two indexed-embeddeds with prefixes that lead to conflicting index field names, or two custom bridges declaring index fields with the same name.";
    }

    @Override
    public final SearchException indexSchemaNodeNameConflict(String relativeFieldName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexSchemaNodeNameConflict$str(), relativeFieldName), context);
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String cannotGuessFieldType$str() {
        return "HSEARCH600062: No built-in index field type for class: '%1$s'.";
    }

    @Override
    public final SearchException cannotGuessFieldType(Class<?> inputType, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotGuessFieldType$str(), new ClassFormatter(inputType)), context);
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String incompleteFieldDefinition$str() {
        return "HSEARCH600071: Incomplete field definition. You must call toReference() to complete the field definition.";
    }

    @Override
    public final SearchException incompleteFieldDefinition(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.incompleteFieldDefinition$str(), new Object[0]), context);
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotCreateReferenceMultipleTimes$str() {
        return "HSEARCH600072: Multiple calls to toReference() for the same field definition. You must call toReference() exactly once.";
    }

    @Override
    public final SearchException cannotCreateReferenceMultipleTimes(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotCreateReferenceMultipleTimes$str(), new Object[0]), context);
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String nullDecimalScale$str() {
        return "HSEARCH600080: Invalid index field type: missing decimal scale. Define the decimal scale explicitly. %1$s";
    }

    @Override
    public final SearchException nullDecimalScale(String hint, EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nullDecimalScale$str(), hint), eventContext);
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidDecimalScale$str() {
        return "HSEARCH600082: Invalid index field type: decimal scale '%1$s' is positive. The decimal scale of BigInteger fields must be zero or negative.";
    }

    @Override
    public final SearchException invalidDecimalScale(Integer decimalScale, EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidDecimalScale$str(), decimalScale), eventContext);
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String indexSchemaFieldTemplateNameConflict$str() {
        return "HSEARCH600125: Duplicate index field template definition: '%1$s'. Multiple bridges may be trying to access the same index field template,  or two indexed-embeddeds may have prefixes that lead to conflicting field names, or you may have declared multiple conflicting mappings. In any case, there is something wrong with your mapping and you should fix it.";
    }

    @Override
    public final SearchException indexSchemaFieldTemplateNameConflict(String name, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexSchemaFieldTemplateNameConflict$str(), name), context);
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String indexSchemaNamedPredicateNameConflict$str() {
        return "HSEARCH600143: The index schema named predicate '%1$s' was added twice.";
    }

    @Override
    public final SearchException indexSchemaNamedPredicateNameConflict(String relativeFilterName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexSchemaNamedPredicateNameConflict$str(), relativeFilterName), context);
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unsupportedMixOfHighlightableValues$str() {
        return "HSEARCH600166: Cannot use 'NO' in combination with other highlightable values. Applied values are: '%1$s'";
    }

    @Override
    public final SearchException unsupportedMixOfHighlightableValues(Set<Highlightable> highlightable) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedMixOfHighlightableValues$str(), highlightable));
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String termVectorDontAllowFastVectorHighlighter$str() {
        return "HSEARCH600167: The '%1$s' term vector storage strategy is not compatible with the fast vector highlighter. Either change the strategy to one of `WITH_POSITIONS_PAYLOADS`/`WITH_POSITIONS_OFFSETS_PAYLOADS` or remove the requirement for the fast vector highlighter support.";
    }

    @Override
    public final SearchException termVectorDontAllowFastVectorHighlighter(TermVector termVector) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.termVectorDontAllowFastVectorHighlighter$str(), termVector));
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noHighlightableProvided$str() {
        return "HSEARCH600168: Setting the `highlightable` attribute to an empty array is not supported. Set the value to `NO` if the field does not require the highlight projection.";
    }

    @Override
    public final SearchException noHighlightableProvided() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noHighlightableProvided$str(), new Object[0]));
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String vectorPropertyUnsupportedValue$str() {
        return "HSEARCH600174: Vector '%1$s' cannot be equal to '%2$s'. It must be a positive integer value lesser than or equal to %3$s.";
    }

    @Override
    public final SearchException vectorPropertyUnsupportedValue(String property, Integer value, int max) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.vectorPropertyUnsupportedValue$str(), property, value, max));
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotGuessVectorFieldType$str() {
        return "HSEARCH600175: No built-in vector index field type for class: '%1$s'.";
    }

    @Override
    public final SearchException cannotGuessVectorFieldType(Class<?> inputType, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotGuessVectorFieldType$str(), new ClassFormatter(inputType)), context);
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multiValuedFieldNotAllowed$str() {
        return "HSEARCH600177: Fields of this type cannot be multivalued.";
    }

    @Override
    public final SearchException multiValuedFieldNotAllowed(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multiValuedFieldNotAllowed$str(), new Object[0]), context);
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String nullVectorDimension$str() {
        return "HSEARCH600179: Invalid index field type: missing vector dimension. Define the vector dimension explicitly. %1$s";
    }

    @Override
    public final SearchException nullVectorDimension(String hint, EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nullVectorDimension$str(), hint), eventContext);
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

