/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.logging.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.index.LuceneIndexManager;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;
import org.hibernate.search.engine.logging.spi.AggregationKeyFormatter;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.engine.search.common.SortMode;
import org.hibernate.search.engine.search.highlighter.SearchHighlighter;
import org.hibernate.search.engine.search.highlighter.spi.BoundaryScannerType;
import org.hibernate.search.engine.search.highlighter.spi.SearchHighlighterType;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.CategorizedLogger;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;

@CategorizedLogger(category="org.hibernate.search.query.lucene", description="Logs the Lucene queries that are about to be executed and other query related messages.\n")
@MessageLogger(projectCode="HSEARCH")
public interface QueryLog {
    public static final String CATEGORY_NAME = "org.hibernate.search.query.lucene";
    public static final QueryLog INSTANCE = (QueryLog)LoggerFactory.make(QueryLog.class, (String)"org.hibernate.search.query.lucene", (MethodHandles.Lookup)MethodHandles.lookup());

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=274, value="Executing Lucene query: %s")
    public void executingLuceneQuery(Query var1);

    @Message(id=600010, value="Invalid search predicate: '%1$s'. You must build the predicate from a Lucene search scope.")
    public SearchException cannotMixLuceneSearchQueryWithOtherPredicates(SearchPredicate var1);

    @Message(id=600014, value="Invalid search sort: '%1$s'. You must build the sort from a Lucene search scope.")
    public SearchException cannotMixLuceneSearchSortWithOtherSorts(SearchSort var1);

    @Message(id=600024, value="Invalid multi-index scope: a scope cannot span both a Lucene index and another type of index. Base scope: '%1$s', incompatible (Lucene) index: '%2$s'.")
    public SearchException cannotMixLuceneScopeWithOtherType(IndexScopeBuilder<?> var1, LuceneIndexManager var2, @Param EventContext var3);

    @Message(id=600025, value="Invalid multi-index scope: a scope cannot span multiple Lucene backends. Base scope: '%1$s', incompatible index (from another backend): '%2$s'.")
    public SearchException cannotMixLuceneScopeWithOtherBackend(IndexScopeBuilder<?> var1, LuceneIndexManager var2, @Param EventContext var3);

    @Message(id=600027, value="Unable to execute search query '%1$s': %2$s")
    public SearchException ioExceptionOnQueryExecution(Query var1, String var2, @Param EventContext var3, @Cause IOException var4);

    @Message(id=600044, value="Computed minimum for minimumShouldMatch constraint is out of bounds: expected a number between '1' and '%1$s', got '%2$s'.")
    public SearchException minimumShouldMatchMinimumOutOfBounds(int var1, int var2);

    @Message(id=600045, value="Multiple conflicting minimumShouldMatch constraints for ceiling '%1$s'")
    public SearchException minimumShouldMatchConflictingConstraints(int var1);

    @Message(id=600055, value="Invalid search projection: '%1$s'. You must build the projection from a Lucene search scope.")
    public SearchException cannotMixLuceneSearchQueryWithOtherProjections(SearchProjection<?> var1);

    @Message(id=600067, value="Unable to delete all entries matching query '%1$s': %2$s")
    public SearchException unableToDeleteAllEntriesFromIndex(Query var1, String var2, @Param EventContext var3, @Cause Exception var4);

    @Message(id=600070, value="Full-text features (analysis, fuzziness, minimum should match) are not supported for fields of this type.")
    public SearchException fullTextFeaturesNotSupportedByFieldType(@Param EventContext var1);

    @Message(id=600075, value="Invalid use of explain(Object id) on a query targeting multiple types. Use explain(String typeName, Object id) and pass one of %1$s as the type name.")
    public SearchException explainRequiresTypeName(Set<String> var1);

    @Message(id=600076, value="Invalid mapped type name: '%2$s'. This type is not among the mapped types targeted by this query: %1$s.")
    public SearchException explainRequiresTypeTargetedByQuery(Set<String> var1, String var2);

    @Message(id=600077, value="Invalid document identifier: '%2$s'. No such document for type '%1$s'.")
    public SearchException explainUnknownDocument(String var1, String var2);

    @Message(id=600084, value="Invalid search predicate: '%1$s'. You must build the predicate from a scope targeting indexes %3$s or a superset of them, but the given predicate was built from a scope targeting indexes %2$s, where indexes %4$s are missing.")
    public SearchException predicateDefinedOnDifferentIndexes(SearchPredicate var1, Set<String> var2, Set<String> var3, Set<String> var4);

    @Message(id=600085, value="Invalid search sort: '%1$s'. You must build the sort from a scope targeting indexes %3$s or a superset of them, but the given sort was built from a scope targeting indexes %2$s, where indexes %4$s are missing.")
    public SearchException sortDefinedOnDifferentIndexes(SearchSort var1, Set<String> var2, Set<String> var3, Set<String> var4);

    @Message(id=600086, value="Invalid search projection: '%1$s'. You must build the projection from a scope targeting indexes %3$s or a superset of them, but the given projection was built from a scope targeting indexes %2$s, where indexes %4$s are missing.")
    public SearchException projectionDefinedOnDifferentIndexes(SearchProjection<?> var1, Set<String> var2, Set<String> var3, Set<String> var4);

    @Message(id=600098, value="Invalid search aggregation: '%1$s'. You must build the aggregation from a Lucene search scope.")
    public SearchException cannotMixLuceneSearchQueryWithOtherAggregations(SearchAggregation<?> var1);

    @Message(id=600099, value="Invalid search aggregation: '%1$s'. You must build the aggregation from a scope targeting indexes %3$s or a superset of them, but the given aggregation was built from a scope targeting indexes %2$s, where indexes %4$s are missing")
    public SearchException aggregationDefinedOnDifferentIndexes(SearchAggregation<?> var1, Set<String> var2, Set<String> var3, Set<String> var4);

    @Message(id=600102, value="Duplicate aggregation definitions for key: '%1$s'")
    public SearchException duplicateAggregationKey(@FormatWith(value=AggregationKeyFormatter.class) AggregationKey<?> var1);

    @Message(id=600114, value="Invalid sort mode: %1$s. This sort mode is not supported for fields in nested documents.")
    public SearchException invalidSortModeAcrossNested(SortMode var1, @Param EventContext var2);

    @Message(id=600115, value="Invalid sort mode: %1$s. This sort mode is not supported for String fields. Only MIN and MAX are supported.")
    public SearchException invalidSortModeForStringField(SortMode var1, @Param EventContext var2);

    @Message(id=600116, value="Invalid sort mode: %1$s. This sort mode is not supported for temporal fields. Only MIN, MAX, AVG and MEDIAN are supported.")
    public SearchException invalidSortModeForTemporalField(SortMode var1, @Param EventContext var2);

    @Message(id=600120, value="Invalid sort filter: field '%1$s' is not contained in a nested object. Sort filters are only available if the field to sort on is contained in a nested object.")
    public SearchException cannotFilterSortOnRootDocumentField(String var1, @Param EventContext var2);

    @Message(id=600121, value="Invalid search predicate: %1$s. This predicate targets fields %3$s, but only fields that are contained in the nested object with path '%2$s' are allowed here.")
    public SearchException invalidNestedObjectPathForPredicate(SearchPredicate var1, String var2, List<String> var3);

    @Message(id=600122, value="Invalid aggregation filter: field '%1$s' is not contained in a nested object. Aggregation filters are only available if the field to aggregate on is contained in a nested object.")
    public SearchException cannotFilterAggregationOnRootDocumentField(String var1, @Param EventContext var2);

    @Message(id=600131, value="Invalid cardinality for projection on field '%1$s': the projection is single-valued, but this field is multi-valued. Make sure to call '.collector(...)' when you create the projection.")
    public SearchException invalidSingleValuedProjectionOnMultiValuedField(String var1, @Param EventContext var2);

    @Message(id=600135, value="Implementation class differs: '%1$s' vs. '%2$s'.")
    public SearchException differentImplementationClassForQueryElement(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @Message(id=600136, value="Field codec differs: '%1$s' vs. '%2$s'.")
    public SearchException differentFieldCodecForQueryElement(Object var1, Object var2);

    @Message(id=600144, value="Predicate definition differs: '%1$s' vs. '%2$s'.")
    public SearchException differentPredicateDefinitionForQueryElement(Object var1, Object var2);

    @Message(id=600150, value="Param with name '%1$s' has not been defined for the named predicate '%2$s'.")
    public SearchException paramNotDefined(String var1, String var2, @Param EventContext var3);

    @Message(id=600151, value="Offset + limit should be lower than Integer.MAX_VALUE, offset: '%1$s', limit: '%2$s'.")
    public IOException offsetLimitExceedsMaxValue(int var1, Integer var2);

    @Message(id=600152, value="Invalid context for projection on field '%1$s': the surrounding projection is executed for each object in field '%2$s', which is not a parent of field '%1$s'. Check the structure of your projections.")
    public SearchException invalidContextForProjectionOnField(String var1, String var2);

    @Message(id=600153, value="Invalid cardinality for projection on field '%1$s': the projection is single-valued, but this field is effectively multi-valued in this context, because parent object field '%2$s' is multi-valued. Either call '.collector(...)' when you create the projection on field '%1$s', or wrap that projection in an object projection like this: 'f.object(\"%2$s\").from(<the projection on field %1$s>).as(...).collector(...)'.")
    public SearchException invalidSingleValuedProjectionOnValueFieldInMultiValuedObjectField(String var1, String var2);

    @Message(id=600155, value="Unexpected mapped type name extracted from hits: '%1$s'. Expected one of: %2$s. The document was probably indexed with a different configuration: full reindexing is necessary.")
    public SearchException unexpectedMappedTypeNameForByMappedTypeProjection(String var1, Set<String> var2);

    @Message(id=600158, value="Invalid highlighter: '%1$s'. You must build the highlighter from a Lucene search scope.")
    public SearchException cannotMixLuceneSearchQueryWithOtherQueryHighlighters(SearchHighlighter var1);

    @Message(id=600159, value="Invalid highlighter: '%1$s'. You must build the highlighter from a scope targeting indexes %3$s or a superset of them, but the given highlighter was built from a scope targeting indexes %2$s, where indexes %4$s are missing.")
    public SearchException queryHighlighterDefinedOnDifferentIndexes(SearchHighlighter var1, Set<String> var2, Set<String> var3, Set<String> var4);

    @Message(id=600160, value="Overriding a '%2$s' highlighter with a '%1$s' is not supported. Overriding highlighters should be of the same type as the global is if the global highlighter was configured.")
    public SearchException cannotMixDifferentHighlighterTypesAtOverrideLevel(SearchHighlighterType var1, SearchHighlighterType var2);

    @Message(id=600161, value="Cannot find a highlighter with name '%1$s'. Available highlighters are: %2$s. Was it configured with `highlighter(\"%1$s\", highlighterContributor)`?")
    public SearchException cannotFindHighlighterWithName(String var1, Collection<String> var2);

    @Message(id=600162, value="'%1$s' highlighter does not support '%2$s' boundary scanner type.")
    public SearchException unsupportedBoundaryScannerType(String var1, BoundaryScannerType var2);

    @Message(id=600163, value="Named highlighters cannot use a blank string as name.")
    public SearchException highlighterNameCannotBeBlank();

    @Message(id=600164, value="Highlighter with name '%1$s' is already defined. Use a different name to add another highlighter.")
    public SearchException highlighterWithTheSameNameCannotBeAdded(String var1);

    @Message(id=600165, value="'%1$s' highlighter type cannot be applied to '%2$s' field. '%2$s' must have either 'ANY' or '%1$s' among the configured highlightable values.")
    public SearchException highlighterTypeNotSupported(SearchHighlighterType var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=600169, value="Lucene's unified highlighter cannot limit the size of a fragment returned when no match is found. Instead if no match size was set to any positive integer - all text will be returned. Configured value '%1$s' will be ignored, and the fragment will not be limited. If you don't want to see this warning set the value to Integer.MAX_VALUE.")
    public void unifiedHighlighterNoMatchSizeWarning(Integer var1);

    @Message(id=600170, value="Lucene's unified highlighter does not support the size fragment setting. Either use a plain or fast vector highlighters, or do not set this setting.")
    public SearchException unifiedHighlighterFragmentSizeNotSupported();

    @Message(id=600171, value="Highlight projection cannot be applied within nested context of '%1$s'.")
    public SearchException cannotHighlightInNestedContext(String var1, @Param EventContext var2);

    @Message(id=600172, value="The highlight projection cannot be applied to a field from an object using `ObjectStructure.NESTED` structure.")
    public SearchException cannotHighlightFieldFromNestedObjectStructure(@Param EventContext var1);

    @Message(id=600173, value="'%1$s' cannot be nested in an object projection. %2$s")
    public SearchException cannotUseProjectionInNestedContext(String var1, String var2, @Param EventContext var3);

    @Message(id=600117, value="Invalid sort mode: %1$s. This sort mode is not supported for a distance sort. Only MIN, MAX, AVG and MEDIAN are supported.")
    public SearchException invalidSortModeForDistanceSort(SortMode var1, @Param EventContext var2);

    @Message(id=600176, value="Vector field '%1$s' is defined as a '%2$s' array. Matching against '%3$s' array is unsupported. Use the array of the same type as the vector field.")
    public SearchException vectorKnnMatchVectorTypeDiffersFromField(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @FormatWith(value=ClassFormatter.class) Class<?> var3);

    @Message(id=600178, value="Vector field '%1$s' is defined as a vector with '%2$s' dimensions (array length). Matching against an array with length of '%3$s' is unsupported. Use the array of the same size as the vector field.")
    public SearchException vectorKnnMatchVectorDimensionDiffersFromField(String var1, int var2, int var3);

    @Message(id=600180, value="An error occurred while parsing the query string '%1$s': %2$s")
    public SearchException queryStringParseException(String var1, String var2, @Cause Exception var3);

    @Message(id=600186, value="A single-valued highlight projection requested, but the corresponding highlighter does not set number of fragments to 1.")
    public SearchException highlighterIncompatibleCardinality();

    @Message(id=600194, value="Current factory cannot be resocped to '%1$s' as it is scoped to '%2$s'.")
    public SearchException incompatibleScopeRootType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=600195, value="Configured query cache policy is ineffective as query cache is not enabled. Set the cache explicitly through the QueryCachingConfigurer.")
    public void ineffectiveQueryCachingPolicy();
}

