/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl;

import java.util.Locale;
import org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl.DoubleAggregationFunction;
import org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl.KahanSummation;

public class CompensatedSum
implements DoubleAggregationFunction<CompensatedSum> {
    private final KahanSummation kahanSummation = new KahanSummation(0.0, 0.0);

    @Override
    public void apply(double value) {
        this.kahanSummation.add(value);
    }

    @Override
    public void merge(DoubleAggregationFunction<CompensatedSum> sibling) {
        KahanSummation other = sibling.implementation().kahanSummation;
        if (other.initialized()) {
            this.kahanSummation.add(other.value(), other.delta());
        }
    }

    @Override
    public Double result() {
        if (this.kahanSummation.initialized()) {
            return this.kahanSummation.value();
        }
        return null;
    }

    @Override
    public CompensatedSum implementation() {
        return this;
    }

    public String toString() {
        return String.format(Locale.ROOT, "CompensatedSum{kahanSummation=%s}", this.kahanSummation);
    }
}

