/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl;

import java.io.IOException;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl.DoubleAggregationFunction;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.LongMultiValues;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.LongMultiValuesSource;

public class DoubleAggregationFunctionCollector<AF extends DoubleAggregationFunction<?>>
extends SimpleCollector {
    private final LongMultiValuesSource valueSource;
    private final DoubleAggregationFunction<AF> aggregationFunction;
    private final Function<Long, Double> longToDouble;
    private LongMultiValues values;

    public DoubleAggregationFunctionCollector(LongMultiValuesSource valueSource, DoubleAggregationFunction<AF> aggregationFunction, Function<Long, Double> longToDouble) {
        this.valueSource = valueSource;
        this.aggregationFunction = aggregationFunction;
        this.longToDouble = longToDouble;
    }

    public void merge(DoubleAggregationFunctionCollector<AF> sibling) {
        this.aggregationFunction.merge(sibling.aggregationFunction);
    }

    public Double result() {
        return this.aggregationFunction.result();
    }

    public void collect(int doc) throws IOException {
        if (this.values.advanceExact(doc)) {
            while (this.values.hasNextValue()) {
                long value = this.values.nextValue();
                this.aggregationFunction.apply(this.longToDouble.apply(value));
            }
        }
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.values = this.valueSource.getValues(context);
    }

    public void finish() throws IOException {
        this.values = null;
    }
}

